/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.pivot;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.ComputedColumnUtils;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.pivot.PivotElement;
import com.dataiku.dip.dataflow.exec.pivot.PivotElementSchemaGenerator;
import com.dataiku.dip.dataflow.exec.pivot.PivotElementsModalitiesSnapshot;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipePayloadParams;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.server.recipes.GroupingSchemaGenerator;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PivotSchemaGenerator {
    private final PivotRecipePayloadParams params;

    public PivotSchemaGenerator(PivotRecipePayloadParams params) {
        this.params = params;
    }

    public Schema generateForPivotStage(Schema inputSchema) {
        Schema schema = new Schema(inputSchema);
        if (this.params.computedColumns != null && !this.params.computedColumns.isEmpty()) {
            for (ComputedColumn computedColumn : this.params.computedColumns) {
                ComputedColumnUtils.addToSchema(schema, computedColumn);
            }
        }
        return schema;
    }

    public Schema generate(Schema inputSchema, List<String> identifiers, List<PivotElementsModalitiesSnapshot.PivotElementsModalities> pivotElementsModalities, Integer identifierMaxLength, boolean lowercaseColumnNames) throws Exception {
        SchemaColumn column;
        Schema pivotStageSchema = this.generateForPivotStage(inputSchema);
        HashSet keyColumns = Sets.newHashSet();
        Schema filteredSchema = new Schema();
        for (String key : identifiers) {
            if (keyColumns.contains(key)) continue;
            keyColumns.add(key);
            column = pivotStageSchema.getColumn(key);
            if (column == null) {
                throw new CodedException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_PIVOT_UNKNOWN_COLUMN, "Identifier column '" + key + "' not found");
            }
            filteredSchema.addColumn(column);
        }
        for (GroupingRecipePayloadParams.GroupingValue otherColumn : this.params.otherColumns) {
            if (keyColumns.contains(otherColumn.column)) continue;
            keyColumns.add(otherColumn.column);
            column = pivotStageSchema.getColumn(otherColumn.column);
            if (column == null) {
                throw new CodedException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_PIVOT_UNKNOWN_COLUMN, "Other column '" + otherColumn.column + "' not found");
            }
            filteredSchema.addColumn(column);
        }
        for (PivotElement pivot : this.params.pivots) {
            this.generateForPivot(pivotStageSchema, keyColumns, filteredSchema, pivot);
        }
        for (PivotElementsModalitiesSnapshot.PivotElementsModalities pivotElementModalities : pivotElementsModalities) {
            filteredSchema = new PivotElementSchemaGenerator(pivotStageSchema).generate(filteredSchema, pivotElementModalities.pivotedModalities);
        }
        GroupingRecipePayloadParams groupingParams = this.params.generateGroupingRecipeParams(identifiers, pivotElementsModalities, filteredSchema);
        Schema groupedSchema = GroupingSchemaGenerator.withSchemalessSuffixing(filteredSchema).getBaseOutputSchema(groupingParams, identifierMaxLength);
        if (lowercaseColumnNames) {
            for (SchemaColumn schemaColumn : groupedSchema.getColumns()) {
                schemaColumn.setName(schemaColumn.getName().toLowerCase());
            }
        }
        return groupedSchema;
    }

    private void generateForPivot(Schema pivotStageSchema, Set<String> keyColumns, Schema filteredSchema, PivotElement pivot) throws Exception {
        SchemaColumn column;
        for (String key : pivot.keyColumns) {
            if (keyColumns.contains(key)) continue;
            keyColumns.add(key);
            column = pivotStageSchema.getColumn(key);
            if (column == null) {
                throw new CodedException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_PIVOT_UNKNOWN_COLUMN, "Key column '" + key + "' not found");
            }
            filteredSchema.addColumn(column);
        }
        for (GroupingRecipePayloadParams.GroupingValue value : pivot.valueColumns) {
            if (!value.first && !value.last || keyColumns.contains(value.orderColumn)) continue;
            keyColumns.add(value.orderColumn);
            column = pivotStageSchema.getColumn(value.orderColumn);
            if (column == null) {
                throw new CodedException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_PIVOT_UNKNOWN_COLUMN, "Key column '" + value.orderColumn + "' not found");
            }
            filteredSchema.addColumn(column);
        }
    }
}

