/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graphtools;

import com.dataiku.dip.dataflow.graph.utils.GraphIds;
import com.dataiku.dip.dataflow.graphtools.AbstractFlowTool;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.scenarios.StepBasedScenarioRunner;
import com.dataiku.dip.scheduler.steps.FlowComputableSpecification;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepParamsWithComputables;
import com.dataiku.dip.scheduler.steps.StepRegistry;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class ScenariosView
extends AbstractFlowTool.FlowView {
    private ScenariosViewState state;
    static DKULogger logger = DKULogger.getLogger((String)"dku.flow.tools.scheduling");

    public ScenariosView(AuthCtx authCtx, String projectKey, JsonObject toolInitialData) {
        super(authCtx, projectKey);
    }

    @Override
    public AbstractFlowTool.FlowState getFlowState(JsonObject options) throws Exception {
        return this.computeState();
    }

    @Override
    public synchronized ScenariosViewState computeState() throws Exception {
        this.state = new ScenariosViewState();
        try (Transaction tr = this.transactionService.beginRead();){
            for (Scenario sc : this.scenariosDAO.listUnsafe(this.projectKey)) {
                FutureProgressState.checkInterrupt();
                try {
                    if (!StepBasedScenarioRunner.META.getType().equals(sc.type)) continue;
                    this.add(sc);
                }
                catch (Exception e) {
                    logger.info((Object)"Failed to get scenario data", (Throwable)e);
                }
            }
        }
        return this.state;
    }

    @Override
    public void setFocus(Collection<String> focused) throws Exception {
        if (this.state == null) {
            this.computeState();
        }
        this.state.focused = focused == null ? new HashSet<String>() : focused;
    }

    private void add(Scenario sc) {
        StepBasedScenarioRunner.StepBasedScenarioParams params = sc.getParamsAs(StepBasedScenarioRunner.StepBasedScenarioParams.class);
        for (Step step : params.steps) {
            try {
                if (!(step.params instanceof StepParamsWithComputables)) continue;
                StepParamsWithComputables stepParams = (StepParamsWithComputables)((Object)step.params);
                for (FlowComputableSpecification item : stepParams.getComputablesSpec()) {
                    if (StringUtils.isNotBlank((String)item.projectKey) && !this.projectKey.equals(item.projectKey)) continue;
                    TaggableObjectsService.TaggableObjectRef ref = new TaggableObjectsService.TaggableObjectRef(this.projectKey, item.type.toTaggableType(), item.itemId);
                    String nodeId = GraphIds.forRef(ref);
                    this.add(nodeId, sc, StepRegistry.getMeta(step).getType());
                }
            }
            catch (Exception e) {
                logger.info((Object)"Failed to get scheduling data");
            }
        }
    }

    private void add(String nodeId, Scenario sc, String action) {
        if (!this.state.valueByNode.containsKey(nodeId)) {
            this.state.valueByNode.put(nodeId, new ArrayList());
        }
        UseInScenario use = null;
        for (UseInScenario u : this.state.valueByNode.get(nodeId)) {
            if (!u.scenarioId.equals(sc.getId())) continue;
            use = u;
            break;
        }
        if (use == null) {
            use = new UseInScenario();
            use.scenarioId = sc.getId();
            use.scenarioName = sc.name;
            this.state.valueByNode.get(nodeId).add(use);
        }
        use.actions.add(action);
    }

    class ScenariosViewState
    implements AbstractFlowTool.FlowState {
        Map<String, List<UseInScenario>> valueByNode = new HashMap<String, List<UseInScenario>>();
        Collection<String> focused;

        ScenariosViewState() {
        }
    }

    class UseInScenario {
        String scenarioId;
        String scenarioName;
        Set<String> actions = new HashSet<String>();

        UseInScenario() {
        }
    }
}

