/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.kernel.master;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.JobDef;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dataflow.ActivityState;
import com.dataiku.dip.dataflow.FlowGraph;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.JobState;
import com.dataiku.dip.dataflow.JobTicketUtils;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.dataflow.graph.utils.GraphSerializerCommon;
import com.dataiku.dip.dataflow.jobrunner.JobBackendLoggingContext;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.jobrunner.SerializedJob;
import com.dataiku.dip.dataflow.jobrunner.SerializedJobActivity;
import com.dataiku.dip.dataflow.jobrunner.status.CoreJobStatus;
import com.dataiku.dip.dataflow.jobrunner.status.SerializedJobActivityStatus;
import com.dataiku.dip.dataflow.jobrunner.status.SerializedJobStatus;
import com.dataiku.dip.dataflow.kernel.Model;
import com.dataiku.dip.dataflow.kernel.master.ActivityRunLimiter;
import com.dataiku.dip.dataflow.kernel.master.ActivityRunRequest;
import com.dataiku.dip.dataflow.kernel.master.BuildState;
import com.dataiku.dip.dataflow.kernel.master.BuildUtils;
import com.dataiku.dip.dataflow.kernel.master.JobExecutionKernelHandle;
import com.dataiku.dip.dataflow.kernel.master.JobKernelsManager;
import com.dataiku.dip.dataflow.kernel.master.JobSession;
import com.dataiku.dip.dataflow.kernel.master.JobTaskQueue;
import com.dataiku.dip.dataflow.kernel.master.locking.BalancedPrioritizationStrategy;
import com.dataiku.dip.dataflow.kernel.master.locking.ConstrainedLock;
import com.dataiku.dip.dataflow.kernel.master.locking.Permit;
import com.dataiku.dip.dataflow.kernel.master.locking.PermitStatus;
import com.dataiku.dip.dataflow.kernel.master.postactions.PostJobActionsHandler;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.kernels.DSSKernelManagerBase;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.metrics.MetricsLaunchService;
import com.dataiku.dip.plugins.model.CustomCodeRecipeDesc;
import com.dataiku.dip.processes.AbstractCGroupHelper;
import com.dataiku.dip.recipes.RecipeDesc;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.ProcessResourceUsageMonitor;
import com.dataiku.dip.resourceusage.WithMaybePid;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.impersonation.FilesystemACLHandler;
import com.dataiku.dip.security.impersonation.ImpersonationResolverService;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.intercom.t.JobsIntercomController;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.DSSEventListener;
import com.dataiku.dip.server.notifications.backend.ActivityDoneEvent;
import com.dataiku.dip.server.notifications.backend.ActivityStartedEvent;
import com.dataiku.dip.server.notifications.backend.JobDoneEvent;
import com.dataiku.dip.server.notifications.backend.JobStartedEvent;
import com.dataiku.dip.server.notifications.backend.JobStatusUpdatedEvent;
import com.dataiku.dip.server.services.CachesPreloadingService;
import com.dataiku.dip.server.services.FlowExecutionService2;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.dataquality.AbstractCheckReport;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BuildService {
    @Autowired
    private JobKernelsManager kernelsManager;
    @Autowired
    private ReadWriteJobsInternalDB dbService;
    @Autowired
    private BuildState buildState;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    @Autowired
    private RetrievableKnowledgeDAO retrievableKnowledgeDAO;
    @Autowired
    private GeneralSettingsService generalSettingsService;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private FlowGraphService graphService;
    @Autowired
    private MetricsLaunchService metricsLaunchService;
    @Autowired
    private APITicketService apiTicketService;
    @Autowired
    private ImpersonationResolverService impersonationService;
    @Autowired
    private CachesPreloadingService cachesPreloadingService;
    ConstrainedLock<ActivityRunRequest> activityConstrainedLock = new ConstrainedLock();
    public static final int DEFAULT_SESSION_ABORT_TIMEOUT_MS = 30000;
    private final int sessionAbortTimeoutMs;
    private static final int DEFAULT_COMMAND_TIMEOUT_MS = Integer.MAX_VALUE;
    private final int stopSessionTimeoutMs;
    private final int resolveJobTimeoutMs;
    private final int runFullyTimeoutMs;
    private final int startSessionTimeoutMs;
    private final JobTaskQueue<Void> executor;
    private final Map<JobKey, JobSession> allJobs = new HashMap<JobKey, JobSession>();
    private static final Logger logger = Logger.getLogger((String)"dku.jobs.master");

    public BuildService() {
        this.activityConstrainedLock.setPrioritizationStrategy(new BalancedPrioritizationStrategy(10));
        this.sessionAbortTimeoutMs = ApplicationConfigurator.getParams().getIntParam("dku.jek.abort.timeoutMs", Integer.valueOf(30000));
        this.stopSessionTimeoutMs = ApplicationConfigurator.getParams().getIntParam("dku.jek.stopSession.timeoutMs", Integer.valueOf(Integer.MAX_VALUE));
        this.resolveJobTimeoutMs = ApplicationConfigurator.getParams().getIntParam("dku.jek.resolveJob.timeoutMs", Integer.valueOf(Integer.MAX_VALUE));
        this.runFullyTimeoutMs = ApplicationConfigurator.getParams().getIntParam("dku.jek.runFully.timeoutMs", Integer.valueOf(Integer.MAX_VALUE));
        this.startSessionTimeoutMs = ApplicationConfigurator.getParams().getIntParam("dku.jek.startSession.timeoutMs", Integer.valueOf(Integer.MAX_VALUE));
        GeneralSettingsDAO.GeneralSettings generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        int capacity = ApplicationConfigurator.getParams().getIntParam("dku.jobs.queue.capacity", Integer.valueOf(10000));
        int max = this.getMaxJekCount(generalSettings);
        this.executor = new JobTaskQueue("dku.jobs.queue.thread-", max, capacity);
        DSSMetrics.registry().register("dku.jobs.pending", (Metric)new Gauge<Long>(){

            public Long getValue() {
                return BuildService.this.executor.getQueuedTasksCount();
            }
        });
    }

    private void updatePoolSize(int maxRunningJobs) {
        this.executor.setMaxThreads(maxRunningJobs);
    }

    private synchronized JobSession getJobSession(String projectKey, String jobId) {
        return this.allJobs.get(new JobKey(projectKey, jobId));
    }

    private int getMaxJekCount(GeneralSettingsDAO.GeneralSettings generalSettings) {
        int value = generalSettings.jekSettings.maxRunningJobs;
        if (value <= 0) {
            value = generalSettings.maxRunningActivities;
        }
        return Math.max(value, 0);
    }

    public long getJobWithStateCount(JobState state) {
        return this.getAllJobs().stream().filter(session -> session.state == state).count();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JobSession> getActiveSessions() {
        ArrayList<JobSession> sessions = new ArrayList<JobSession>();
        BuildService buildService = this;
        synchronized (buildService) {
            for (JobSession js : this.allJobs.values()) {
                if (!js.state.isActive()) continue;
                sessions.add(js);
            }
        }
        return sessions;
    }

    public synchronized boolean cancelJob(String projectKey, String jobId) {
        JobSession session = this.allJobs.get(new JobKey(projectKey, jobId));
        if (session == null) {
            return false;
        }
        session.validatedPreviewFuture.cancel(true);
        session.future.cancel(true);
        return true;
    }

    @PostConstruct
    public void init() throws Exception {
        logger.info((Object)"Init BuildService: open timestamps session");
        try (Transaction t = this.transactionService.beginRead();){
            this.refreshSettings();
        }
        DSSEventListener<DSSEvent> listener = new DSSEventListener<DSSEvent>(){

            public void on(DSSEvent evt) {
                try (Transaction t = BuildService.this.transactionService.beginRead();){
                    BuildService.this.refreshSettings();
                }
                catch (IOException e) {
                    logger.error((Object)"Unable to rebuild global limits", (Throwable)e);
                }
            }
        };
        this.pubSub.subscribe("general-settings-changed", (DSSEventListener)listener);
        this.pubSub.subscribe("connections-changed", (DSSEventListener)listener);
        logger.info((Object)"Done init BuildService");
        DSSMetrics.registry().register("dku.jobs.runningAlternate", (Metric)new Gauge<Long>(){

            public Long getValue() {
                return BuildService.this.getActiveSessions().size();
            }
        });
        DSSMetrics.registry().register("dku.jobs.activities.waitingForPermit", (Metric)new Gauge<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Long getValue() {
                List<JobSession> sessions = BuildService.this.getActiveSessions();
                long result = 0L;
                Iterator<JobSession> iterator = sessions.iterator();
                while (iterator.hasNext()) {
                    JobSession activeSession;
                    JobSession jobSession = activeSession = iterator.next();
                    synchronized (jobSession) {
                        for (Permit<ActivityRunRequest> permit : activeSession.buildPermits.values()) {
                            if (permit.getStatus().getState() == PermitStatus.PermitState.ACQUIRED) continue;
                            ++result;
                        }
                    }
                }
                return result;
            }
        });
        DSSMetrics.registry().register("dku.jobs.activities.runningWithPermit", (Metric)new Gauge<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Long getValue() {
                List<JobSession> sessions = BuildService.this.getActiveSessions();
                long result = 0L;
                Iterator<JobSession> iterator = sessions.iterator();
                while (iterator.hasNext()) {
                    JobSession activeSession;
                    JobSession jobSession = activeSession = iterator.next();
                    synchronized (jobSession) {
                        for (Permit<ActivityRunRequest> permit : activeSession.buildPermits.values()) {
                            if (permit.getStatus().getState() != PermitStatus.PermitState.ACQUIRED) continue;
                            ++result;
                        }
                    }
                }
                return result;
            }
        });
    }

    private void refreshSettings() throws IOException {
        GeneralSettingsDAO.GeneralSettings generalSettings = this.generalSettingsService.read();
        this.refreshActivityRunLimits(generalSettings);
        this.updatePoolSize(this.getMaxJekCount(generalSettings));
    }

    public void invalidateKernels() {
        this.kernelsManager.invalidateKernels();
    }

    public void refreshActivityRunLimits(GeneralSettingsDAO.GeneralSettings generalSettings) throws IOException {
        Map<String, DSSConnection> connections = this.connectionsDAO.listUnsafe();
        ActivityRunLimiter limiter = new ActivityRunLimiter(connections, generalSettings);
        this.activityConstrainedLock.setSchedulingConstraintPolicy(limiter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryStopSession(JobSession session) {
        assert (session.kernel != null);
        this.stopResourceMonitoring(session);
        boolean stoppedProperly = false;
        try {
            session.kernel.executeCommand("stop_session", null, Void.class, this.stopSessionTimeoutMs);
            stoppedProperly = true;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to properly stop session, destroying kernel", (Throwable)e);
        }
        JobSession jobSession = session;
        synchronized (jobSession) {
            if (session.abortNotified) {
                logger.info((Object)"abort was notified, abort thread will release kernel");
                return;
            }
            session.isStopped = true;
        }
        if (stoppedProperly) {
            this.kernelsManager.releaseKernel(session.kernel);
        } else {
            this.kernelsManager.releaseAndKillKernel(session.kernel);
        }
        session.kernel = null;
    }

    private void forceDestroySessionKernel(JobSession session, JobExecutionKernelHandle kernel) {
        assert (kernel != null);
        this.stopResourceMonitoring(session);
        this.kernelsManager.releaseAndKillKernel(kernel);
        session.kernel = null;
    }

    private void stopResourceMonitoring(JobSession session) {
        if (session.resourceUsageMonitor != null) {
            try {
                session.resourceUsageMonitor.finish(true);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn((Object)"Interrupted while waiting for resource usage monitor to finish");
            }
            session.cru.reportCompleteNoFail();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleIncompatibilities(JobSession session, Set<BuildState.BeingBuilt> incompatible) {
        logger.warn((Object)("Job is incompatible with build state: " + JSON.json(incompatible)));
        session.log("Job is incompatible with build state: " + JSON.json(incompatible));
        assert (incompatible != null);
        JobSession jobSession = session;
        synchronized (jobSession) {
            session.transitionToState(JobState.FAILED);
            this.dbService.tryUpdateJob(session.projectKey, session.jobId, System.currentTimeMillis(), session.state, 0);
            session.incompatibilities = incompatible;
            session.diskWriteStatus(session.getLastKnownStatus());
        }
        this.tryStopSession(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSessionAndBuildState(JobSession session) {
        Object object = this;
        synchronized (object) {
            JobKey key = new JobKey(session.projectKey, session.jobId);
            logger.info((Object)("Removing jobId '" + key.jobId + "' from job list"));
            this.allJobs.remove(key);
            this.buildState.removeJob(session.projectKey, session.jobId);
            this.buildState.dump();
            if (session.apiTicket != null) {
                this.apiTicketService.expireTicket(session.apiTicket);
            }
        }
        object = session;
        synchronized (object) {
            for (Permit<ActivityRunRequest> permit : session.buildPermits.values()) {
                permit.release();
            }
        }
        ((PostJobActionsHandler)SpringUtils.getBean(PostJobActionsHandler.class)).onEndOfJob(session.projectKey, session.jobId);
    }

    private ActivityRunRequest createActivityRunRequest(String jobProjectKey, String jobId, SerializedJobActivity activity, String userIdentifier) throws IOException {
        HashSet recipes = Sets.newHashSet();
        HashSet recipeTypes = Sets.newHashSet();
        HashSet tags = Sets.newHashSet();
        HashSet resourceKeys = Sets.newHashSet();
        for (SerializedJobActivity.Recipe jobRecipe : activity.recipes) {
            int maxRunningActivities = 0;
            SerializedRecipe serializedRecipe = (SerializedRecipe)this.recipesDAO.getOrNullUnsafe(jobRecipe.projectKey, jobRecipe.name);
            if (serializedRecipe != null) {
                maxRunningActivities = serializedRecipe.maxRunningActivities;
                tags.addAll(serializedRecipe.tags);
                RecipeDesc recipeDesc = RecipeRegistry.getMeta(serializedRecipe).getRecipeDesc();
                if (recipeDesc instanceof CustomCodeRecipeDesc) {
                    resourceKeys.addAll(((CustomCodeRecipeDesc)recipeDesc).resourceKeys);
                }
            }
            recipes.add(new ActivityRunRequest.Recipe(jobRecipe.projectKey, jobRecipe.name, maxRunningActivities));
            recipeTypes.add(jobRecipe.type);
        }
        return new ActivityRunRequest(jobProjectKey, jobId, userIdentifier, recipes, recipeTypes, tags, resourceKeys, this.extractInvolvedConnections(activity));
    }

    private Set<String> extractInvolvedConnections(SerializedJobActivity activity) throws IOException {
        String connectionName;
        SerializedDataset sd;
        HashSet result = Sets.newHashSet();
        for (SerializedJobActivity.Source src : activity.sources) {
            sd = (SerializedDataset)this.datasetsDAO.getOrNull(src.projectKey, src.datasetName);
            if (sd == null || (connectionName = sd.getParams().getConnection()) == null) continue;
            result.add(connectionName);
        }
        for (SerializedJobActivity.Target tg : activity.targets) {
            sd = (SerializedDataset)this.datasetsDAO.getOrNull(tg.projectKey, tg.datasetName);
            if (sd == null || (connectionName = sd.getParams().getConnection()) == null) continue;
            result.add(connectionName);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String onAskBuildPermit(String jobProjectKey, String jobId, SerializedJobActivity activity) throws IOException {
        JobSession session = this.findSessionMand(jobProjectKey, jobId);
        String userIdentifier = session.authCtx.getIdentifier();
        ActivityRunRequest request = this.createActivityRunRequest(jobProjectKey, jobId, activity, userIdentifier);
        Permit<ActivityRunRequest> newPermit = this.activityConstrainedLock.newPermit(request);
        JobSession jobSession = session;
        synchronized (jobSession) {
            session.buildPermits.put(newPermit.getPermitId(), newPermit);
        }
        return newPermit.getPermitId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PermitStatus onWaitBuildPermit(String jobProjectKey, String jobId, String permitId, int timeoutMs) throws InterruptedException {
        Permit<ActivityRunRequest> permit;
        JobSession session;
        JobSession jobSession = session = this.findSessionMand(jobProjectKey, jobId);
        synchronized (jobSession) {
            permit = session.buildPermits.get(permitId);
        }
        if (permit != null) {
            permit.acquire();
            PermitStatus result = permit.await(timeoutMs);
            if (PermitStatus.PermitState.WAITING.equals((Object)result.getState())) {
                permit.release();
            }
            return result;
        }
        return new PermitStatus(permitId, PermitStatus.PermitState.RELEASED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReleaseBuildPermit(String jobProjectKey, String jobId, String permitId) {
        Permit<ActivityRunRequest> permit;
        JobSession session;
        JobSession jobSession = session = this.findSessionMand(jobProjectKey, jobId);
        synchronized (jobSession) {
            permit = session.buildPermits.remove(permitId);
        }
        if (permit != null) {
            permit.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runPreview(JobSession session) throws Exception {
        Set<String> skippedActivityIds;
        logger.info((Object)"Starting to compute job preview");
        session.resolveStartTime = System.currentTimeMillis();
        Model.ResolveQuery rq = new Model.ResolveQuery(session.projectKey, session.jobId);
        Model.ResolveResponse rr = session.kernel.executeCommand("resolve_job", rq, Model.ResolveResponse.class, this.resolveJobTimeoutMs);
        logger.info((Object)"Job preview computed");
        JobSession jobSession = session;
        synchronized (jobSession) {
            session.resolveEndTime = System.currentTimeMillis();
            if (rr.job.allActivities.size() == 0) {
                session.previewResponse = rr;
                session.transitionToState(JobState.DONE, 0L);
                session.lastKnownCoreStatus = rr.initialStatus;
                this.dbService.tryUpdateJob(session.projectKey, session.jobId, System.currentTimeMillis(), session.state, 0);
                session.diskWriteStatus(session.getLastKnownStatus());
                session.log("Nothing to do -> Cleaning up");
                return;
            }
            session.previewResponse = rr;
            session.transitionToState(JobState.WAITING_CONFIRMATION);
            session.lastKnownCoreStatus = rr.initialStatus;
            session.diskWriteStatus(session.getLastKnownStatus());
        }
        int previewTimeout = ApplicationConfigurator.getParams().getIntParam("dku.jobs.preview.timeoutSeconds", Integer.valueOf(600));
        try {
            skippedActivityIds = session.validatedPreviewFuture.get(previewTimeout, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            throw new TimeoutException("Waited too long (" + previewTimeout + " seconds) for user confirmation, killing job");
        }
        Set<BuildState.BeingBuilt> incompatibilities = this.buildState.testAndSetIncompatibilities(session.projectKey, session.jobId, session.previewResponse.job);
        if (incompatibilities != null) {
            this.handleIncompatibilities(session, incompatibilities);
            return;
        }
        this.executeRunFully(session, skippedActivityIds);
    }

    private void runAllFully(JobSession session) throws Exception {
        logger.info((Object)"Job runAllFully started");
        session.resolveStartTime = System.currentTimeMillis();
        Model.ResolveQuery rq = new Model.ResolveQuery(session.projectKey, session.jobId);
        session.previewResponse = session.kernel.executeCommand("resolve_job", rq, Model.ResolveResponse.class, this.resolveJobTimeoutMs);
        session.lastKnownCoreStatus = session.previewResponse.initialStatus;
        session.resolveEndTime = System.currentTimeMillis();
        session.diskWriteStatus(session.getLastKnownStatus());
        logger.info((Object)"Job resolution done");
        this.buildState.dump();
        Set<BuildState.BeingBuilt> incompatibilities = this.buildState.testAndSetIncompatibilities(session.projectKey, session.jobId, session.previewResponse.job);
        if (incompatibilities != null) {
            this.handleIncompatibilities(session, incompatibilities);
            return;
        }
        logger.info((Object)"Incompatibilities OK");
        this.buildState.dump();
        this.executeRunFully(session, new HashSet<String>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRunFully(JobSession session, Set<String> skippedActivityIds) throws Exception {
        JobSession jobSession = session;
        synchronized (jobSession) {
            session.transitionToState(JobState.RUNNING);
            session.execStartTime = System.currentTimeMillis();
        }
        Model.RunFullyQuery rfq = new Model.RunFullyQuery(session.projectKey, session.jobId, session.getKernelPid());
        rfq.skippedActivityIds = skippedActivityIds;
        Model.RunFullyResponse rfr = session.kernel.executeCommand("run_fully", rfq, Model.RunFullyResponse.class, this.runFullyTimeoutMs);
        JobSession jobSession2 = session;
        synchronized (jobSession2) {
            if (session.abortNotified) {
                logger.info((Object)"abort was notified, skip end of run thread");
                return;
            }
        }
        this.buildState.dump();
        logger.info((Object)("Job is complete success=" + rfr.success));
        try {
            assert (JobContext.getCurrentJobContext() == null);
            JobContext.setJob(session.projectKey, session.jobId, null);
            this.onJobDone(session.previewResponse, rfr, session);
        }
        finally {
            JobContext.setJobContext(null);
        }
        jobSession2 = session;
        synchronized (jobSession2) {
            session.execEndTime = System.currentTimeMillis();
            session.updateAndWriteStatus(rfr.finalStatus);
            session.transitionToState(rfr.success ? JobState.DONE : JobState.FAILED, rfr.warningCount);
            this.dbService.updateJob(session.projectKey, session.jobId, System.currentTimeMillis(), session.state, rfr.warningCount);
            session.updateAndWriteStatus(rfr.finalStatus);
        }
        this.pubSub.publish(new JobDoneEvent(session.authCtx, session.def, session.getLastKnownStatus()));
        logger.info((Object)"*** end of session");
        this.tryStopSession(session);
    }

    private JobSession findSessionMand(String projectKey, String jobId) {
        JobSession js = this.getJobSession(projectKey, jobId);
        if (js != null) {
            return js;
        }
        throw new IllegalArgumentException("Session not found " + projectKey + " / " + jobId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort_NT(AuthCtx u, String projectKey, String jobId) {
        JobExecutionKernelHandle kernel;
        logger.info((Object)("Aborting job " + projectKey + "." + jobId));
        JobSession session = this.getJobSession(projectKey, jobId);
        if (session == null) {
            logger.info((Object)("Unable to abort: the job session '" + jobId + "' doesn't exist anymore."));
            return;
        }
        JobSession jobSession = session;
        synchronized (jobSession) {
            if (session.abortNotified) {
                logger.info((Object)"Abort already requested");
                return;
            }
            if (session.isStopped) {
                logger.info((Object)"session is already stopped, abort is no-op");
                return;
            }
            session.abortNotified = true;
            kernel = session.kernel;
        }
        try {
            this.cancelJob(projectKey, jobId);
            if (kernel != null) {
                try {
                    Model.AbortSessionQuery rfq = new Model.AbortSessionQuery();
                    kernel.executeCommand("abort_session", rfq, Model.AbortSessionQuery.class, this.sessionAbortTimeoutMs);
                }
                catch (Throwable t) {
                    logger.warn((Object)"Failed to properly stop job", t);
                }
            }
            jobSession = session;
            synchronized (jobSession) {
                session.transitionToState(JobState.ABORTED);
            }
            if (kernel != null) {
                this.forceDestroySessionKernel(session, kernel);
            }
            jobSession = session;
            synchronized (jobSession) {
                if (session.resolveStartTime == 0L) {
                    session.resolveStartTime = System.currentTimeMillis();
                }
                if (session.execStartTime == 0L) {
                    session.execStartTime = System.currentTimeMillis();
                }
                if (session.resolveEndTime == 0L) {
                    session.resolveEndTime = System.currentTimeMillis();
                }
                session.execEndTime = System.currentTimeMillis();
                this.dbService.tryUpdateJob(session.projectKey, session.jobId, System.currentTimeMillis(), session.state, 0);
                if (kernel != null) {
                    session.diskWriteStatus(session.getLastKnownStatus());
                }
                session.log("Job was ABORTED");
            }
        }
        finally {
            this.removeSessionAndBuildState(session);
        }
    }

    public String startJobPreview(JobDef jd, DSSAuthCtx authCtx) throws Exception {
        DSSMetrics.registry().meter("dku.jobs.startJobPreview").mark();
        Pair<JobSession, BuildUtils.JobLocalConfigSnapshot> pair = this.initSession(jd, authCtx);
        this.submitJob((JobSession)pair.first, (BuildUtils.JobLocalConfigSnapshot)pair.second, true);
        return jd.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitJob(JobSession session, BuildUtils.JobLocalConfigSnapshot snapshot, boolean forPreview) throws SQLException {
        JobDef jd = session.def;
        this.dbService.registerNewJob(jd.projectKey, jd.id, jd, System.currentTimeMillis());
        boolean publishEventChanged = !this.executor.canHaveMoreTasks();
        Object object = session;
        synchronized (object) {
            session.transitionToState(JobState.PENDING, 0L, publishEventChanged);
        }
        object = this;
        synchronized (object) {
            JobKey key = new JobKey(session.projectKey, session.jobId);
            logger.info((Object)("Adding jobId '" + key.jobId + "' from job list"));
            this.allJobs.put(key, session);
        }
        DSSMetrics.MTimeCtx pendingMTimeCtx = DSSMetrics.mtimeCtx((String[])new String[]{"dku.jobs.pendingTime.overall", "dku.jobs.pendingTime.byProject." + session.projectKey, "dku.jobs.pendingTime.byUser." + session.authCtx.getIdentifier()});
        logger.info((Object)("Job '" + session.jobId + "' submitted"));
        session.future = this.executor.submit(() -> {
            Object kernel;
            pendingMTimeCtx.close();
            String previousThreadName = Thread.currentThread().getName();
            String suffix = forPreview ? "-preview" : "-full";
            Thread.currentThread().setName("JWT-" + session.projectKey + "." + session.jobId + suffix);
            try {
                boolean aborted;
                JobSession jobSession = session;
                synchronized (jobSession) {
                    session.jobStartTime = System.currentTimeMillis();
                    session.transitionToState(JobState.STARTING);
                }
                logger.info((Object)("Starting job:" + session.jobId));
                snapshot.copyConfigOnDisk();
                kernel = null;
                try (DSSMetrics.TimeCtx timeCtx = DSSMetrics.timeCtx((String)"dku.jobs.acquireKernel");){
                    kernel = this.kernelsManager.acquireKernel(session.projectKey, session.jobId);
                }
                JobSession jobSession2 = session;
                synchronized (jobSession2) {
                    aborted = session.abortNotified;
                    if (!aborted) {
                        session.kernel = kernel;
                    }
                }
                if (aborted) {
                    this.kernelsManager.releaseKernel((DSSKernelManagerBase.KernelHandle)kernel);
                    throw new CancellationException("Job was aborted, kernel was released");
                }
                final int pid = session.getKernelPid();
                logger.info((Object)("Session " + session.jobId + " acquired kernel with PID " + pid));
                AbstractCGroupHelper cGroupHelper = AbstractCGroupHelper.getCGroupHelper(session.authCtx, session.projectKey, GeneralSettingsDAO.CGrouppableProcessType.JOB_EXECUTION_KERNEL);
                if (cGroupHelper.isEnabled()) {
                    cGroupHelper.applyCGroupsConfigToProcess(pid);
                }
                session.cru = ComputeResourceUsage.forLocalProcess();
                session.cru.context = ComputeResourceUsageContext.forJobMainProcess((AuthCtx)session.authCtx, (String)session.projectKey, (String)session.jobId);
                session.cru.reportStartNoFail();
                session.resourceUsageMonitor = new ProcessResourceUsageMonitor(session.cru, "java", new WithMaybePid(){

                    public int getPidIfAvailable() {
                        return pid;
                    }
                });
                session.resourceUsageMonitor.start();
                JobStartedEvent.JobStartInfo startInfo = new JobStartedEvent.JobStartInfo();
                startInfo.kernelPid = session.getKernelPid();
                this.pubSub.publish((DSSEvent)new JobStartedEvent(session.authCtx, jd, startInfo));
                DSSMetrics.registry().counter("dku.jobs.running").inc();
                try (DSSMetrics.MTimeCtx mt = DSSMetrics.mtimeCtx((String[])new String[]{"dku.jobs.runTime.overall", "dku.jobs.runTime.byProject." + session.projectKey, "dku.jobs.runTime.byUser." + session.authCtx.getIdentifier()});){
                    Model.StartSessionQuery ssq = new Model.StartSessionQuery();
                    ssq.jobProjectKey = session.projectKey;
                    ssq.jobId = session.jobId;
                    ssq.jobTicketSecret = session.apiTicket.getSecret();
                    ssq.initiatorAuthContext = (DSSAuthCtx)session.authCtx;
                    if (!forPreview) {
                        ssq.scenarioRun = jd.scenarioRun;
                        ssq.stepRun = jd.stepRun;
                    }
                    session.kernel.executeCommand("start_session", ssq, Model.StartSessionResponse.class, this.startSessionTimeoutMs);
                    JobSession jobSession3 = session;
                    synchronized (jobSession3) {
                        session.transitionToState(JobState.COMPUTING_DEPS);
                    }
                    if (forPreview) {
                        this.runPreview(session);
                    } else {
                        this.runAllFully(session);
                    }
                }
                finally {
                    DSSMetrics.registry().counter("dku.jobs.running").dec();
                }
            }
            catch (Throwable t) {
                JobSession jobSession = session;
                synchronized (jobSession) {
                    block65: {
                        if (!session.abortNotified && session.state != JobState.ABORTED) break block65;
                        logger.error((Object)"Job was aborted, not performing cleanup");
                        Void void_ = null;
                        return void_;
                    }
                    session.resolveEndTime = System.currentTimeMillis();
                    session.unexpectedFailureThrowable = t;
                    session.onJobFailed();
                    session.transitionToState(JobState.FAILED);
                    this.dbService.tryUpdateJob(session.projectKey, session.jobId, System.currentTimeMillis(), session.state, 0);
                    session.diskWriteStatus(session.getLastKnownStatus());
                    session.log("Unexpected ERROR waiting for job to complete\n" + ExceptionUtils.getStackTrace((Throwable)t));
                }
            }
            finally {
                kernel = session;
                synchronized (kernel) {
                    if (session.abortNotified || session.state == JobState.ABORTED) {
                        Thread.currentThread().setName(previousThreadName);
                        return null;
                    }
                }
                try {
                    if (session.kernel != null) {
                        this.forceDestroySessionKernel(session, session.kernel);
                    }
                }
                finally {
                    this.removeSessionAndBuildState(session);
                    Thread.currentThread().setName(previousThreadName);
                }
            }
            return null;
        }, session.jobId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreviewResult getPreviewResult(String projectKey, String jobId) throws IOException {
        JobSession js;
        JobSession jobSession = js = this.findSessionMand(projectKey, jobId);
        synchronized (jobSession) {
            if (js.state != JobState.WAITING_CONFIRMATION) {
                throw new IllegalStateException("Can't get preview result, state is " + String.valueOf((Object)js.state));
            }
            assert (js.previewResponse != null);
            PreviewResult result = new PreviewResult();
            result.jobBeforePrune = js.previewResponse.jobBeforePrune;
            result.job = js.previewResponse.job;
            Set<BuildState.BeingBuilt> incompatible = this.buildState.testIncompatibilities(result.job);
            if (incompatible != null) {
                result.conflictingSteps = Lists.newArrayList();
            }
            result.expand();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SerializedJobStatus getStatus(String projectKey, String jobId) {
        JobSession js;
        JobSession jobSession = js = this.findSessionMand(projectKey, jobId);
        synchronized (jobSession) {
            return js.getLastKnownStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SerializedJobStatus getStatusOrNull(String projectKey, String jobId) {
        JobSession js = this.getJobSession(projectKey, jobId);
        if (js == null) {
            return null;
        }
        JobSession jobSession = js;
        synchronized (jobSession) {
            return js.getLastKnownStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateRunFully(String projectKey, String jobId, List<String> skippedActivityIds) {
        JobSession js;
        JobSession jobSession = js = this.findSessionMand(projectKey, jobId);
        synchronized (jobSession) {
            assert (js.previewResponse != null);
            assert (js.state == JobState.WAITING_CONFIRMATION);
        }
        js.validatedPreviewFuture.complete(Sets.newHashSet(skippedActivityIds));
    }

    public String startJob(JobDef jd, DSSAuthCtx authCtx) throws Exception {
        DSSMetrics.registry().meter("dku.jobs.startJob").mark();
        Pair<JobSession, BuildUtils.JobLocalConfigSnapshot> pair = this.initSession(jd, authCtx);
        this.submitJob((JobSession)pair.first, (BuildUtils.JobLocalConfigSnapshot)pair.second, false);
        return jd.id;
    }

    private Pair<JobSession, BuildUtils.JobLocalConfigSnapshot> initSession(JobDef jd, AuthCtx initiatorAuthCtx) throws Exception {
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.jobs.initSession");){
            BuildUtils.JobLocalConfigSnapshot snapshot;
            Validate.notNull((Object)jd);
            Validate.notNull((Object)initiatorAuthCtx);
            logger.info((Object)"Initializing job session");
            BuildUtils.assignJobNameAndId("Build", jd);
            JobSession session = new JobSession();
            session.authCtx = initiatorAuthCtx;
            session.apiTicket = this.apiTicketService.createTicket(initiatorAuthCtx, "job:" + jd.projectKey + "." + jd.id, (Object)session);
            session.projectKey = jd.projectKey;
            session.jobId = jd.id;
            session.def = jd;
            session.pubSub = this.pubSub;
            JobTicketUtils.setJobMetadataInTicket(session, session.apiTicket);
            File jobAttemptFolder = FlowJobUtils.jobFolder(false, jd.projectKey, jd.id);
            DKUFileUtils.mkdirs((File)jobAttemptFolder);
            if (this.impersonationService.isEnabled()) {
                FilesystemACLHandler aclHandler = new FilesystemACLHandler();
                aclHandler.ensureWorldTraversableOnly(jobAttemptFolder.getParentFile());
            }
            JSON.prettyToFile((Object)jd, (File)FlowJobUtils.jobDefFile(false, jd.projectKey, jd.id));
            GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
            if (gs.globalCrossProjectBuildBehaviour == GeneralSettingsDAO.GlobalCrossProjectBuildBehaviour.TRAVERSE_BOUNDARIES) {
                FlowGraph ggraphUnsafe = this.graphService.getGlobalGraphUnsafe(true);
                snapshot = BuildUtils.copyJobLocalConfig(initiatorAuthCtx, ggraphUnsafe, jd);
            } else {
                logger.trace((Object)"Copying using local graph");
                ProjectFlowGraph pgraphUnsafe = this.graphService.getProjectGraphUnsafe(jd.projectKey);
                snapshot = BuildUtils.copyJobLocalConfig(initiatorAuthCtx, pgraphUnsafe, jd);
            }
            logger.trace((Object)"Config ready");
            Pair pair = new Pair((Object)session, (Object)snapshot);
            return pair;
        }
    }

    public void onStatusUpdate(String jobProjectKey, String jobId, CoreJobStatus cjs) {
        JobSession js = this.findSessionMand(jobProjectKey, jobId);
        js.updateAndWriteStatus(cjs);
        this.pubSub.publish(new JobStatusUpdatedEvent(js.def, cjs));
    }

    public void onActivityStarted(JobDef jobDef, SerializedJobActivityStatus sja) {
        DSSMetrics.registry().meter("dku.jobs.activityStarted").mark();
        JobSession session = this.findSessionMand(jobDef.projectKey, jobDef.id);
        this.pubSub.publish(new ActivityStartedEvent(session.authCtx, jobDef, sja));
        this.buildState.onActivityStarted(jobDef.projectKey, jobDef.id, sja.def);
    }

    public void onActivityDone(JobDef jobDef, SerializedJobActivityStatus sja) {
        DSSMetrics.registry().meter("dku.jobs.activityDone").mark();
        JobSession session = this.findSessionMand(jobDef.projectKey, jobDef.id);
        this.pubSub.publish(new ActivityDoneEvent(session.authCtx, jobDef, sja));
        this.buildState.onActivityDone(jobDef.projectKey, jobDef.id, sja.def);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onJobDone(Model.ResolveResponse rr, Model.RunFullyResponse frf, JobSession session) throws Exception {
        List<AbstractCheckReport> list;
        Callable<List<AbstractCheckReport>> callable;
        DSSMetrics.registry().meter("dku.jobs.jobDone").mark();
        if (rr == null || frf == null || rr.initialStatus == null || frf.finalStatus == null) {
            return;
        }
        HashSet partitioneds = Sets.newHashSet();
        for (Map.Entry<String, SerializedJobActivityStatus> entry : rr.initialStatus.activities.entrySet()) {
            for (SerializedJobActivityStatus.SerializedTargetDS serializedTargetDS : entry.getValue().targets) {
                String partitionId = serializedTargetDS.partition.id;
                if (!serializedTargetDS.type.isPartitionable() || !StringUtils.isNotBlank((String)partitionId) || "NP".equals(partitionId)) continue;
                partitioneds.add(serializedTargetDS.id);
            }
        }
        HashSet failedPartitioneds = Sets.newHashSet();
        for (Map.Entry<String, SerializedJobActivityStatus> entry : frf.finalStatus.activities.entrySet()) {
            if (entry.getValue().state == ActivityState.DONE) continue;
            for (SerializedJobActivityStatus.SerializedTargetDS target : entry.getValue().targets) {
                failedPartitioneds.add(target.id);
            }
        }
        partitioneds.removeAll(failedPartitioneds);
        try (Transaction transaction = this.transactionService.beginRead();){
            callable = this.metricsLaunchService.onJobDone(session.apiTicket.getViaAuthCtx(), partitioneds, session.projectKey, session.jobId);
        }
        try {
            assert (JobBackendLoggingContext.getCurrentJobContext() == null);
            assert (JobContext.getCurrentJobContext() != null);
            JobBackendLoggingContext.setJobContext(JobBackendLoggingContext.Topic.METRICS, JobContext.getCurrentJobContext().jobId, JobContext.getCurrentJobContext().projectKey, null);
            list = callable.call();
        }
        finally {
            JobBackendLoggingContext.resetJobContext();
        }
        JobsIntercomController.ActivityChecksResults activityChecksResults = new JobsIntercomController.ActivityChecksResults(list);
        if (!activityChecksResults.success) {
            frf.success = false;
            frf.warningCount = activityChecksResults.warningCount;
            session.checksFailureThrowable = new JobsIntercomController.CheckFailedException("Checks on the jobs full outputs produced " + activityChecksResults.errorCount + " errors");
        }
    }

    public void onRegister(String kernelId, int port, int jvmPID) {
        DSSMetrics.registry().meter("dku.jobs.jekRegister").mark();
        this.kernelsManager.onRegister(kernelId, port, jvmPID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FlowExecutionService2.JobSummary> listAllRunningJobs(boolean withKernelPid) {
        Collection<JobSession> allSessions;
        ArrayList<FlowExecutionService2.JobSummary> runningJobs = new ArrayList<FlowExecutionService2.JobSummary>();
        Object object = this;
        synchronized (object) {
            allSessions = this.allJobs.values();
        }
        object = allSessions.iterator();
        while (object.hasNext()) {
            JobState state;
            JobSession session;
            JobSession jobSession = session = (JobSession)object.next();
            synchronized (jobSession) {
                state = session.state;
            }
            if (!state.isPendingOrRunning()) continue;
            runningJobs.add(session.toLightJobSummary(withKernelPid));
        }
        return runningJobs;
    }

    synchronized List<JobSession> getAllJobs() {
        return new ArrayList<JobSession>(this.allJobs.values());
    }

    private static class JobKey {
        final String jobId;
        final String projectKey;

        public JobKey(String projectKey, String jobId) {
            this.projectKey = projectKey;
            this.jobId = jobId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JobKey jobKey = (JobKey)o;
            return Objects.equals(this.jobId, jobKey.jobId) && Objects.equals(this.projectKey, jobKey.projectKey);
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.projectKey);
        }
    }

    public class PreviewResult {
        public SerializedJob jobBeforePrune;
        public SerializedJob job;
        public Map<String, Collection<String>> activitiesByRecipeNodeId;
        public Map<String, Collection<String>> activitiesByDatasetNodeId;
        public Map<String, DatasetUI> datasetDataByDatasetNodeId = new HashMap<String, DatasetUI>();
        public Map<String, Collection<String>> reverseDeps;
        public List<BuildState.BeingBuilt> conflictingSteps = new ArrayList<BuildState.BeingBuilt>();

        public void addComputable(String projectKey, String name) throws IOException {
            String datasetNodeId = GraphSerializerCommon.graphVizEscape("dataset_" + projectKey + "." + name);
            String savedModelNodeId = GraphSerializerCommon.graphVizEscape("savedmodel_" + projectKey + "." + name);
            String managedFolderNodeId = GraphSerializerCommon.graphVizEscape("managedfolder_" + projectKey + "." + name);
            String retrievableKnowledgeId = GraphSerializerCommon.graphVizEscape("retrievableknowledge_" + projectKey + "." + name);
            if (this.datasetDataByDatasetNodeId.get(datasetNodeId) != null || this.datasetDataByDatasetNodeId.get(savedModelNodeId) != null || this.datasetDataByDatasetNodeId.get(managedFolderNodeId) != null || this.datasetDataByDatasetNodeId.get(retrievableKnowledgeId) != null) {
                return;
            }
            DatasetUI dui = new DatasetUI();
            dui.projectKey = projectKey;
            SerializedDataset sd = (SerializedDataset)BuildService.this.datasetsDAO.getOrNullUnsafe(projectKey, name);
            if (sd != null) {
                dui.name = sd.name;
                dui.type = sd.type;
                this.datasetDataByDatasetNodeId.put(datasetNodeId, dui);
                return;
            }
            SavedModel savedModel = (SavedModel)BuildService.this.savedModelsDAO.getOrNull(projectKey, name);
            if (savedModel != null) {
                dui.name = savedModel.name;
                dui.type = "SAVED_MODEL";
                this.datasetDataByDatasetNodeId.put(savedModelNodeId, dui);
                return;
            }
            ManagedFolder managedFolder = (ManagedFolder)BuildService.this.managedFolderDAO.getOrNull(projectKey, name);
            if (managedFolder != null) {
                dui.name = managedFolder.name;
                dui.type = "MANAGED_FOLDER";
                this.datasetDataByDatasetNodeId.put(managedFolderNodeId, dui);
                return;
            }
            RetrievableKnowledge retrievableKnowledge = (RetrievableKnowledge)BuildService.this.retrievableKnowledgeDAO.getOrNull(projectKey, name);
            if (retrievableKnowledge != null) {
                dui.name = retrievableKnowledge.name;
                dui.type = "RETRIEVABLE_KNOWLEDGE";
                this.datasetDataByDatasetNodeId.put(retrievableKnowledgeId, dui);
                return;
            }
            throw new IOException("Unknown object " + name + "in project " + projectKey);
        }

        public void expand() throws IOException {
            ArrayListMultimap activitiesByRecipeMM = ArrayListMultimap.create();
            ArrayListMultimap activitiesByDatasetMM = ArrayListMultimap.create();
            ArrayListMultimap reverseDepsMM = ArrayListMultimap.create();
            for (SerializedJobActivity sja : this.job.allActivities.values()) {
                for (SerializedJobActivity.Target target : sja.targets) {
                    String datasetNodeId = GraphSerializerCommon.graphVizEscape("dataset_" + target.projectKey + "." + target.datasetName);
                    activitiesByDatasetMM.put((Object)datasetNodeId, (Object)sja.activityId);
                }
                if (sja.recipes != null && sja.recipes.size() > 0) {
                    for (SerializedJobActivity.Recipe recipe : sja.recipes) {
                        String recipeNodeId = GraphSerializerCommon.graphVizEscape("recipe_" + recipe.name);
                        activitiesByRecipeMM.put((Object)recipeNodeId, (Object)sja.activityId);
                    }
                } else {
                    String recipeNodeId = GraphSerializerCommon.graphVizEscape("recipe_" + sja.recipeName);
                    activitiesByRecipeMM.put((Object)recipeNodeId, (Object)sja.activityId);
                }
                for (String dep : sja.dependencies) {
                    reverseDepsMM.put((Object)dep, (Object)sja.activityId);
                }
                for (SerializedJobActivity.Target target : sja.targets) {
                    this.addComputable(target.projectKey, target.datasetName);
                }
                for (SerializedJobActivity.Source source : sja.sources) {
                    this.addComputable(source.projectKey, source.datasetName);
                }
            }
            this.activitiesByRecipeNodeId = activitiesByRecipeMM.asMap();
            this.activitiesByDatasetNodeId = activitiesByDatasetMM.asMap();
            this.reverseDeps = reverseDepsMM.asMap();
        }
    }

    public static class DatasetUI {
        String name;
        String projectKey;
        String type;
    }
}

