/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.discussions;

import com.dataiku.dip.discussions.Discussion;
import com.dataiku.dip.discussions.DiscussionsCacheService;
import com.dataiku.dip.discussions.DiscussionsInternalDB;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.notifications.backend.DiscussionAckEvent;
import com.dataiku.dip.server.notifications.backend.DiscussionClosedEvent;
import com.dataiku.dip.server.notifications.backend.DiscussionDeletedEvent;
import com.dataiku.dip.server.notifications.backend.DiscussionImportEvent;
import com.dataiku.dip.server.notifications.backend.DiscussionReplyEvent;
import com.dataiku.dip.server.notifications.backend.DiscussionUpdateEvent;
import com.dataiku.dip.server.notifications.backend.DiscussionsUnreadFullIdsChanged;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggableObjectsReadService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DiscussionsService {
    @Autowired
    private DiscussionsInternalDB discussionsDB;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private UsersService usersService;
    @Autowired
    private TaggableObjectsReadService taggableObjectsReadService;
    @Autowired
    private DiscussionsCacheService discussionsCacheService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.discussions");

    @PostConstruct
    public void init() {
        this.pubSub.subscribe("workspace-deleted", evt -> {
            try {
                this.deleteDiscussionsForWorkspace(evt.getWorkspaceKey());
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to delete discussions for workspace " + evt.getWorkspaceKey()), (Throwable)e);
            }
        });
        this.pubSub.subscribe("object-change", evt -> {
            if (evt.action == TaggableObjectChangedEvent.ActionType.RECIPE_RENAME) {
                try {
                    this.handleTaggableObjectIdChange_NT(ITaggingService.TaggableType.RECIPE, evt.projectKey, evt.objectId, evt.newObjectId);
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to rename recipe " + evt.projectKey + "." + evt.objectId + " in discussion db"), (Throwable)e);
                }
            }
        });
    }

    public DiscussionsInternalDB.DiscussionCounts getCountsForObject(String projectKey, String workspaceKey, ITaggingService.TaggableType objectType, String objectId, AuthCtx authCtx) throws CodedSQLException {
        return this.discussionsDB.getCountsForObject(projectKey, workspaceKey, objectType, objectId, authCtx.getIdentifier());
    }

    public List<Discussion> getForObject(String projectKey, String workspaceKey, ITaggingService.TaggableType objectType, String objectId) throws CodedSQLException {
        return this.discussionsDB.getForObject(projectKey, workspaceKey, objectType, objectId);
    }

    public List<Discussion> getForObject(TaggableObjectsService.TaggableObjectRef ref) throws CodedSQLException {
        return this.getForObject(ref.projectKey, ref.workspaceKey, ref.type, ref.id);
    }

    public Discussion getDiscussion(String projectKey, String workspaceKey, String discussionId) throws NotFoundException, SQLException {
        return this.discussionsDB.getDiscussion(projectKey, workspaceKey, discussionId);
    }

    public Map<TaggableObjectsService.TaggableObjectRef, List<Discussion>> getAllDiscussions() throws CodedSQLException {
        return this.discussionsDB.getAllDiscussions();
    }

    public void massActionSendEvents(Set<TaggableObjectsService.TaggableObjectRef> affectedTors, Set<String> affectedUsers) {
        for (TaggableObjectsService.TaggableObjectRef tor : affectedTors) {
            this.pubSub.publish(new DiscussionImportEvent(tor.projectKey, tor.workspaceKey, tor.type, tor.id));
        }
        for (String login : affectedUsers) {
            Set<String> unreadFullIds = this.discussionsCacheService.getUnreadDiscussionsFullIds(login, true);
            if (unreadFullIds == null) continue;
            this.pubSub.publish(new DiscussionsUnreadFullIdsChanged(login, unreadFullIds));
        }
    }

    public Set<String> importWholeDiscussion(Discussion discussion) throws NotFoundException, SQLException {
        this.discussionsDB.importWholeDiscussion(discussion);
        return this.discussionsCacheService.importDiscussion_NoEvent(discussion);
    }

    public Discussion create(ITaggingService.TaggableType objectType, String projectKey, String workspaceKey, String objectId, String topic, String text, AuthCtx authCtx) throws NotFoundException, SQLException {
        return this.create(objectType, projectKey, workspaceKey, objectId, topic, text, authCtx.getIdentifier(), System.currentTimeMillis(), true);
    }

    public Discussion create(ITaggingService.TaggableType objectType, String projectKey, String workspaceKey, String objectId, String topic, String text, String user, long time, boolean notify) throws NotFoundException, SQLException {
        String discussionId = SecretKeyGenerator.generate((int)8);
        Discussion conv = new Discussion(discussionId, projectKey, workspaceKey, objectId, objectType, topic, 0L, null, 0L);
        String replyId = SecretKeyGenerator.generate((int)8);
        Discussion.DiscussionReply reply = new Discussion.DiscussionReply(replyId, text, user, time, 0L);
        conv.addReply(reply);
        this.discussionsDB.saveDiscussion(conv, true);
        this.discussionsDB.saveReply(projectKey, workspaceKey, discussionId, reply, true);
        this.discussionsCacheService.reply(new TaggableObjectsService.TaggableObjectRef(projectKey, objectType, objectId, workspaceKey), discussionId, user);
        if (notify) {
            this.pubSub.publish(new DiscussionReplyEvent(projectKey, workspaceKey, objectType, objectId, discussionId, user, topic, text, true, true));
        }
        return conv;
    }

    public void save(ITaggingService.TaggableType objectType, String projectKey, String workspaceKey, String objectId, String discussionId, String topic, AuthCtx authCtx) throws CodedSQLException {
        Discussion conv = new Discussion(discussionId, projectKey, workspaceKey, objectId, objectType, topic);
        this.discussionsDB.saveDiscussion(conv, false);
        this.pubSub.publish(new DiscussionUpdateEvent(projectKey, workspaceKey, objectType, objectId, discussionId, authCtx.getIdentifier()));
    }

    public void setDiscussion(Discussion discussion, AuthCtx authCtx) throws CodedSQLException {
        this.discussionsDB.setDiscussion(discussion.id, discussion.projectKey, discussion.workspaceKey, discussion.objectType, discussion.objectId, discussion.topic, discussion.closedOn, discussion.closedBy, discussion.lastReplyTime);
        this.pubSub.publish(new DiscussionUpdateEvent(discussion.projectKey, discussion.workspaceKey, discussion.objectType, discussion.objectId, discussion.id, authCtx.getIdentifier()));
    }

    public void reply(ITaggingService.TaggableType objectType, String projectKey, String workspaceKey, String objectId, String discussionId, String text, String user, long time, boolean notify) throws NotFoundException, SQLException {
        this.reply(objectType, projectKey, workspaceKey, objectId, discussionId, null, text, user, time, notify);
    }

    public void reply(ITaggingService.TaggableType objectType, String projectKey, String workspaceKey, String objectId, String discussionId, String replyId, String text, AuthCtx authCtx) throws NotFoundException, SQLException {
        this.reply(objectType, projectKey, workspaceKey, objectId, discussionId, replyId, text, authCtx.getIdentifier(), true);
    }

    public void reply(ITaggingService.TaggableType objectType, String projectKey, String workspaceKey, String objectId, String discussionId, String replyId, String text, String user, boolean notify) throws NotFoundException, SQLException {
        this.reply(objectType, projectKey, workspaceKey, objectId, discussionId, replyId, text, user, System.currentTimeMillis(), notify);
    }

    public void reply(ITaggingService.TaggableType objectType, String projectKey, String workspaceKey, String objectId, String discussionId, String replyId, String text, String user, long time, boolean notify) throws NotFoundException, SQLException {
        Discussion discu = this.discussionsDB.getDiscussion(projectKey, workspaceKey, discussionId);
        boolean newReply = StringUtils.isBlank((String)replyId);
        if (newReply) {
            replyId = SecretKeyGenerator.generate((int)8);
            Discussion.DiscussionReply reply = new Discussion.DiscussionReply(replyId, text, user, time, 0L);
            this.discussionsDB.saveReply(projectKey, workspaceKey, discussionId, reply, newReply);
        } else {
            Discussion.DiscussionReply existingReply = discu.getReply(replyId);
            if (existingReply == null) {
                throw new NotFoundException("Invalid or unknown replyId: " + replyId);
            }
            if (!Objects.equals(user, existingReply.author)) {
                throw new SecurityException("You may not edit a reply created by another user");
            }
            Discussion.DiscussionReply reply = new Discussion.DiscussionReply(replyId, text, user, 0L, time);
            this.discussionsDB.saveReply(projectKey, workspaceKey, discussionId, reply, newReply);
        }
        this.discussionsCacheService.reply(new TaggableObjectsService.TaggableObjectRef(projectKey, objectType, objectId, workspaceKey), discussionId, user);
        if (notify) {
            this.pubSub.publish(new DiscussionReplyEvent(projectKey, workspaceKey, objectType, objectId, discussionId, user, discu.topic, text, false, newReply));
        }
    }

    public void ack(String projectKey, String workspaceKey, ITaggingService.TaggableType objectType, String objectId, String discussionId, AuthCtx authCtx) throws CodedSQLException {
        long now = this.discussionsDB.ack(projectKey, workspaceKey, discussionId, authCtx.getIdentifier());
        this.discussionsCacheService.ack(projectKey, workspaceKey, discussionId, authCtx.getIdentifier());
        this.pubSub.publish(new DiscussionAckEvent(projectKey, workspaceKey, objectType, objectId, discussionId, now, authCtx.getIdentifier()));
    }

    public void close(String projectKey, String workspaceKey, ITaggingService.TaggableType objectType, String objectId, String discussionId, boolean closed, AuthCtx authCtx) throws CodedSQLException, NotFoundException {
        Discussion discu = this.discussionsDB.getDiscussion(projectKey, workspaceKey, discussionId);
        this.discussionsDB.close(projectKey, workspaceKey, discussionId, closed, authCtx.getIdentifier());
        this.discussionsCacheService.close(new TaggableObjectsService.TaggableObjectRef(projectKey, objectType, objectId, workspaceKey), discussionId, closed);
        this.pubSub.publish(new DiscussionClosedEvent(projectKey, workspaceKey, objectType, objectId, discussionId, discu.topic, authCtx.getIdentifier(), closed));
    }

    public void deleteDiscussion(ITaggingService.TaggableType objectType, String projectKey, String workspaceKey, String objectId, String discussionId, AuthCtx authCtx) throws SQLException, NotFoundException {
        Discussion discu = this.discussionsDB.getDiscussion(projectKey, workspaceKey, discussionId);
        this.discussionsDB.deleteDiscussion(projectKey, workspaceKey, discussionId);
        this.discussionsCacheService.deleteDiscussion(new TaggableObjectsService.TaggableObjectRef(projectKey, objectType, objectId, workspaceKey), discussionId, true);
        this.pubSub.publish(new DiscussionDeletedEvent(projectKey, workspaceKey, objectType, objectId, discussionId, discu.topic, authCtx.getIdentifier()));
    }

    public void deleteDiscussionsForProject(String projectKey) throws Exception {
        HashSet<TaggableObjectsService.TaggableObjectRef> affectedTors = new HashSet<TaggableObjectsService.TaggableObjectRef>();
        HashSet<String> affectedUsers = new HashSet<String>();
        Map<TaggableObjectsService.TaggableObjectRef, List<Discussion>> discussions = this.getAllDiscussions();
        for (Map.Entry<TaggableObjectsService.TaggableObjectRef, List<Discussion>> entry : discussions.entrySet()) {
            if (!entry.getKey().projectKey.equals(projectKey)) continue;
            for (Discussion discu : entry.getValue()) {
                this.discussionsDB.deleteDiscussion(projectKey, discu.workspaceKey, discu.id);
                affectedTors.add(entry.getKey());
                affectedUsers.addAll(this.discussionsCacheService.deleteDiscussion(entry.getKey(), discu.id, false));
            }
        }
        this.massActionSendEvents(affectedTors, affectedUsers);
    }

    public void deleteDiscussionsForWorkspace(String workspaceKey) throws Exception {
        HashSet<TaggableObjectsService.TaggableObjectRef> affectedTors = new HashSet<TaggableObjectsService.TaggableObjectRef>();
        HashSet<String> affectedUsers = new HashSet<String>();
        Map<TaggableObjectsService.TaggableObjectRef, List<Discussion>> discussions = this.getAllDiscussions();
        for (Map.Entry<TaggableObjectsService.TaggableObjectRef, List<Discussion>> entry : discussions.entrySet()) {
            if (!workspaceKey.equals(entry.getKey().workspaceKey)) continue;
            for (Discussion discu : entry.getValue()) {
                this.discussionsDB.deleteDiscussion(discu.projectKey, workspaceKey, discu.id);
                affectedTors.add(entry.getKey());
                affectedUsers.addAll(this.discussionsCacheService.deleteDiscussion(entry.getKey(), discu.id, false));
            }
        }
        this.massActionSendEvents(affectedTors, affectedUsers);
    }

    public void enrich(Discussion discussion) {
        try {
            TaggableObjectsService.TaggableObject to = this.taggableObjectsReadService.getMandatoryUnsafe(discussion.projectKey, discussion.objectType, discussion.objectId);
            discussion.objectDisplayName = to.getDisplayName();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to enrich discussion with object display name", (Throwable)e);
        }
        for (Discussion.User user : discussion.users.values()) {
            try {
                user.displayName = this.usersService.getPublicUser((String)user.login).displayName;
            }
            catch (Exception e) {
                logger.error((Object)("Failed to get user display name for discussion: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            }
        }
    }

    public void handleTaggableObjectIdChange_NT(ITaggingService.TaggableType type, String projectKey, String oldId, String newId) throws SQLException {
        Preconditions.checkArgument((type == ITaggingService.TaggableType.DATASET || type == ITaggingService.TaggableType.RECIPE ? 1 : 0) != 0);
        this.discussionsDB.changeObjectId(type, projectKey, oldId, newId);
        this.discussionsCacheService.changeTaggableObjectRef(type, projectKey, oldId, newId);
    }
}

