/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.resolver;

import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import java.util.List;

@PolyJSON(value={@Mapping(value=Simple.class, type="SIMPLE"), @Mapping(value=Foreach.class, type="FOREACH"), @Mapping(value=If.class, type="IF"), @Mapping(value=Table.class, type="TABLE")})
public abstract class UnresolvedPlaceholder {

    public static class AsImportedFromPython {
        public List<UnresolvedPlaceholder> placeholders;
    }

    public static class Foreach
    extends UnresolvedPlaceholder {
        public String iterable;
        public String variable;
        public List<UnresolvedPlaceholder> children;

        public Foreach() {
        }

        public Foreach(String variable, String iterable, List<UnresolvedPlaceholder> children) {
            this.iterable = iterable;
            this.variable = variable;
            this.children = children;
        }
    }

    public static class If
    extends UnresolvedPlaceholder {
        public Condition op;
        public String lefthand;
        public String righthand;
        public List<UnresolvedPlaceholder> children;

        public If() {
        }

        public If(String lefthand, Condition op, String righthand, List<UnresolvedPlaceholder> children) {
            this.op = op;
            this.lefthand = lefthand;
            this.righthand = righthand;
            this.children = children;
        }

        public boolean isFulfilled(String resolvedValue) {
            return resolvedValue != null && resolvedValue.equals(this.righthand) == Condition.EQUAL.equals((Object)this.op);
        }

        public static enum Condition {
            EQUAL,
            NOT_EQUAL;

        }
    }

    public static class Table
    extends UnresolvedPlaceholder {
        public List<UnresolvedPlaceholder> children;

        public Table() {
        }

        public Table(List<UnresolvedPlaceholder> children) {
            this.children = children;
        }
    }

    public static class Simple
    extends UnresolvedPlaceholder {
        public String name;

        public Simple() {
        }

        public Simple(String name) {
            this.name = name;
        }
    }
}

