/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.exposition;

import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.coremodel.DkuComponentMetadata;
import com.dataiku.dip.exposition.AbstractKubernetesExpositionHandler;
import com.dataiku.dip.exposition.Exposables;
import com.dataiku.dip.exposition.ExposedEndpointConsumer;
import com.dataiku.dip.exposition.Exposition;
import com.dataiku.dip.exposition.ExpositionDesc;
import com.dataiku.dip.exposition.ExpositionHandler;
import com.dataiku.dip.exposition.ExpositionMeta;
import com.dataiku.dip.exposition.ExpositionParams;
import com.dataiku.dip.exposition.PortForwardUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.DKUNetUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PortForwardToServiceExposition {
    private static DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS").withZone(ZoneId.systemDefault());
    public static final ExpositionMeta META = new ExpositionMeta(){

        @Override
        public String getType() {
            return "port_forward_to_service";
        }

        @Override
        public Class<? extends ExpositionParams> getParamsClass() {
            return PortForwardToServiceExpositionParams.class;
        }

        @Override
        public ExpositionDesc getDesc(ExpositionMeta.ExpositionUsageContext usageContext) {
            return new ExpositionDesc().withType(this.getType()).withMeta(new DkuComponentMetadata("Port forwarding", "Forward to a service using kubectl", null, null));
        }

        @Override
        public long getMaxStartWait(AuthCtx authCtx) {
            return 60000L;
        }

        @Override
        public boolean handles(ContainerExecRuntimeConfig containerConfig) {
            return false;
        }

        @Override
        public boolean handles(ContainerExecRuntimeConfig.Container containerType) {
            return false;
        }

        @Override
        public boolean handles(Exposables.ExposableKind kind) {
            return false;
        }

        @Override
        public ExpositionHandler buildHandler(AuthCtx authCtx, String projectKey, ContainerExecRuntimeConfig containerConfig, Exposition exposition, ExposedEndpointConsumer endpointConsumer) {
            PortForwardToServiceExpositionParams params = exposition.getParamsAs(PortForwardToServiceExpositionParams.class);
            return new PortForwardToServiceExpositionHandler(authCtx, projectKey, containerConfig, params, endpointConsumer);
        }

        @Override
        public void expandParametersInPlace(VariablesContext vc, Exposition exposition) {
        }
    };
    private static Logger logger = Logger.getLogger((String)"dip.webapp.expose");

    private static class PortForwardToServiceExpositionHandler
    extends AbstractKubernetesExpositionHandler
    implements PortForwardUtils.ExpositionLoggingCallbacks,
    PortForwardUtils.SinglePortForwardListener {
        private final PortForwardToServiceExpositionParams params;
        private int port;
        private DKUtils.LineSubscriptionAttacher mainLog;
        private ServicePortForwarderThread servicePortForwarderThread;
        private DKUtils.SmartLogTailBuilder smartLogTailBuilder;
        private ExpositionHandler.ExpositionStatus status = new ExpositionHandler.ExpositionStatus();
        private boolean closed;

        PortForwardToServiceExpositionHandler(AuthCtx authCtx, String projectKey, ContainerExecRuntimeConfig containerConfig, PortForwardToServiceExpositionParams params, ExposedEndpointConsumer endpointConsumer) {
            super(authCtx, projectKey, containerConfig, endpointConsumer);
            this.params = params;
        }

        @Override
        public boolean objectIsKnown(String objectId) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void cleanup() {
            this.closed = true;
            if (this.servicePortForwarderThread != null) {
                this.servicePortForwarderThread.kill();
                return;
            }
            Class<PortForwardToServiceExposition> clazz = PortForwardToServiceExposition.class;
            synchronized (PortForwardToServiceExposition.class) {
                try {
                    FileUtils.write((File)new File(this.tmpDir, "port-forward-" + this.exposedService + "-start.json"), (CharSequence)Long.toString(-1L), (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    logger.error((Object)"Failed to write thread stop flag", (Throwable)e);
                }
                return;
            }
        }

        @Override
        public void start(DKUtils.LineSubscriptionAttacher mainLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) throws Exception {
            this.mainLog = mainLog;
            this.smartLogTailBuilder = smartLogTailBuilder;
            this.status = new ExpositionHandler.ExpositionStatus();
            this.status.isHealthy = true;
            this.servicePortForwarderThread = new ServicePortForwarderThread();
            this.servicePortForwarderThread.start();
        }

        @Override
        public void waitReady(DKUtils.LineSubscriptionAttacher mainLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) throws Exception {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ExpositionHandler.ExpositionStatus getStatus(DKUtils.LineSubscriptionAttacher mainLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) throws Exception {
            if (this.closed) {
                return new ExpositionHandler.ExpositionStatus();
            }
            if (this.status != null && this.servicePortForwarderThread != null) {
                return this.status;
            }
            Class<PortForwardToServiceExposition> clazz = PortForwardToServiceExposition.class;
            synchronized (PortForwardToServiceExposition.class) {
                File f = new File(this.tmpDir, "port-forward-" + this.exposedService + "-status.json");
                if (f.exists()) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return (ExpositionHandler.ExpositionStatus)JSON.parseFile((File)f, ExpositionHandler.ExpositionStatus.class);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return new ExpositionHandler.ExpositionStatus();
            }
        }

        @Override
        public ExposedEndpointConsumer.ExposedEndpoint getExpectedExposedEndpoint() {
            return new ExposedEndpointConsumer.ExposedEndpoint(META.getType(), "svc", null, null, this.port, null, ExposedEndpointConsumer.ExposedEndpointAvailability.LOCAL);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void logLine(String line) {
            logger.info((Object)line);
            String now = dateFormat.format(Instant.now());
            String lineWithTimestamp = "[" + now + "] " + line;
            if (this.mainLog != null) {
                DKUtils.LineSubscription subLog = this.mainLog.getSubSubscription("[pf-" + this.exposedService + "] ");
                try {
                    subLog.handle(lineWithTimestamp, false);
                }
                catch (IOException e) {
                    logger.warn((Object)"Unable to log to rotating file", (Throwable)e);
                }
                finally {
                    try {
                        subLog.close();
                    }
                    catch (IOException e) {
                        logger.warn((Object)"Error while handling logs", (Throwable)e);
                    }
                }
            }
            if (this.smartLogTailBuilder != null) {
                this.smartLogTailBuilder.appendLine(lineWithTimestamp);
            }
        }

        @Override
        public DKUtils.SmartLogTailBuilder getSmartLogTailBuilder() {
            return this.smartLogTailBuilder;
        }

        @Override
        public DKUtils.LineSubscription getSubSubscription(String name) {
            return this.mainLog.getSubSubscription(name);
        }

        @Override
        public void handleMainLog(String line) throws IOException {
            this.mainLog.handle(line, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forward(String objectId, int port) throws Exception {
            logger.info((Object)("Forwarding of " + this.exposedService + " on " + port + " started"));
            ExposedEndpointConsumer.ExposedEndpoint endpoint = new ExposedEndpointConsumer.ExposedEndpoint(META.getType(), "svc", null, null, port, null, ExposedEndpointConsumer.ExposedEndpointAvailability.LOCAL);
            this.endpointConsumer.registerPort(endpoint);
            this.status.endpoints.add(endpoint);
            Class<PortForwardToServiceExposition> clazz = PortForwardToServiceExposition.class;
            synchronized (PortForwardToServiceExposition.class) {
                JSON.prettyToFile((Object)this.status, (File)new File(this.tmpDir, "port-forward-" + this.exposedService + "-status.json"));
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unforward(String objectId, Integer removed) throws Exception {
            logger.info((Object)("Forwarding of " + this.exposedService + " on " + removed + " stopped"));
            this.endpointConsumer.deregisterPort(new ExposedEndpointConsumer.ExposedEndpoint(META.getType(), "svc", null, null, removed == null ? -1 : removed, null, ExposedEndpointConsumer.ExposedEndpointAvailability.LOCAL));
            ArrayList endpointsToRemove = Lists.newArrayList();
            for (ExposedEndpointConsumer.ExposedEndpoint endpoint : this.status.endpoints) {
                if (!StringUtils.equals((String)"svc", (String)endpoint.id)) continue;
                endpointsToRemove.add(endpoint);
            }
            this.status.endpoints.removeAll(endpointsToRemove);
            Class<PortForwardToServiceExposition> clazz = PortForwardToServiceExposition.class;
            synchronized (PortForwardToServiceExposition.class) {
                JSON.prettyToFile((Object)this.status, (File)new File(this.tmpDir, "port-forward-" + this.exposedService + "-status.json"));
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
        }

        @Override
        public void notifyChange() {
        }

        private class ServicePortForwarderThread
        extends PortForwardUtils.SinglePortForwarderThread {
            public ServicePortForwarderThread() {
                super(PortForwardToServiceExpositionHandler.this.executionId, PortForwardToServiceExpositionHandler.this.exposedService, PortForwardToServiceExpositionHandler.this.tmpDir, PortForwardToServiceExpositionHandler.this, PortForwardToServiceExpositionHandler.this, "");
            }

            @Override
            protected int getTargetPort() {
                return PortForwardToServiceExpositionHandler.this.exposedPort;
            }

            @Override
            protected String getObjectDesc() {
                return "service " + this.objectId;
            }

            @Override
            protected ProcessBuilder getKubectlProcessBuilder(int forwardPort) throws IOException, InterruptedException {
                ProcessBuilder pb = new ProcessBuilder(KubernetesExecUtils.getKubeCtlCommand(PortForwardToServiceExpositionHandler.this.authCtx, PortForwardToServiceExpositionHandler.this.projectKey, PortForwardToServiceExpositionHandler.this.containerConfig, false, "port-forward", "services/" + PortForwardToServiceExpositionHandler.this.exposedService, Integer.toString(forwardPort) + ":" + Integer.toString(PortForwardToServiceExpositionHandler.this.exposedPort)));
                pb.environment().putAll(KubernetesExecUtils.getKubeCtlEnv(PortForwardToServiceExpositionHandler.this.containerConfig));
                return pb;
            }

            @Override
            protected int getForwardPort() throws IOException {
                return PortForwardToServiceExpositionHandler.this.params.fixedPort > 0 ? PortForwardToServiceExpositionHandler.this.params.fixedPort : DKUNetUtils.findUnusedPort();
            }
        }
    }

    public static class PortForwardToServiceExpositionParams
    implements ExpositionParams {
        public int fixedPort;
    }
}

