/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.yxdb;

import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.text.Labelled;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;

public class AlteryxDBFormatConfig
implements FormatParams {
    public DateHandling dateTypeHandling = DateHandling.READ_AS_STRING;
    public DateHandling dateTimeTypeHandling = DateHandling.READ_AS_STRING;
    public String assumedTz = "";

    public DateTimeZone getAssumedTimezone() {
        if (this.assumedTz != null && this.assumedTz.length() > 0) {
            return DateTimeZone.forID((String)this.assumedTz);
        }
        return DateTimeZone.getDefault();
    }

    private static String translate(String lang, String id, String defaultValue) {
        TranslationService ts = (TranslationService)SpringUtils.getBean(TranslationService.class);
        return ts.translateNoContext(lang, id, defaultValue, new Object[0]);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum DateHandling implements Labelled
    {
        READ_AS_STRING{

            @Override
            public String getLabel() {
                return this.getLabel("en");
            }

            @Override
            public String getLabel(String language) {
                return AlteryxDBFormatConfig.translate(language, "FORMATS.AlteryxDBFormatConfig.DateHandling.READ_AS_STRING", "String");
            }
        }
        ,
        READ_AS_TIMESTAMP{

            @Override
            public String getLabel() {
                return this.getLabel("en");
            }

            @Override
            public String getLabel(String language) {
                return AlteryxDBFormatConfig.translate(language, "FORMATS.AlteryxDBFormatConfig.DateHandling.READ_AS_TIMESTAMP", "DSS Datetime with tz");
            }
        };

    }
}

