/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats;

import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datasets.fs.FSDatasetUtils;
import com.dataiku.dip.input.formats.AbstractFormatExtractor;
import com.dataiku.dip.input.stream.DecodedInputStreamFactory;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.input.stream.StreamsInputSplit;
import com.dataiku.dip.plugin.InputStreamWithContextInfo;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.input.CloseShieldInputStream;
import com.google.common.base.Stopwatch;
import com.google.common.io.CountingInputStream;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.mutable.MutableLong;

public abstract class ArchiveCapableFormatExtractor
extends AbstractFormatExtractor {
    private final MutableLong totalUncompressedBytes = new MutableLong();
    private final MutableLong totalCompressedBytes = new MutableLong();
    private final MutableLong totalRecords = new MutableLong();
    protected static DKULogger logger = DKULogger.getLogger((String)"dku.format");

    protected abstract boolean doExtractStream(InputStreamWithContextInfo var1, ProcessorOutput var2, ColumnFactory var3, RowFactory var4, ArchiveCapableObserver var5) throws Exception;

    @Override
    public boolean run(StreamsInputSplit in, ProcessorOutput out, ColumnFactory cf, RowFactory rf) throws Exception {
        EnrichedInputStream stream;
        logger.infoV("Extractor run: limit=%s totalRecords=%d", new Object[]{JSON.json((Object)this.limit), this.totalRecords.longValue()});
        while ((stream = in.nextStream()) != null) {
            if (stream.isArchive()) {
                if (!this.extractArchive(out, cf, rf, stream)) {
                    return false;
                }
            } else if (ArchiveCapableFormatExtractor.isSupportedCompressionScheme(stream.getCompression())) {
                if (!this.extractSimple(out, cf, rf, stream)) {
                    return false;
                }
            } else {
                throw new NotImplementedException();
            }
            logger.infoV("after stream totalComp=%d totalUncomp=%d totalRec=%d", new Object[]{this.totalCompressedBytes.longValue(), this.totalUncompressedBytes.longValue(), this.totalRecords.longValue()});
            if (this.listener == null) continue;
            this.listener.setData(this.totalCompressedBytes.longValue(), this.totalUncompressedBytes.longValue(), this.totalRecords.longValue());
        }
        logger.infoV("Extractor run done, totalCompressed=%d totalRecords=%d", new Object[]{this.totalCompressedBytes.longValue(), this.totalRecords.longValue()});
        return true;
    }

    private boolean extractArchive(ProcessorOutput out, ColumnFactory cf, RowFactory rf, EnrichedInputStream stream) throws Exception {
        long archiveUncompressedBytes = 0L;
        try (ArchiveInputStream archiveStream = stream.archiveContent();){
            ArchiveEntry entry;
            while ((entry = archiveStream.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                logger.info((Object)("  Start archive stream entry : " + stream.desc() + "/" + entry.getName() + " size= " + entry.getSize()));
                if (FSDatasetUtils.isBadFile(entry.getName())) continue;
                archiveUncompressedBytes += entry.getSize();
                ArchiveCapableObserver observer = new ArchiveCapableObserver(){

                    @Override
                    public void onInterval(long streamRecords) throws InterruptedException {
                        if (ArchiveCapableFormatExtractor.this.listener != null) {
                            ArchiveCapableFormatExtractor.this.listener.setData(0L, 0L, ArchiveCapableFormatExtractor.this.totalRecords.longValue() + streamRecords);
                        }
                    }

                    @Override
                    public boolean checkLimit(long streamRecords) {
                        return ArchiveCapableFormatExtractor.this.limit == null || ArchiveCapableFormatExtractor.this.limit.maxRecords <= 0L || ArchiveCapableFormatExtractor.this.limit.maxRecords > ArchiveCapableFormatExtractor.this.totalRecords.longValue() + streamRecords;
                    }

                    @Override
                    public void onEnd(long streamRecords) throws InterruptedException {
                        this.onInterval(streamRecords);
                        ArchiveCapableFormatExtractor.this.totalRecords.add(streamRecords);
                    }
                };
                this.rc.setFile(stream.desc() + "/" + entry.getName());
                InputStreamWithContextInfo isn = new InputStreamWithContextInfo((InputStream)new CloseShieldInputStream((InputStream)archiveStream), stream.getPathWithinProvider() + "/" + entry.getName(), stream.getFilename() + "/" + entry.getName(), stream.getPartition(), stream.getLastModifiedSupplier());
                if (this.doExtractStream(isn, out, cf, rf, observer)) continue;
                logger.info((Object)"Limit reached");
                boolean bl = false;
                return bl;
            }
        }
        this.totalCompressedBytes.add(stream.size());
        this.totalUncompressedBytes.add(archiveUncompressedBytes);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean extractSimple(ProcessorOutput out, ColumnFactory cf, RowFactory rf, EnrichedInputStream stream) throws Exception {
        CountingInputStream decompressedInputStream;
        InputStream rawStream = stream.rawHeadStream(this.limit != null ? this.limit.maxBytes : -1L);
        CountingInputStream rawCounter = new CountingInputStream(rawStream);
        logger.infoV("Start %s stream: %s / totalRecsBefore=%d", new Object[]{ArchiveCapableFormatExtractor.compressionSchemeDisplayName(stream.getCompression()), stream.desc(), this.totalRecords.longValue()});
        if (stream.getCompression() == EnrichedInputStream.Compression.NONE) {
            decompressedInputStream = rawCounter;
        } else {
            InputStream decompressedStream;
            try {
                decompressedStream = new DecodedInputStreamFactory().addDecoding(stream.getCompression(), (InputStream)rawCounter);
            }
            catch (Exception e) {
                IOUtils.closeQuietly((InputStream)rawCounter);
                throw e;
            }
            decompressedInputStream = new CountingInputStream(decompressedStream);
        }
        try {
            this.rc.setFile(stream.desc());
            InputStreamWithContextInfo isn = new InputStreamWithContextInfo((InputStream)decompressedInputStream, stream.getPathWithinProvider(), stream.getFilename(), stream.getPartition(), stream.getLastModifiedSupplier());
            if (!this.doExtractStream(isn, out, cf, rf, new SimpleArchiveObserver(rawCounter, decompressedInputStream))) {
                logger.info((Object)"Limit reached");
                boolean e = false;
                return e;
            }
            this.totalCompressedBytes.add(rawCounter.getCount());
            this.totalUncompressedBytes.add(decompressedInputStream.getCount());
        }
        finally {
            Stopwatch stopwatch = Stopwatch.createStarted();
            IOUtils.closeQuietly((InputStream)decompressedInputStream);
            long elapsed = stopwatch.elapsed(TimeUnit.MILLISECONDS);
            if (elapsed > 100L) {
                logger.info((Object)("Stream " + stream.desc() + " closed after " + elapsed + "ms"));
            }
        }
        return true;
    }

    private static String compressionSchemeDisplayName(EnrichedInputStream.Compression compression) {
        if (compression == EnrichedInputStream.Compression.NONE) {
            return "uncompressed";
        }
        return "compressed [" + String.valueOf(compression) + "]";
    }

    private static boolean isSupportedCompressionScheme(EnrichedInputStream.Compression compression) {
        switch (compression) {
            case GZIP: 
            case BZIP2: 
            case DEFLATE: 
            case LZO: 
            case SNAPPY: 
            case ZSTD: 
            case NONE: {
                return true;
            }
        }
        return false;
    }

    public static interface ArchiveCapableObserver {
        public boolean checkLimit(long var1);

        public void onInterval(long var1) throws InterruptedException;

        public void onEnd(long var1) throws InterruptedException;
    }

    private class SimpleArchiveObserver
    implements ArchiveCapableObserver {
        private final CountingInputStream inputStream;
        private final CountingInputStream uncompressedInputStream;

        public SimpleArchiveObserver(CountingInputStream inputStream, CountingInputStream uncompressedInputStream) {
            this.inputStream = inputStream;
            this.uncompressedInputStream = uncompressedInputStream;
        }

        @Override
        public boolean checkLimit(long streamRecords) {
            if (ArchiveCapableFormatExtractor.this.limit != null) {
                if (ArchiveCapableFormatExtractor.this.limit.maxBytes > 0L && ArchiveCapableFormatExtractor.this.limit.maxBytes < ArchiveCapableFormatExtractor.this.totalCompressedBytes.longValue() + this.inputStream.getCount()) {
                    return false;
                }
                if (ArchiveCapableFormatExtractor.this.limit.maxRecords > 0L && ArchiveCapableFormatExtractor.this.limit.maxRecords <= ArchiveCapableFormatExtractor.this.totalRecords.longValue() + streamRecords) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public void onInterval(long streamRecords) throws InterruptedException {
            if (ArchiveCapableFormatExtractor.this.listener != null) {
                ArchiveCapableFormatExtractor.this.listener.setData(ArchiveCapableFormatExtractor.this.totalCompressedBytes.longValue() + this.inputStream.getCount(), ArchiveCapableFormatExtractor.this.totalUncompressedBytes.longValue() + this.uncompressedInputStream.getCount(), ArchiveCapableFormatExtractor.this.totalRecords.longValue() + streamRecords);
            }
        }

        @Override
        public void onEnd(long streamRecords) throws InterruptedException {
            this.onInterval(streamRecords);
            ArchiveCapableFormatExtractor.this.totalRecords.add(streamRecords);
        }
    }
}

