/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.io;

import com.dataiku.dip.exceptions.PivotMissingColumnException;
import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.io.LinoMetaFile;
import com.dataiku.dip.pivot.UnsupportedOperation;
import com.dataiku.dip.pivot.backend.model.CorruptedDataException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.fontbox.ttf.BufferedRandomAccessFile;

public class LinoReader
implements Closeable {
    private final LinoMetaFile meta;
    private final BufferedRandomAccessFile bfile;
    private final Map<String, LinoMetaFile.ColumnHeader> columnsMapping;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.shaker.pivot");

    public LinoReader(File folder, String name) throws IOException {
        this.meta = (LinoMetaFile)JSON.parseFile((File)new File(folder, name + ".meta.json"), LinoMetaFile.class);
        this.columnsMapping = this.meta.cols.stream().collect(Collectors.toMap(val -> val.name, Function.identity()));
        File f = new File(folder, name + ".data");
        this.bfile = new BufferedRandomAccessFile(f, "r", 500000);
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Closeable)this.bfile);
    }

    public int nblocks() {
        return this.meta.blockIndex.length;
    }

    public long nbRecords() {
        return this.meta.nbRecords;
    }

    public List<LinoMetaFile.ColumnHeader> getColumns() {
        return this.meta.cols;
    }

    public long blockSizeAtIndex(int i) {
        return this.meta.blockIndex[i];
    }

    public LinoMetaFile.ColumnHeader getColHeader(String colName) {
        LinoMetaFile.ColumnHeader columnHeader = this.columnsMapping.get(colName);
        if (columnHeader == null) {
            throw new PivotMissingColumnException(colName);
        }
        return columnHeader;
    }

    public Optional<LinoMetaFile.ColumnHeader> getColHeaderOptional(String colName) {
        return Optional.ofNullable(this.columnsMapping.get(colName));
    }

    public boolean isGeo(String colName) {
        return this.columnsMapping.containsKey(colName + "__dku_lon");
    }

    public ColumnBlock readColumnBlock(String colName, int blockIdx) throws IOException {
        LinoMetaFile.ColumnHeader col = this.getColHeader(colName);
        if (col.fellBack) {
            throw new UnsupportedOperation(String.format("Column %s has too many different values to be used.", colName));
        }
        long offset = col.offsets[blockIdx];
        if (offset >= this.bfile.length()) {
            logger.error((Object)("Mismatch between cached data and metadata: offset (" + offset + ") exceeds file length (" + this.bfile.length() + "). Possible data corruption or stale cache."));
            throw new CorruptedDataException("Data inconsistency detected, please clear your chart cache or create a new sampling.");
        }
        this.bfile.seek(offset);
        ColumnBlock cblock = new ColumnBlock(this.bfile);
        cblock.name = colName;
        cblock.fellBack = col.fellBack;
        cblock.realType = col.realType;
        if (col.memType == ColumnBlock.MemoryType.STRING_DICT) {
            cblock.stringDict = col.stringDict;
        }
        return cblock;
    }
}

