/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.labeling;

import com.dataiku.dip.datasets.labeling.LabelsDatasetParams;
import com.dataiku.dip.labeling.BaseLabelingAnswer;
import com.dataiku.dip.labeling.LabelingAnswer;
import com.dataiku.dip.labeling.LabelingAnswerCRUDService;
import com.dataiku.dip.labeling.LabelingInternalDBService;
import com.dataiku.dip.labeling.LabelingService;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.labeling.VerifiedLabelingAnswer;
import com.dataiku.dip.labeling.consensus.ResolutionService;
import com.dataiku.dip.security.AuthCtx;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LocalLabelingAnswerCRUDService
implements LabelingAnswerCRUDService {
    @Autowired
    private LabelingInternalDBService labelingInternalDBService;
    @Autowired
    private LabelingService labelingService;
    @Autowired
    private ResolutionService resolutionService;

    @Override
    public List<LabelingAnswer> listAllNoCheckMetadata(AuthCtx authCtx, String projectKey, String labelingTaskId) throws Exception {
        return this.labelingInternalDBService.listAllNoCheckMetadata(authCtx, this.labelingService.getLabelingTask(projectKey, labelingTaskId));
    }

    @Override
    public List<VerifiedLabelingAnswer> listAllVerifiedNoCheckMetadata(AuthCtx authCtx, String projectKey, String labelingTaskId) throws Exception {
        return this.labelingInternalDBService.listAllVerifiedNoCheckMetadata(authCtx, this.labelingService.getLabelingTask(projectKey, labelingTaskId));
    }

    @Override
    public List<? extends LabelingAnswerCRUDService.BaseLabelingAnswerWithOutputData<? extends BaseLabelingAnswer>> listAllForLabelsDataset(AuthCtx authCtx, String projectKey, String labelingTaskId, LabelsDatasetParams.View view) throws Exception {
        LabelingTask labelingTask = this.labelingService.getLabelingTask(projectKey, labelingTaskId);
        return this.labelingInternalDBService.listAllForLabelsDataset(authCtx, labelingTask, this.labelingService.getMetadataDataset(labelingTask), view);
    }

    @Override
    public long countAnswers(AuthCtx authCtx, String projectKey, String labelingTaskId, LabelsDatasetParams.View view) throws Exception {
        LabelingTask labelingTask = this.labelingService.getLabelingTask(projectKey, labelingTaskId);
        return this.labelingInternalDBService.countAllForLabelsDataset(authCtx, labelingTask, this.labelingService.getMetadataDataset(labelingTask), view);
    }

    @Override
    public long getLastUpdateForLabelsDataset(AuthCtx authCtx, String projectKey, String labelingTaskId, LabelsDatasetParams.View view) throws Exception {
        LabelingTask labelingTask = this.labelingService.getLabelingTask(projectKey, labelingTaskId);
        return this.labelingInternalDBService.getLastUpdateForLabelsDataset(authCtx, labelingTask, this.labelingService.getMetadataDataset(labelingTask), view);
    }

    @Override
    public LabelingAnswer upsertLabelingAnswer(LabelingAnswer labelingAnswer, LabelingTask labelingTask, AuthCtx authCtx, boolean canReview) throws Exception {
        Optional<VerifiedLabelingAnswer> verifiedLabelingAnswer = this.labelingInternalDBService.getVerified(authCtx, labelingTask, labelingAnswer.recordId);
        if (verifiedLabelingAnswer.isPresent()) {
            boolean userReviewedAnswer = verifiedLabelingAnswer.get().reviewer.equals(authCtx.getIdentifier());
            if (!(canReview && userReviewedAnswer && labelingTask.autoValidateAnswers)) {
                throw new IllegalArgumentException("This record has already been reviewed, you cannot submit a new answer for it");
            }
        }
        long currentTime = System.currentTimeMillis();
        labelingAnswer.validate(labelingTask);
        labelingAnswer.lastUpdateTime = currentTime;
        labelingAnswer.annotatorId = authCtx.getIdentifier();
        if (labelingAnswer.creationTime <= 0L) {
            labelingAnswer.creationTime = currentTime;
        }
        labelingAnswer.status = LabelingAnswer.AnswerStatus.PENDING_REVIEW;
        this.labelingInternalDBService.saveAnswer(labelingAnswer);
        if (labelingTask.autoValidateAnswers && canReview) {
            VerifiedLabelingAnswer autoVerifiedLabelingAnswer = new VerifiedLabelingAnswer(labelingTask.projectKey, labelingTask.id, labelingAnswer.recordId, labelingAnswer.label);
            this.resolutionService.saveConsensus(labelingTask, autoVerifiedLabelingAnswer, authCtx);
        }
        return labelingAnswer;
    }
}

