/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.engines;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputation;
import com.dataiku.dip.metrics.MetricsEngineDesc;
import com.dataiku.dip.metrics.engines.JdbcEngine;
import com.dataiku.dip.metrics.engines.MetricsEngineRun;
import com.dataiku.dip.metrics.engines.MetricsQueryBuilder;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.queries.QueryBunch;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.security.AuthCtx;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class SQLMetricsEngine
extends JdbcEngine
implements MetricsQueryBuilder.MetricsQueryBuilderEngine {
    public final String filter;

    public SQLMetricsEngine(MetricsEngineRun engineRun, Dataset dataset, Partition partition, JdbcEngine.SQLMetricsEngineConfig config) {
        super(dataset, partition);
        this.filter = ((SQLMetricsEngineRun)engineRun).filter;
    }

    @Override
    public void setupConnection(AuthCtx authCtx) throws IOException, SQLException, DKUSecurityException {
        this.connectionData = DatasetInspector.getSQLConnectionForSQLAbleDatasetOrHive(authCtx, this.dataset);
        this.dialect = this.connectionData.getDialect();
    }

    @Override
    public QueryBunch buildQuery(AuthCtx authCtx, List<MetricComputation> computations, Map<String, String> alreadyComputed) throws Exception {
        MetricsQueryBuilder builder = new MetricsQueryBuilder();
        return builder.buildQuery(authCtx, this, computations, alreadyComputed, this.filter);
    }

    @Override
    public Map<Metric, String> getAggregates(QueryRunResult rs2, List<MetricComputation> computations) throws Exception {
        HashMap metricsValues = Maps.newHashMap();
        for (int i = 0; i < computations.size(); ++i) {
            MetricComputation computation = computations.get(i);
            MetricsQueryBuilder.MetricsQueryBuilderAggregation computer = (MetricsQueryBuilder.MetricsQueryBuilderAggregation)((Object)computation.computer);
            metricsValues.put(computation.metric, computer.getAggregate(rs2, computation));
        }
        return metricsValues;
    }

    public static class SQLMetricsEngineRun
    extends MetricsEngineRun {
        private String filter;
        private boolean usesWindowFunctionAsAggregate;
        private boolean neverMergeable = false;

        public SQLMetricsEngineRun() {
            super(MetricsEngineDesc.SQLMetricsEngine);
        }

        public SQLMetricsEngineRun(double cost, List<MetricComputation> computations, int pass) {
            super(MetricsEngineDesc.SQLMetricsEngine, cost, computations, pass);
        }

        public SQLMetricsEngineRun withUsesWindowFunctionAsAggregate(boolean usesWindowFunctionAsAggregate) {
            this.usesWindowFunctionAsAggregate = usesWindowFunctionAsAggregate;
            return this;
        }

        public SQLMetricsEngineRun withFilter(String filter) {
            this.filter = filter;
            return this;
        }

        public SQLMetricsEngineRun neverMergeable() {
            this.neverMergeable = true;
            return this;
        }

        @Override
        protected MetricsEngineRun subset(double cost, List<MetricComputation> computations) {
            return new SQLMetricsEngineRun(cost, computations, this.pass).withFilter(this.filter).withUsesWindowFunctionAsAggregate(this.usesWindowFunctionAsAggregate);
        }

        @Override
        public boolean canMergeWith(MetricsEngineRun other) {
            if (!super.canMergeWith(other)) {
                return false;
            }
            if (!(other instanceof SQLMetricsEngineRun)) {
                return false;
            }
            SQLMetricsEngineRun otherRun = (SQLMetricsEngineRun)other;
            if (this.neverMergeable || otherRun.neverMergeable) {
                return false;
            }
            if (!StringUtils.equals((String)this.filter, (String)otherRun.filter)) {
                return false;
            }
            if (this.usesWindowFunctionAsAggregate != otherRun.usesWindowFunctionAsAggregate) {
                return false;
            }
            int maxComputationCount = DKUApp.getParams().getIntParam("dku.metricsEngine.sql.maxMetricsPerRun", Integer.valueOf(500));
            return this.countAfterMergeStaysBelow(other, maxComputationCount);
        }
    }
}

