/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.aggregators;

import com.dataiku.dip.pivot.backend.dss.AxisHandler;
import com.dataiku.dip.pivot.backend.dss.DoubleDataTensor;
import com.dataiku.dip.pivot.backend.dss.DoubleDataTensorWithRowCounts;
import com.dataiku.dip.pivot.backend.dss.aggregators.AbstractAggregator;
import com.dataiku.dip.pivot.backend.dss.aggregators.DoubleAggregator;
import com.dataiku.dip.pivot.backend.model.Aggregation;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorRequest;
import java.io.IOException;

public abstract class FirstLastAbstractAggregator
extends DoubleAggregator {
    private static final String ERROR_MESSAGE = "";

    protected FirstLastAbstractAggregator(Aggregation req, int[] numBins) {
        super(req, (DoubleDataTensor)new DoubleDataTensorWithRowCounts.Builder().axisLengths(numBins).initNonNullCounts(true).defaultTensorValue(Double.NaN).build(), ERROR_MESSAGE);
    }

    protected FirstLastAbstractAggregator(Aggregation req, int bins) {
        super(req, (DoubleDataTensor)new DoubleDataTensorWithRowCounts.Builder().axisLengths(bins).initNonNullCounts(true).defaultTensorValue(Double.NaN).build(), ERROR_MESSAGE);
    }

    protected FirstLastAbstractAggregator(Aggregation req) {
        this(req, 1);
    }

    protected abstract void mergeSimplePivotOtherValue(OtherCategoryPropertiesWithRowNumber var1, double var2, long var4);

    public DoubleDataTensorWithRowCounts getMergeDT() {
        return (DoubleDataTensorWithRowCounts)this.mergeDT;
    }

    public DoubleDataTensorWithRowCounts getOutDT() {
        return (DoubleDataTensorWithRowCounts)this.outDT;
    }

    @Override
    public AbstractAggregator.OtherCategoryProperties<Double> retrieveOthersCategoryProperties(AxisHandler.Axis axis) {
        OtherCategoryPropertiesWithRowNumber otherCategoryProperties = new OtherCategoryPropertiesWithRowNumber();
        otherCategoryProperties.otherValueRowNumber = 0L;
        otherCategoryProperties.aggrOfOthersColumn = null;
        for (int x = 0; x < axis.elts.size(); ++x) {
            if (!axis.elts.get((int)x).cutoffed) continue;
            int origBin = axis.elts.get((int)x).binIndex;
            double currentValue = this.getOutDT().getAsDouble(origBin);
            if (!Double.isFinite(currentValue)) continue;
            long currentValueRowNumber = this.getOutDT().getRowNumber(origBin);
            this.mergeSimplePivotOtherValue(otherCategoryProperties, currentValue, currentValueRowNumber);
            otherCategoryProperties.nonNullCountOfOthersColumn += this.getOutDT().nonNullCounts[origBin];
        }
        return otherCategoryProperties;
    }

    protected abstract void mergeTensorValues(int[] var1, double var2, long var4, double var6, long var8);

    @Override
    public boolean mergeTensorAndAxes(PivotTableTensorRequest request, int[] origCoordinates, int[] targetCoordinates, AxisHandler.Axis[] axes) throws IOException {
        for (int i = 0; i < axes.length; ++i) {
            if (targetCoordinates[i] != axes[i].nbNotCutoff || request.axes[i].sortPrune.generateOthersCategory) continue;
            return false;
        }
        double value = this.getOutDT().getAsDouble(origCoordinates);
        double oldValue = this.getMergeDT().getAsDouble(targetCoordinates);
        if (!Double.isNaN(value)) {
            long currentValueRowNumber = this.getOutDT().getRowNumber(origCoordinates);
            long oldValueRowNumber = this.getMergeDT().getRowNumber(targetCoordinates);
            this.mergeTensorValues(targetCoordinates, value, currentValueRowNumber, oldValue, oldValueRowNumber);
        }
        if (this.getOutDT().hasNullValues) {
            this.getMergeDT().incrementNonNullCount(targetCoordinates, this.getOutDT().getNonNullCount(origCoordinates));
        }
        return true;
    }

    protected abstract double mergeAxisDoubleValues(int var1, int var2, double var3);

    protected abstract double mergeTensorDoubleValues(int[] var1, double var2);

    @Override
    protected void handle(double value, int[] coords, boolean fillAxes) throws IOException {
        ++this.rowCount;
        if (Double.isFinite(value)) {
            if (fillAxes) {
                for (int i = 0; i < this.getOutDT().numAxes; ++i) {
                    this.getOutDT().setAxisAsDouble(i, coords[i], this.mergeAxisDoubleValues(i, coords[i], value));
                }
                this.getOutDT().incrementAxesNonNullCount(coords);
            }
            this.getOutDT().setAsDouble(coords, this.mergeTensorDoubleValues(coords, value));
            this.getOutDT().incrementNonNullCount(coords);
        } else {
            this.getOutDT().hasNullValues = true;
        }
    }

    public static class OtherCategoryPropertiesWithRowNumber
    extends AbstractAggregator.OtherCategoryProperties<Double> {
        long otherValueRowNumber;
    }
}

