/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.IPluginifiedHolderMeta;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.integrations.AttachmentService;
import com.dataiku.dip.integrations.IntegrationHook;
import com.dataiku.dip.integrations.mail.MailIntegrationHandler;
import com.dataiku.dip.integrations.mail.MailIntegrationParams;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ScenarioReporter;
import com.dataiku.dip.scheduler.reports.ScenarioReporterRunner;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepMetaWithPluginifiedHolder;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;

public class SendReportStepRunner
implements StepRunner {
    public static final StepMeta META = new StepMetaWithPluginifiedHolder(){

        @Override
        public String getType() {
            return "send_report";
        }

        @Override
        public Class<? extends StepParams> paramsClass() {
            return SendReportStepParams.class;
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new SendReportStepRunner(scenario, step, step.getParamsAs(SendReportStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            SendReportStepParams params = step.getParamsAs(SendReportStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("report");
            if (params.messaging != null) {
                sb.append(" to ");
                sb.append(params.messaging.type);
            }
            return sb.toString();
        }

        @Override
        public String buildId(Step step) {
            SendReportStepParams params = step.getParamsAs(SendReportStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("report");
            if (params.messaging != null) {
                sb.append(DigestUtils.md5Hex((String)JSON.json((Object)params.messaging)));
            }
            return sb.toString();
        }

        @Override
        public void prepareForSave(Step step, PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings security) {
            if (step.params instanceof SendReportStepParams) {
                SendReportStepParams params = (SendReportStepParams)step.params;
                if (params.messaging != null && params.messaging.configuration != null) {
                    params.messaging.configuration.encryptFields(cryptoService, security);
                }
            }
        }

        @Override
        public List<IPluginifiedHolderMeta.Pluginifiable> getPluginifiables(Object object, String payload) {
            ArrayList components = Lists.newArrayList();
            if (object instanceof Step) {
                Step step = (Step)object;
                SendReportStepParams stepParams = step.getParamsAs(SendReportStepParams.class);
                if (MailIntegrationHandler.SCENARIO_META.getType().equals(stepParams.messaging.type)) {
                    MailIntegrationParams.MailScenarioIntegrationParams params = (MailIntegrationParams.MailScenarioIntegrationParams)stepParams.messaging.configuration;
                    for (AttachmentService.MailScenarioAttachment attachment : params.attachments) {
                        if (attachment.type != AttachmentService.AttachmentType.DATASET) continue;
                        AttachmentService.DatasetExportAttachment exportAttachment = (AttachmentService.DatasetExportAttachment)JSON.parse((String)JSON.json((Object)attachment.params), AttachmentService.DatasetExportAttachment.class);
                        PluginUsagesInspector.addExporterComponentToList(components, exportAttachment.exportParams);
                    }
                }
            }
            return components;
        }
    };
    private final SendReportStepParams params;
    private final Step step;
    private final Scenario scenario;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenario.sendreport");

    public SendReportStepRunner(Scenario scenario, Step step, SendReportStepParams params) {
        this.scenario = scenario;
        this.step = step;
        this.params = params;
    }

    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        logger.info((Object)("Start step " + this.step.name));
        try {
            ScenarioReporter reporter = new ScenarioReporter();
            reporter.messaging = this.params.messaging;
            ScenarioReporterRunner runner = ScenarioReporterRunner.build(reporter, stepRun.getScenarioRun(), this.scenario);
            InfoMessage.InfoMessages messages = runner.sendMessage(null);
            messages.summarize();
            if (messages.fatal || messages.error || messages.warning) {
                logger.warn((Object)("Send message step completed with warnings: " + messages.report()));
                stepReportItem.withOutcome(ReportItem.Outcome.WARNING);
            } else {
                stepReportItem.withOutcome(ReportItem.Outcome.SUCCESS);
            }
        }
        catch (Throwable e) {
            logger.warn((Object)("Failure during report : " + e.getMessage()), e);
            if (this.params.failOnMessageNotSent) {
                throw e;
            }
            stepReportItem.withOutcome(ReportItem.Outcome.WARNING);
        }
    }

    public static class SendReportStepParams
    implements StepParams {
        public boolean failOnMessageNotSent = true;
        public IntegrationHook messaging = new IntegrationHook();

        public boolean getFailOnMessageNotSent() {
            return this.failOnMessageNotSent;
        }
    }
}

