/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.triggers;

import com.dataiku.dip.custom.IElementLoadedDesc;
import com.dataiku.dip.custom.IPluginifiedMeta;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.scheduler.TicketBasedCustomPythonRunner;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.scheduler.triggers.LoadedPythonPluginTrigger;
import com.dataiku.dip.scheduler.triggers.PythonPluginTriggersService;
import com.dataiku.dip.scheduler.triggers.Trigger;
import com.dataiku.dip.scheduler.triggers.TriggerFire;
import com.dataiku.dip.scheduler.triggers.TriggerMeta;
import com.dataiku.dip.scheduler.triggers.TriggerParams;
import com.dataiku.dip.scheduler.triggers.TriggerRunner;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.process.InsecureProcessesLaunchService;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.services.ScenariosBaseService;
import com.dataiku.dip.server.services.ScenariosTriggerService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;

public class PythonPluginTriggerRunner
implements TriggerRunner {
    @Autowired
    private APITicketService apiTicketService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ScenariosBaseService scenariosBaseService;
    @Autowired
    private InsecureProcessesLaunchService insecureProcessesLaunchService;
    @Autowired
    private PythonPluginTriggersService pythonPluginTriggersService;
    private final PythonPluginTriggerParams params;
    private final Trigger trigger;
    private final Scenario scenario;
    private final LoadedPythonPluginTrigger desc;
    private final String pluginId;

    public PythonPluginTriggerRunner(Scenario scenario, String pluginId, LoadedPythonPluginTrigger desc, Trigger trigger, PythonPluginTriggerParams params) {
        this.pluginId = pluginId;
        this.desc = desc;
        this.trigger = trigger;
        this.params = params;
        this.scenario = scenario;
    }

    @Override
    public TriggerFire run(ScenariosTriggerService triggerService, AuthCtx authCtx) throws Exception {
        DSSAuthCtx liu;
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.scenariosBaseService.getRunAsUser(this.scenario);
        }
        String stateString = triggerService.getTriggerState(this.scenario, this.trigger);
        TriggerFire triggerFire = new TriggerFire().withScenario(this.scenario).withTrigger(this.trigger);
        File runFolder = ScenarioRunContext.scenarioFolder(this.scenario.getProjectKey(), this.scenario.getId());
        File pythonRunFolder = DKUFileUtils.getWithin((File)runFolder, (String[])new String[]{"custom-trigger-" + this.trigger.getId()});
        TicketBasedCustomPythonRunner pythonRunner = new TicketBasedCustomPythonRunner(this.apiTicketService, this.insecureProcessesLaunchService, "plugin_trigger:" + this.scenario.getProjectKey() + "." + this.scenario.getId(), liu, pythonRunFolder, triggerFire, true);
        HashMap extraEnv = Maps.newHashMap();
        HashMap fileBasedEnv = Maps.newHashMap();
        extraEnv.put("DKU_TRIGGER", JSON.json((Object)this.trigger));
        extraEnv.put("DKU_CURRENT_PROJECT_KEY", this.scenario.getProjectKey());
        if (stateString != null) {
            extraEnv.put("DKU_TRIGGER_STATE", stateString);
        }
        ReportItem.TriggerFired reportItem = new ReportItem.TriggerFired(new ReportTargetItem.ScenarioTriggerItem(this.scenario.getProjectKey(), this.scenario.getId(), this.trigger.getId()));
        String code = this.pythonPluginTriggersService.getCode(this.desc.triggerType);
        pythonRunner.addPythonLib("plugin-python-lib", this.pythonPluginTriggersService.getLibFolder(this.desc.triggerType));
        extraEnv.put("DKU_PLUGIN_CONFIG", JSON.json((Object)this.pythonPluginTriggersService.getExpandedPluginSettings(this.desc.triggerType, authCtx, this.scenario.getProjectKey(), this.params.config)));
        this.pythonPluginTriggersService.putResourceFolderEnvironmentVariable(extraEnv, this.desc.triggerType, true, "DKU_PLUGIN_RESOURCES");
        extraEnv.put("DKU_PLUGIN_TRIGGER_CONFIG", JSON.json((Object)this.params.config));
        pythonRunner.run(code, extraEnv, fileBasedEnv, this.scenario.getProjectKey(), this.pluginId, null, reportItem, GeneralSettingsDAO.CGrouppableProcessType.PYTHON_SCENARIO);
        return triggerFire.executedFromExternal ? triggerFire : null;
    }

    public static class PythonPluginTriggerParams
    implements TriggerParams {
        public JsonObject config = new JsonObject();
    }

    public static class PythonPluginTriggerMeta
    implements TriggerMeta,
    IPluginifiedMeta {
        private final LoadedPythonPluginTrigger desc;
        private final String pluginId;

        public PythonPluginTriggerMeta(String pluginId, LoadedPythonPluginTrigger desc, PythonPluginTriggersService pythonPluginTriggersService) {
            this.pluginId = pluginId;
            this.desc = desc;
        }

        @Override
        public Class<? extends TriggerParams> paramsClass() {
            return PythonPluginTriggerParams.class;
        }

        @Override
        public String getType() {
            return this.desc.triggerType;
        }

        @Override
        public TriggerRunner buildRunner(Scenario scenario, Trigger trigger) {
            return new PythonPluginTriggerRunner(scenario, this.pluginId, this.desc, trigger, trigger.getParamsAs(PythonPluginTriggerParams.class));
        }

        @Override
        public boolean delayIfScenarioAlreadyRuns() {
            return true;
        }

        @Override
        public String getDigest(Trigger trigger) {
            return "Decided by custom code";
        }

        @Override
        public DateTime getExpectedNextRun(Trigger trigger, String stateString) {
            return null;
        }

        @Override
        public int getForcedTriggerLoopDelay(Trigger trigger, String currentState, boolean loopStarting) {
            return trigger.getDelay();
        }

        @Override
        public IElementLoadedDesc getLoadedDesc() {
            return this.desc;
        }
    }
}

