/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.DkuUser;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.security.BasePermissions;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.PermissionsWatcher;
import com.dataiku.dip.security.PermissionsWatchersService;
import com.dataiku.dip.server.notifications.backend.ProjectsPermissionsChangedEvent;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.notifications.backend.UserChangedEvent;
import com.dataiku.dip.server.notifications.backend.WorkspaceInvitationChangedEvent;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.workspaces.Workspace;
import com.dataiku.dip.workspaces.WorkspacesService;
import com.dataiku.dss.shadelib.com.google.common.collect.HashMultimap;
import com.dataiku.dss.shadelib.com.google.common.collect.Multimap;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PendingUserEmailPermissionUpdateService {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private PubSubService pubSubService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private WorkspacesService workspacesService;
    @Autowired
    private PermissionsWatchersService permissionsWatchersService;
    Multimap<String, String> projectsWithPendingPermissionsByEmail = HashMultimap.create();
    Multimap<String, String> workspacesWithPendingPermissionsByEmail = HashMultimap.create();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.projects.permissions");

    @PostConstruct
    public void init() {
        logger.debug((Object)"Init pendingUserEmail permission update service");
        this.populatePendingPermissionsCache();
        GeneralSettingsDAO.GeneralSettings generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        this.convertAllProjectsPendingPermissionsMatchingUsersIfEnabled(generalSettings);
        this.convertAllWorkspacesPendingPermissionsMatchingUsersIfEnabled(generalSettings);
        this.pubSubService.subscribe("general-settings-changed", evt -> {
            if (!GeneralSettingsService.arePermissionsByEmailEnabled(evt.previousSettings)) {
                this.convertAllProjectsPendingPermissionsMatchingUsersIfEnabled(evt.newSettings);
                this.convertAllWorkspacesPendingPermissionsMatchingUsersIfEnabled(evt.newSettings);
            }
        });
        this.pubSubService.subscribe("project-permissions-changed", this::updateProjectsPendingPermissionsCache);
        this.pubSubService.subscribe("user-edited", evt -> {
            UsersDAO.User user;
            if (evt.action != UserChangedEvent.ActionType.CREATED && evt.action != UserChangedEvent.ActionType.EDITED) {
                return;
            }
            if (this.projectsWithPendingPermissionsByEmail.isEmpty() && this.workspacesWithPendingPermissionsByEmail.isEmpty()) {
                return;
            }
            GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
            if (!GeneralSettingsService.arePermissionsByEmailEnabled(gs)) {
                return;
            }
            try (Transaction ignored = this.transactionService.beginRead();){
                user = this.usersService.getInternalUserOrNullUnsafe(evt.getUserLogin());
            }
            if (user == null || StringUtils.isEmpty((String)user.email) && StringUtils.indexOf((String)user.login, (char)'@') <= 0) {
                return;
            }
            logger.debugV("About to look for pendingUserEmail permissions for user %s.", new Object[]{user.login});
            this.saveProjectsWithMatchingPendingPermissions(user);
            this.saveWorkspacesWithMatchingPendingPermission(user);
            logger.debugV("Done looking for pendingUserEmail permissions for user %s.", new Object[]{user.login});
        });
        this.pubSubService.subscribe("workspace-invitation-changed", this::updateWorkspacePendingPermissionsCache);
        logger.debug((Object)"Done init pendingUserEmail permission update service");
    }

    void populatePendingPermissionsCache() {
        try {
            this.populateProjectsCache();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to populate projects pending permissions cache, cache will be out-of-sync.", (Throwable)e);
        }
        try {
            this.populateWorkspacesCache();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to populate workspaces pending permissions cache, cache will be out-of-sync.", (Throwable)e);
        }
    }

    synchronized void populateWorkspacesCache() throws IOException {
        List<Workspace> workspaces;
        try (Transaction ignored = this.transactionService.beginRead();){
            workspaces = this.workspacesService.listWorkspacesUnsafe();
        }
        catch (IOException e) {
            logger.error((Object)"Failed to list workspaces. Pending permissions cache will be out-of-sync.", (Throwable)e);
            throw e;
        }
        for (Workspace workspace : workspaces) {
            for (BasePermissions.PermissionItem permission : workspace.permissions) {
                if (permission == null || !StringUtils.isNotEmpty((String)permission.pendingUserEmail)) continue;
                this.workspacesWithPendingPermissionsByEmail.put((Object)permission.pendingUserEmail.toLowerCase(Locale.ROOT), (Object)workspace.workspaceKey);
            }
        }
    }

    @VisibleForTesting
    synchronized void populateProjectsCache() throws IOException {
        List<SerializedProject> projects;
        try (Transaction ignored = this.transactionService.beginRead();){
            projects = this.projectsService.listAllUnsafe();
        }
        catch (IOException e) {
            logger.error((Object)"Failed to list projects. Pending permissions cache will be out-of-sync.", (Throwable)e);
            throw e;
        }
        for (SerializedProject sp : projects) {
            for (SerializedProject.PermissionItem permission : sp.permissions) {
                if (permission == null || !StringUtils.isNotEmpty((String)permission.pendingUserEmail)) continue;
                this.projectsWithPendingPermissionsByEmail.put((Object)permission.pendingUserEmail.toLowerCase(Locale.ROOT), (Object)sp.projectKey);
            }
        }
    }

    @VisibleForTesting
    synchronized void updateProjectsPendingPermissionsCache(ProjectsPermissionsChangedEvent evt) {
        if (evt.diff == null) {
            return;
        }
        Multimap<String, PermissionsWatcher.ProjectPermissionChange> pendingUserEmailChangesPerEmail = evt.diff.getPendingUserEmailChangesPerEmail();
        for (Map.Entry entry : pendingUserEmailChangesPerEmail.entries()) {
            String email = (String)entry.getKey();
            PermissionsWatcher.ProjectPermissionChange permissionChange = (PermissionsWatcher.ProjectPermissionChange)entry.getValue();
            String projectKey = permissionChange.projectKey;
            if (PermissionsService.permissionChangeAddsGrant(permissionChange)) {
                this.projectsWithPendingPermissionsByEmail.put((Object)email.toLowerCase(Locale.ROOT), (Object)projectKey);
            }
            if (!PermissionsService.permissionChangeRemovesGrant(permissionChange)) continue;
            this.projectsWithPendingPermissionsByEmail.remove((Object)email.toLowerCase(Locale.ROOT), (Object)projectKey);
        }
    }

    synchronized void updateWorkspacePendingPermissionsCache(WorkspaceInvitationChangedEvent evt) {
        switch (evt.getAction()) {
            case CREATED: {
                for (String newPendingEmail : evt.getEmails()) {
                    this.workspacesWithPendingPermissionsByEmail.put((Object)newPendingEmail.toLowerCase(Locale.ROOT), (Object)evt.getWorkspaceKey());
                }
                break;
            }
            case DELETED: {
                for (String removedEmail : evt.getEmails()) {
                    this.workspacesWithPendingPermissionsByEmail.remove((Object)removedEmail.toLowerCase(Locale.ROOT), (Object)evt.getWorkspaceKey());
                }
                break;
            }
        }
    }

    @VisibleForTesting
    void convertAllProjectsPendingPermissionsMatchingUsersIfEnabled(GeneralSettingsDAO.GeneralSettings generalSettings) {
        try {
            if (!GeneralSettingsService.arePermissionsByEmailEnabled(generalSettings)) {
                return;
            }
            logger.info((Object)"Checking if there are any projects pending permissions to convert");
            Set<String> projectsToSave = this.getObjectsWithPendingPermissionsMatchingUsers(this.projectsWithPendingPermissionsByEmail);
            this.saveProjects(projectsToSave);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to convert projects pending permissions", (Throwable)e);
        }
    }

    void convertAllWorkspacesPendingPermissionsMatchingUsersIfEnabled(GeneralSettingsDAO.GeneralSettings generalSettings) {
        try {
            if (!GeneralSettingsService.arePermissionsByEmailEnabled(generalSettings)) {
                return;
            }
            logger.info((Object)"Checking if there are any workspaces pending permissions to convert");
            Set<String> workspacesToSave = this.getObjectsWithPendingPermissionsMatchingUsers(this.workspacesWithPendingPermissionsByEmail);
            this.saveWorkspaces(workspacesToSave);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to convert workspaces pending permissions", (Throwable)e);
        }
    }

    @VisibleForTesting
    void saveProjects(Set<String> projects) {
        for (String projectKey : projects) {
            try {
                RWTransaction rwt = this.transactionService.beginWriteAsDSS();
                try {
                    SerializedProject sp = this.projectsService.getMandatory(projectKey);
                    if (sp.permissions.stream().noneMatch(permission -> permission != null && StringUtils.isNotBlank((String)permission.pendingUserEmail))) continue;
                    PermissionsWatcher pw = this.permissionsWatchersService.startProjectWatch(sp.projectKey);
                    this.projectsService.save(sp, TaggableObjectChangedEvent.ProjectEditSubtype.PERMISSIONS_ONLY);
                    pw.stop();
                    rwt.commitV("Converted pendingUserEmail permissions for project %s", new Object[]{sp.projectKey});
                }
                finally {
                    if (rwt == null) continue;
                    rwt.close();
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to convert pending email permission for project " + projectKey), (Throwable)e);
            }
        }
    }

    void saveWorkspaces(Set<String> workspaces) {
        for (String workspaceKey : workspaces) {
            try {
                RWTransaction rwt = this.transactionService.beginWriteAsDSS();
                try {
                    Workspace workspace = this.workspacesService.getMandatoryWorkspace(workspaceKey);
                    if (workspace.permissions.stream().noneMatch(permission -> permission != null && StringUtils.isNotBlank((String)permission.pendingUserEmail))) continue;
                    this.workspacesService.saveAndCheckPermissions(rwt.getUser(), workspace);
                    rwt.commitV("Converted pendingUserEmail permissions for workspace %s", new Object[]{workspaceKey});
                }
                finally {
                    if (rwt == null) continue;
                    rwt.close();
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to convert pending email permission for workspace " + workspaceKey), (Throwable)e);
            }
        }
    }

    public void saveProjectsWithMatchingPendingPermissions(UsersDAO.User user) {
        Set<String> matchingProjects = this.getAndRemoveObjectsWithMatchingPendingPermissions(this.projectsWithPendingPermissionsByEmail, user);
        this.saveProjects(matchingProjects);
    }

    public void saveWorkspacesWithMatchingPendingPermission(UsersDAO.User user) {
        Set<String> matchingWorkspaces = this.getAndRemoveObjectsWithMatchingPendingPermissions(this.workspacesWithPendingPermissionsByEmail, user);
        this.saveWorkspaces(matchingWorkspaces);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getAndRemoveObjectsWithMatchingPendingPermissions(Multimap<String, String> cache, UsersDAO.User user) {
        Set<String> objectsWithMatchingPermissions;
        PendingUserEmailPermissionUpdateService pendingUserEmailPermissionUpdateService = this;
        synchronized (pendingUserEmailPermissionUpdateService) {
            objectsWithMatchingPermissions = this.getObjectsWithMatchingPendingPermissions(cache, user);
            this.removeAllCacheEntriesForUser(cache, user);
        }
        return objectsWithMatchingPermissions;
    }

    @VisibleForTesting
    Set<String> getObjectsWithMatchingPendingPermissions(Multimap<String, String> cache, UsersDAO.User user) {
        HashSet<String> matchingPendingPermission = new HashSet<String>();
        if (StringUtils.isNotBlank((String)user.email)) {
            matchingPendingPermission.addAll(cache.get((Object)user.email.toLowerCase(Locale.ROOT)));
        }
        if (StringUtils.isNotBlank((String)user.login)) {
            matchingPendingPermission.addAll(cache.get((Object)user.login.toLowerCase(Locale.ROOT)));
        }
        return matchingPendingPermission;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Set<String> getObjectsWithPendingPermissionsMatchingUsers(Multimap<String, String> cache) throws IOException {
        HashSet<String> objectsToSave = new HashSet<String>();
        PendingUserEmailPermissionUpdateService pendingUserEmailPermissionUpdateService = this;
        synchronized (pendingUserEmailPermissionUpdateService) {
            if (cache.isEmpty()) {
                return objectsToSave;
            }
            List<? extends DkuUser> users = this.listUsersUnsafe();
            Multimap<String, String> loginsByEmail = UsersService.buildLoginsByEmailMap(users);
            for (String email : cache.keySet()) {
                Collection matchingUsers = loginsByEmail.get((Object)email);
                Collection objectsWithPendingPermissionForEmail = cache.get((Object)email);
                if (matchingUsers.size() == 1) {
                    objectsToSave.addAll(objectsWithPendingPermissionForEmail);
                    continue;
                }
                if (matchingUsers.size() <= 1) continue;
                logger.warnV("Multiple users (%s) found for email %s, not converting pending permissions for %s", new Object[]{String.join((CharSequence)", ", matchingUsers), email, JSON.json((Object)objectsWithPendingPermissionForEmail)});
            }
        }
        return objectsToSave;
    }

    private void removeAllCacheEntriesForUser(Multimap<String, String> cache, UsersDAO.User user) {
        if (StringUtils.isNotBlank((String)user.email)) {
            cache.removeAll((Object)user.email.toLowerCase(Locale.ROOT));
        }
        if (StringUtils.isNotBlank((String)user.login)) {
            cache.removeAll((Object)user.login.toLowerCase(Locale.ROOT));
        }
    }

    private List<? extends DkuUser> listUsersUnsafe() throws IOException {
        List<? extends DkuUser> users;
        try (Transaction ignored = this.transactionService.beginRead();){
            users = this.usersService.listUsersUnsafe();
        }
        catch (IOException e) {
            logger.error((Object)"Failed to list users. Pending email permissions will not be converted", (Throwable)e);
            throw e;
        }
        return users;
    }
}

