/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.scheduler.ScenarioThread;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Lists;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class FutureController
extends DIPInternalControllerBase {
    @Autowired
    private FutureService futureService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private TransactionService transactionService;
    static DKULogger logger = DKULogger.getLogger((String)"dku.futureController");

    @AuditNotNeeded
    @RequestMapping(value={"/api/intercom/futures/get-update"})
    public void getUpdateIntercom(HttpServletRequest req, HttpServletResponse resp, String futureId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        FutureResponse update = this.futureService.getUpdate(futureId);
        FutureController.writeJSON((HttpServletResponse)resp, (Object)update);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/futures/get-update"})
    public void getUpdate(HttpServletRequest req, HttpServletResponse resp, String futureId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        FutureController.writeJSON((HttpServletResponse)resp, (Object)this.futureService.getUpdate(futureId));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/futures/peek-update"})
    public void peekUpdate(HttpServletRequest req, HttpServletResponse resp, String futureId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        FutureResponse update = this.futureService.getProgress(futureId);
        if (update == null) {
            update = new FutureResponse();
            update.unknown = true;
        }
        FutureController.writeJSON((HttpServletResponse)resp, (Object)update);
    }

    @AuditedCall(value={"msgType", "future-abort", "futureId", "${futureId}"})
    @RequestMapping(value={"/api/futures/abort"})
    public void abort(HttpServletRequest req, HttpServletResponse resp, String futureId) throws IOException {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        this.futureService.abort(futureId, user);
    }

    @AuditedCall(value={"msgType", "future-list", "all", "false"})
    @RequestMapping(value={"/api/futures/list"})
    public void list(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        AuthCtx liu;
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
        }
        List<FutureResponse<?>> updates = this.buildUpdateList(this.futureService.getThreads(liu.getIdentifier()), false, true);
        FutureController.writeJSON((HttpServletResponse)resp, updates);
    }

    @AuditedCall(value={"msgType", "future-list", "all", "true"})
    @RequestMapping(value={"/api/futures/list-all"})
    public void listAll(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
        }
        List<FutureResponse<?>> updates = this.buildUpdateList(this.futureService.getAllThreads(), false, true);
        FutureController.writeJSON((HttpServletResponse)resp, updates);
    }

    @AuditedCall(value={"msgType", "future-list-scenarios", "all", "false"})
    @RequestMapping(value={"/api/futures/list-scenarios"})
    public void listScenarios(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        AuthCtx liu;
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
        }
        List<FutureResponse<?>> updates = this.buildUpdateList(this.futureService.getThreads(liu.getIdentifier()), true, false);
        FutureController.writeJSON((HttpServletResponse)resp, updates);
    }

    @AuditedCall(value={"msgType", "future-list-scenarios", "all", "true"})
    @RequestMapping(value={"/api/futures/list-all-scenarios"})
    public void listAllScenarios(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
        }
        List<FutureResponse<?>> updates = this.buildUpdateList(this.futureService.getAllThreads(), true, false);
        FutureController.writeJSON((HttpServletResponse)resp, updates);
    }

    private List<FutureResponse<?>> buildUpdateList(Map<String, FutureThreadBase<?>> threads, boolean withScenarios, boolean withNotScenarios) {
        ArrayList updates = Lists.newArrayList();
        for (Map.Entry<String, FutureThreadBase<?>> running : threads.entrySet()) {
            FutureResponse progress;
            if ((!(running.getValue() instanceof ScenarioThread) ? !withNotScenarios : !withScenarios) || (progress = this.futureService.getProgress(running.getKey())) == null) continue;
            updates.add(progress);
        }
        Collections.sort(updates, new Comparator<FutureResponse<?>>(){

            @Override
            public int compare(FutureResponse<?> r0, FutureResponse<?> r1) {
                return -((int)(r0.startTime - r1.startTime));
            }
        });
        return updates;
    }
}

