/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.integrations.IntegrationChannel;
import com.dataiku.dip.integrations.IntegrationChannelParams;
import com.dataiku.dip.integrations.im.GoogleChatIntegrationHandler;
import com.dataiku.dip.integrations.im.SlackIntegrationHandler;
import com.dataiku.dip.integrations.im.TeamsIntegrationHandler;
import com.dataiku.dip.integrations.mail.AWSMailSender;
import com.dataiku.dip.integrations.mail.MailChannelConfiguration;
import com.dataiku.dip.integrations.mail.MicrosoftGraphMailSender;
import com.dataiku.dip.integrations.mail.SMTPSender;
import com.dataiku.dip.integrations.misc.ShellScenarioIntegrationHandler;
import com.dataiku.dip.integrations.misc.TwilioScenarioIntegrationHandler;
import com.dataiku.dip.scheduler.IntegrationChannelsDAO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IntegrationChannelPermissionsService;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.JSON;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.collect.Lists;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class IntegrationChannelsController
extends DIPInternalControllerBase {
    @Autowired
    private UIAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private IntegrationChannelsDAO integrationChannelsDAO;
    @Autowired
    private IntegrationChannelPermissionsService integrationChannelPermissionsService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private PasswordEncryptionService symetricCryptoService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    private static Logger logger = Logger.getLogger((String)"dku.integrations.controller");

    @AuditedCall(value={"msgType", "integration-list"})
    @RequestMapping(value={"/api/admin/integration-channels/list"})
    public void list(HttpServletRequest req, HttpServletResponse resp, String type) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            IntegrationChannelsController.writeJSON((HttpServletResponse)resp, this.integrationChannelsDAO.list());
        }
    }

    @AuditedCall(value={"msgType", "integration-list", "integrationType", "${integrationType}"})
    @RequestMapping(value={"/api/integrations/list-available-channels-for-integration-type"})
    public void listChannelsForIntegration(HttpServletRequest req, HttpServletResponse resp, String integrationType) throws IOException, DKUSecurityException {
        ArrayList<String> acceptChannelTypes = new ArrayList<String>();
        if (integrationType.equals("mail") || integrationType.equals("mail-scenario") || integrationType.equals("mail-direct") || integrationType.equals("mail-unified-monitoring-alerting")) {
            acceptChannelTypes.add(AWSMailSender.CHANNEL_META.getType());
            acceptChannelTypes.add(MicrosoftGraphMailSender.CHANNEL_META.getType());
            acceptChannelTypes.add(SMTPSender.CHANNEL_META.getType());
        } else if (integrationType.startsWith(SlackIntegrationHandler.CHANNEL_META.getType())) {
            acceptChannelTypes.add(SlackIntegrationHandler.CHANNEL_META.getType());
        } else if (integrationType.startsWith(GoogleChatIntegrationHandler.CHANNEL_META.getType())) {
            acceptChannelTypes.add(GoogleChatIntegrationHandler.CHANNEL_META.getType());
        } else if (integrationType.startsWith(TeamsIntegrationHandler.CHANNEL_META.getType())) {
            acceptChannelTypes.add(TeamsIntegrationHandler.CHANNEL_META.getType());
        } else if (integrationType.startsWith(ShellScenarioIntegrationHandler.CHANNEL_META.getType())) {
            acceptChannelTypes.add(ShellScenarioIntegrationHandler.CHANNEL_META.getType());
        } else if (integrationType.startsWith(TwilioScenarioIntegrationHandler.CHANNEL_META.getType())) {
            acceptChannelTypes.add(TwilioScenarioIntegrationHandler.CHANNEL_META.getType());
        } else {
            acceptChannelTypes.add(integrationType);
        }
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            ArrayList<MailChannelHead> ret = new ArrayList<MailChannelHead>();
            List<IntegrationChannel> channels = this.integrationChannelsDAO.list();
            for (IntegrationChannel channel : channels) {
                ChannelHead ch;
                if (!acceptChannelTypes.contains(channel.type)) continue;
                if (integrationType.contains("mail")) {
                    ch = new MailChannelHead();
                    ch.id = channel.id;
                    ch.type = channel.type;
                    ch.usableByMe = this.integrationChannelPermissionsService.hasIntegrationChannelPrivilege(authCtx, channel, IntegrationChannelPermissionsService.IntegrationChannelPrivilegeType.USE);
                    IntegrationChannelParams configuration = channel.getConfiguration();
                    if (configuration instanceof MailChannelConfiguration) {
                        MailChannelConfiguration config = (MailChannelConfiguration)channel.getConfiguration();
                        ch.sender = config.sender;
                        ch.useCurrentUserAsSender = config.useCurrentUserAsSender;
                    }
                    ret.add((MailChannelHead)ch);
                    continue;
                }
                ch = new ChannelHead();
                ch.id = channel.id;
                ch.type = channel.type;
                ch.usableByMe = this.integrationChannelPermissionsService.hasIntegrationChannelPrivilege(authCtx, channel, IntegrationChannelPermissionsService.IntegrationChannelPrivilegeType.USE);
                ret.add((MailChannelHead)ch);
            }
            IntegrationChannelsController.writeJSON((HttpServletResponse)resp, ret);
        }
    }

    @AuditedCall(value={"msgType", "admin-integrations-save"})
    @RequestMapping(value={"/api/admin/integration-channels/save-all"})
    public void adminSaveAll(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.authService.failIfNotAdmin(req);
            List newChannels = (List)JSON.parse((String)data, (TypeToken)new TypeToken<List<IntegrationChannel>>(){});
            List<IntegrationChannel> oldChannels = this.integrationChannelsDAO.list();
            ArrayList added = Lists.newArrayList();
            ArrayList modified = Lists.newArrayList();
            ArrayList deleted = Lists.newArrayList();
            for (IntegrationChannel newChannel : newChannels) {
                IntegrationChannel oldChannel = null;
                for (IntegrationChannel channel : oldChannels) {
                    if (channel.getId() == null || !channel.getId().equals(newChannel.getId())) continue;
                    oldChannel = channel;
                }
                if (oldChannel == null) {
                    added.add(newChannel);
                    continue;
                }
                if (JSON.json((Object)newChannel).equals(JSON.json(oldChannel))) continue;
                modified.add(newChannel);
            }
            for (Object channel : added) {
                if (!StringUtils.isBlank((String)channel.getId())) continue;
                channel = channel.withId(SecretKeyGenerator.generate((int)8));
                logger.info((Object)"Generated id for new messaging channel");
            }
            HashSet<String> usedIds = new HashSet<String>();
            for (IntegrationChannel channel : newChannels) {
                if (usedIds.contains(channel.getId())) {
                    throw new IllegalArgumentException("Duplicate integration channel id: " + channel.getId());
                }
                usedIds.add(channel.getId());
            }
            if (this.generalSettingsDAO.getUnsafe().security.secureSecretKeys) {
                for (IntegrationChannel channel : newChannels) {
                    channel.getConfiguration().encryptFields(this.symetricCryptoService);
                }
            }
            this.integrationChannelsDAO.save(newChannels);
            for (IntegrationChannel oldChannel : oldChannels) {
                IntegrationChannel newChannel = null;
                for (IntegrationChannel channel : newChannels) {
                    if (channel.getId() == null || !channel.getId().equals(oldChannel.getId())) continue;
                    newChannel = channel;
                }
                if (newChannel != null) continue;
                deleted.add(oldChannel);
            }
            List<IntegrationChannel> newChannelList = this.integrationChannelsDAO.list();
            t.commit("Saved " + (added.size() + modified.size()) + " messaging channels");
            IntegrationChannelsController.writeJSON((HttpServletResponse)resp, newChannelList);
            for (IntegrationChannel add : added) {
                this.auditTrailService.generic("integration-create").with("id", add.id).with("type", add.type).emit();
            }
            for (IntegrationChannel mod : modified) {
                this.auditTrailService.generic("integration-modify").with("id", mod.id).with("type", mod.type).emit();
            }
            for (IntegrationChannel del : deleted) {
                this.auditTrailService.generic("integration-delete").with("id", del.id).with("type", del.type).emit();
            }
        }
    }

    static class MailChannelHead
    extends ChannelHead {
        String sender;
        boolean useCurrentUserAsSender;

        MailChannelHead() {
        }
    }

    @UIModel
    static class ChannelHead {
        String id;
        String type;
        boolean usableByMe;

        ChannelHead() {
        }
    }
}

