/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.datasets;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.agents.tools.AgentTool;
import com.dataiku.dip.agents.tools.AgentToolsDAO;
import com.dataiku.dip.agents.tools.datasets.DatasetRowAppendTool;
import com.dataiku.dip.agents.tools.datasets.DatasetRowLookupTool;
import com.dataiku.dip.agents.tools.inlinepython.InlinePythonTool;
import com.dataiku.dip.analysis.coreservices.AnalysisCRUDService;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.coremodel.AppHomepageTile;
import com.dataiku.dip.coremodel.AppManifest;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Partitionable;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.Zone;
import com.dataiku.dip.cuspol.CustomPolicyHooksRegistry;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.InterestsInternalDB;
import com.dataiku.dip.dao.ModelEvaluationStoresDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SQLNotebooksDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dao.SearchNotebooksDAO;
import com.dataiku.dip.dashboards.DashboardsService;
import com.dataiku.dip.dashboards.insights.InsightsService;
import com.dataiku.dip.dashboards.insights.chart.ChartInsightParams;
import com.dataiku.dip.dashboards.insights.dataquality.DataQualityInsightParams;
import com.dataiku.dip.dashboards.insights.dataset.DatasetTableInsightParams;
import com.dataiku.dip.dashboards.insights.discussions.DiscussionsInsightParams;
import com.dataiku.dip.dashboards.insights.metrics.MetricsInsightParams;
import com.dataiku.dip.dashboards.model.Dashboard;
import com.dataiku.dip.dashboards.model.DashboardPage;
import com.dataiku.dip.dashboards.model.Insight;
import com.dataiku.dip.dashboards.model.InsightParams;
import com.dataiku.dip.datacollections.AbstractDataCollectionItemRef;
import com.dataiku.dip.datacollections.DataCollectionsService;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.JobState;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.dataflow.exec.sql.SQLQueryRecipeMeta;
import com.dataiku.dip.dataflow.exec.sql.SQLScriptRecipeMeta;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowImplicitRecipe;
import com.dataiku.dip.dataflow.graph.FlowLabelingTask;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.datalineage.RecipeManualLineageConfig;
import com.dataiku.dip.dataquality.DataQualityRule;
import com.dataiku.dip.dataquality.rules.CompareMetricsRule;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.datasets.dynamic.VariablesExpansionLoopConfig;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.inline.InlineDatasetHandler;
import com.dataiku.dip.datasets.jobsdb.JobsdbDatasetParams;
import com.dataiku.dip.discussions.DiscussionsService;
import com.dataiku.dip.eda.worksheets.WorksheetsService;
import com.dataiku.dip.eda.worksheets.models.Worksheet;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.integrations.IntegrationParams;
import com.dataiku.dip.integrations.misc.DatasetScenarioIntegrationHandler;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.labeling.LabelingTasksCRUDService;
import com.dataiku.dip.labeling.LabelingTasksDAO;
import com.dataiku.dip.managedfolder.KernelsManagedFolderService;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.projects.apps.AppsService;
import com.dataiku.dip.projects.importexport.model.ProjectExportOptions;
import com.dataiku.dip.recipes.ParamsWithVariablesExpansionLoopConfig;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.code.shell.ShellScriptRecipeMeta;
import com.dataiku.dip.recipes.shaker.ShakerRecipeMeta;
import com.dataiku.dip.reports.Report;
import com.dataiku.dip.reports.ReportsService;
import com.dataiku.dip.requestcenter.RequestsInternalDB;
import com.dataiku.dip.scheduler.reports.ScenarioReporter;
import com.dataiku.dip.scheduler.scenarios.CustomPythonScenarioRunner;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.scenarios.StepBasedScenarioRunner;
import com.dataiku.dip.scheduler.steps.CustomPythonStepRunner;
import com.dataiku.dip.scheduler.steps.FlowComputableSpecification;
import com.dataiku.dip.scheduler.steps.FlowTestStepRunner;
import com.dataiku.dip.scheduler.steps.SchemaPropagationStepRunner;
import com.dataiku.dip.scheduler.steps.SendReportStepRunner;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepParamsWithComputables;
import com.dataiku.dip.scheduler.triggers.DatasetModifiedTriggerRunner;
import com.dataiku.dip.scheduler.triggers.Trigger;
import com.dataiku.dip.searchnotebooks.SearchNotebook;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetDeletionService;
import com.dataiku.dip.server.datasets.FileUploadService;
import com.dataiku.dip.server.datasets.renaming.code.CodeRenamer;
import com.dataiku.dip.server.datasets.renaming.code.RegexCodeRenamer;
import com.dataiku.dip.server.datasets.renaming.code.python.PythonCodeRenamer;
import com.dataiku.dip.server.datasets.renaming.code.r.RCodeRenamer;
import com.dataiku.dip.server.datasets.renaming.code.sql.SqlCodeRenamer;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.recipes.RecipeSaveService;
import com.dataiku.dip.server.services.DataLineageService;
import com.dataiku.dip.server.services.DatasetNotebookService;
import com.dataiku.dip.server.services.ExploresService;
import com.dataiku.dip.server.services.ExposedObjectsService;
import com.dataiku.dip.server.services.FlowZonesService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.JupyterService;
import com.dataiku.dip.server.services.JupyterUtils;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.dataiku.dip.server.services.SQLNotebooksService;
import com.dataiku.dip.server.services.ScenariosService;
import com.dataiku.dip.server.services.TaggableObjectsDeletionService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.dataquality.DataQualityService;
import com.dataiku.dip.shaker.model.DatasetExploreSettings;
import com.dataiku.dip.shaker.model.GroupScriptStep;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.processors.geo.NearestNeighbourGeoJoiner;
import com.dataiku.dip.shaker.processors.join.MemoryEquiJoiner;
import com.dataiku.dip.shaker.processors.transform.FindReplace;
import com.dataiku.dip.spark.InputDatasetsReadParams;
import com.dataiku.dip.sqlnotebooks.SQLNotebook;
import com.dataiku.dip.sqlnotebooks.SQLNotebookQuery;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.NativeFS;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppHandler;
import com.dataiku.dip.webapps.WebAppsService;
import com.dataiku.dip.webapps.bokeh.BokehWebAppMeta;
import com.dataiku.dip.webapps.dash.DashWebAppMeta;
import com.dataiku.dip.webapps.shiny.ShinyWebAppMeta;
import com.dataiku.dip.webapps.standard.StandardWebAppMeta;
import com.dataiku.dip.webapps.streamlit.StreamlitWebAppMeta;
import com.dataiku.dip.wikis.Article;
import com.dataiku.dip.wikis.WikisService;
import com.dataiku.dip.workspaces.WorkspacesService;
import com.dataiku.dss.shadelib.com.google.common.collect.Streams;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DatasetRenameService {
    private static final String DATASET_REFERENCE_PATTERN = "\\[([^\\]]*)\\]\\(dataset:(%s)\\)";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.server.datasets");
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private LabelingTasksDAO labelingTasksDAO;
    @Autowired
    private RecipeSaveService recipeSaveService;
    @Autowired
    private LabelingTasksCRUDService labelingTasksCRUDService;
    @Autowired
    private ExploresService exploresService;
    @Autowired
    private AnalysisCRUDService analysisCRUDService;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private AgentToolsDAO agentToolsDAO;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private FlowGraphService graphService;
    @Autowired
    private InsightsService insightsService;
    @Autowired
    private DashboardsService dashboardsService;
    @Autowired
    private ScenariosService scenariosService;
    @Autowired
    private WorksheetsService worksheetsService;
    @Autowired
    private FlowZonesService flowZonesService;
    @Autowired
    private WebAppsService webAppsService;
    @Autowired
    private ExposedObjectsService exposedObjectsService;
    @Autowired
    private WorkspacesService workspacesService;
    @Autowired
    private WikisService wikisService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private JupyterService jupyterService;
    @Autowired
    private SQLNotebooksService sqlNotebooksService;
    @Autowired
    private SQLNotebooksDAO sqlNotebooksDAO;
    @Autowired
    private SearchNotebooksDAO searchNotebooksDAO;
    @Autowired
    private DatasetDeletionService datasetDeletionService;
    @Autowired
    private RequestsInternalDB requestsInternalDB;
    @Autowired
    private InterestsInternalDB interestsInternalDB;
    @Autowired
    private DiscussionsService discussionsService;
    @Autowired
    private ReportsService reportsService;
    @Autowired
    private DataCollectionsService dataCollectionService;
    @Autowired
    private DatasetNotebookService datasetNotebookService;
    @Autowired
    private AppsService appsService;
    @Autowired
    private CustomPolicyHooksRegistry customPolicyHooksRegistry;
    @Autowired
    private DataQualityService dataQualityService;
    @Autowired
    private DataLineageService dataLineageService;
    private static final List<String> BASIC_PROBE_TYPES = Arrays.asList("basic", "records", "partitioning", "reporting");

    private static Pattern compileDatasetRefPattern(DatasetLocUtils.DatasetLoc oldDataset, String project) {
        String oldDatasetNamePattern = project.equals(oldDataset.getProjectKey()) ? String.format("%s|%s", oldDataset.getName(), oldDataset.getFullName()) : oldDataset.getFullName();
        return Pattern.compile(String.format(DATASET_REFERENCE_PATTERN, oldDatasetNamePattern));
    }

    private static boolean attachmentIsRefToDataset(Article.ArticleAttachment attachment, DatasetLocUtils.DatasetLoc dataset, String project) {
        return attachment.taggableType == ITaggingService.TaggableType.DATASET && attachment.smartId != null && attachment.smartId.equals(dataset.getSmartName(project));
    }

    public InfoMessage.InfoMessages performRenaming(AuthCtx authCtx, Dataset dataset, String newName, RenamingImpact impact) throws Exception {
        File datasetDir;
        DatasetUtils.checkName(newName);
        String oldName = dataset.getName();
        DatasetLocUtils.DatasetLoc oldDatasetLoc = dataset.getLoc();
        DatasetLocUtils.DatasetLoc newDatasetLoc = new DatasetLocUtils.DatasetLoc(dataset.getProjectKey(), newName);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.customPolicyHooksRegistry.onPreDatasetRename(authCtx, dataset.serialize(), newName);
            if (dataset.getType().equals(InlineDatasetHandler.META.getType())) {
                try (InlineDatasetHandler dh = (InlineDatasetHandler)DatasetHandlerFactory.build(authCtx, dataset);){
                    dh.rename(newName);
                }
            }
            this.performRenamingForLabelingTasks(oldDatasetLoc, newDatasetLoc, impact.modifiedLabelingTasks);
            this.performRenamingForNotebooks(oldDatasetLoc, newDatasetLoc, impact, authCtx);
            this.performRenamingForWebApps(oldDatasetLoc, newDatasetLoc, impact.modifiedWebApps, authCtx);
            this.performRenamingForExplore(oldDatasetLoc, newDatasetLoc);
            this.performRenamingForInsights(oldDatasetLoc, newDatasetLoc);
            this.performRenamingForDashboards(oldDatasetLoc, newDatasetLoc, authCtx);
            this.performRenamingForWorksheets(newDatasetLoc, impact, authCtx);
            this.performRenamingForAnalysis(oldDatasetLoc, newDatasetLoc, impact);
            this.performRenamingForAgents(oldDatasetLoc, newDatasetLoc, impact, authCtx);
            this.performRenamingForAgentTools(oldDatasetLoc, newDatasetLoc, impact, authCtx);
            this.performRenamingForScenarios(oldDatasetLoc, newDatasetLoc, impact, authCtx);
            this.performRenamingForFlowZone(oldDatasetLoc, newName, impact);
            this.performRenamingForWorkspaces(oldDatasetLoc, newName);
            this.performRenamingForDashboardAuthorizations(oldDatasetLoc, newName, impact.modifiedProjects);
            this.performRenamingForWikiArticle(oldDatasetLoc, newDatasetLoc, impact.modifiedWikiArticle);
            this.performRenamingForReports(oldDatasetLoc, newDatasetLoc, impact.modifiedReports, authCtx);
            this.performRenamingForApp(oldDatasetLoc, newDatasetLoc, impact);
            this.performRenamingForDataCollections(oldDatasetLoc, newDatasetLoc, impact.modifiedDataCollections);
            this.performRenamingForDataQualityRules(oldDatasetLoc, newDatasetLoc, impact.modifiedDqRules);
            this.exposedObjectsService.renameObjectAuthorizations(dataset.getProjectKey(), ITaggingService.TaggableType.DATASET, oldName, newName);
            this.datasetsDAO.rename(dataset.getProjectKey(), oldName, newName);
            this.performRenamingForRecipes(oldDatasetLoc, newDatasetLoc, impact, authCtx);
            this.performRenamingForDatasets(oldDatasetLoc, newDatasetLoc, impact);
            this.performRenamingForManualLineage(oldDatasetLoc, newDatasetLoc, impact);
            t.commit("Renamed dataset " + oldDatasetLoc.getFullName() + " to " + newDatasetLoc.getFullName());
        }
        InfoMessage.InfoMessages infoMessages = new InfoMessage.InfoMessages();
        if (dataset.getType().equals(BuiltinFSDatasets.UPLOADED_FILES_META.getType()) && (datasetDir = FileUploadService.datasetOrUploadBoxDir(dataset)).getName().equals(oldName) && !datasetDir.renameTo(DKUFileUtils.getWithin((File)new File(datasetDir.getParent()), (String[])new String[]{newName}))) {
            logger.error((Object)("Failed to rename directory " + String.valueOf(datasetDir) + " into " + newName + " while renaming dataset " + oldDatasetLoc.getFullName()));
            infoMessages.addMessage(InfoMessage.warning((String)"Error renaming directory containing dataset data"));
        }
        try {
            this.performRenamingForDatasetResources(oldDatasetLoc, newDatasetLoc);
        }
        catch (IOException e) {
            logger.error((Object)"Failed to rename dataset resources", (Throwable)e);
            infoMessages.addMessage(InfoMessage.warning((String)"Failed to rename dataset resources", (String)e.getMessage()));
        }
        try {
            this.requestsInternalDB.updateRequestsOnDatasetRename(oldDatasetLoc, newDatasetLoc);
        }
        catch (CodedSQLException e) {
            logger.error((Object)"Failed to rename dataset in request center", (Throwable)e);
            infoMessages.addMessage(InfoMessage.warning((String)"Failed to rename dataset in request center", (String)e.getMessage()));
        }
        try {
            this.interestsInternalDB.changeObjectId(ITaggingService.TaggableType.DATASET, oldDatasetLoc.getProjectKey(), oldName, newName);
        }
        catch (CodedSQLException e) {
            logger.error((Object)("Unable to update the interests internal DB while renaming the dataset " + oldDatasetLoc.getFullName()), (Throwable)e);
            infoMessages.addMessage(InfoMessage.warning((String)"Failed to update dataset interests", (String)e.getMessage()));
        }
        try {
            this.discussionsService.handleTaggableObjectIdChange_NT(ITaggingService.TaggableType.DATASET, oldDatasetLoc.getProjectKey(), oldName, newName);
        }
        catch (CodedSQLException e) {
            logger.error((Object)("Unable to update the discussion internal DB while renaming the dataset " + oldDatasetLoc.getFullName()), (Throwable)e);
            infoMessages.addMessage(InfoMessage.warning((String)"Failed to update dataset discussions", (String)e.getMessage()));
        }
        this.datasetDeletionService.clearCacheAndStatus_NT(dataset);
        this.graphService.invalidateCache();
        JsonObject details = new JsonObject();
        details.addProperty("oldName", oldName);
        details.addProperty("newName", newName);
        this.pubSub.publish(new TaggableObjectChangedEvent(ITaggingService.TaggableType.DATASET, dataset.getProjectKey(), oldName, authCtx, TaggableObjectChangedEvent.ActionType.DATASET_RENAME, newName).withDetails(details));
        return infoMessages;
    }

    private void performRenamingForDataQualityRules(DatasetLocUtils.DatasetLoc oldDatasetLoc, DatasetLocUtils.DatasetLoc newDatasetLoc, List<TaggableObjectsDeletionService.ImpactedDataQualityRule> modifiedDqRules) throws IOException {
        block0: for (TaggableObjectsDeletionService.ImpactedDataQualityRule modifiedDqRule : modifiedDqRules) {
            SerializedDataset dqDataset = (SerializedDataset)this.datasetsDAO.getOrNull(modifiedDqRule.projectKey, modifiedDqRule.datasetName);
            if (dqDataset == null) continue;
            for (DataQualityRule rule : dqDataset.getDataQualityRuleSet().getRules()) {
                if (!Objects.equals(modifiedDqRule.ruleId, rule.getId()) || !(rule instanceof CompareMetricsRule)) continue;
                CompareMetricsRule cmr = (CompareMetricsRule)rule;
                if (!Objects.equals(oldDatasetLoc.getName(), cmr.datasetBName)) continue block0;
                cmr.datasetBName = newDatasetLoc.getName();
                this.datasetsDAO.save(dqDataset);
                continue block0;
            }
        }
    }

    private void performRenamingForDatasetResources(DatasetLocUtils.DatasetLoc oldDatasetLoc, DatasetLocUtils.DatasetLoc newDatasetLoc) throws IOException {
        NativeFS dirFS = NativeFS.from((File)DKUApp.getBaseFolderF()).build();
        RelFile src = new RelFile(new String[]{"dataset_resources", oldDatasetLoc.getProjectKey(), oldDatasetLoc.getName()});
        RelFile tgt = new RelFile(new String[]{"dataset_resources", newDatasetLoc.getProjectKey(), newDatasetLoc.getName()});
        if (dirFS.isDirectory(src)) {
            dirFS.moveFile(src, tgt);
        }
    }

    private void performRenamingForDataCollections(DatasetLocUtils.DatasetLoc oldDatasetLoc, DatasetLocUtils.DatasetLoc newDatasetLoc, Set<String> modifiedDataCollections) throws IOException {
        for (String dataCollectionId : modifiedDataCollections) {
            this.dataCollectionService.renameDatasetInDataCollection(dataCollectionId, new AbstractDataCollectionItemRef.DatasetRef(oldDatasetLoc), new AbstractDataCollectionItemRef.DatasetRef(newDatasetLoc));
        }
    }

    private void performRenamingForApp(DatasetLocUtils.DatasetLoc oldDatasetLoc, DatasetLocUtils.DatasetLoc newDatasetLoc, RenamingImpact impact) throws Exception {
        if (impact.modifiedAppManifest) {
            SerializedProject sp = this.projectsService.getMandatoryUnsafe(oldDatasetLoc.getProjectKey());
            AppManifest manifest = switch (sp.projectAppType) {
                case SerializedProject.ProjectAppType.APP_INSTANCE -> this.appsService.getAppInstanceManifestForProject_T(DSSAuthCtx.newNone(), sp.projectKey);
                case SerializedProject.ProjectAppType.APP_TEMPLATE -> this.appsService.getAppTemplateManifestForProject_T(sp.projectKey);
                default -> null;
            };
            if (manifest != null) {
                for (AppManifest.AppHomepageSection section : manifest.homepageSections) {
                    for (AppHomepageTile tile : section.tiles) {
                        if (tile instanceof AppHomepageTile.EditAnyDatasetTile) {
                            AppHomepageTile.EditAnyDatasetTile datasetTile = (AppHomepageTile.EditAnyDatasetTile)tile;
                            if (!oldDatasetLoc.getName().equals(datasetTile.datasetName)) continue;
                            datasetTile.datasetName = newDatasetLoc.getName();
                            continue;
                        }
                        if (tile instanceof AppHomepageTile.EditInlineDatasetTile) {
                            AppHomepageTile.EditInlineDatasetTile datasetTile = (AppHomepageTile.EditInlineDatasetTile)tile;
                            if (!oldDatasetLoc.getName().equals(datasetTile.datasetName)) continue;
                            datasetTile.datasetName = newDatasetLoc.getName();
                            continue;
                        }
                        if (tile instanceof AppHomepageTile.EditFSDatasetTile) {
                            AppHomepageTile.EditFSDatasetTile datasetTile = (AppHomepageTile.EditFSDatasetTile)tile;
                            if (!oldDatasetLoc.getName().equals(datasetTile.datasetName)) continue;
                            datasetTile.datasetName = newDatasetLoc.getName();
                            continue;
                        }
                        if (tile instanceof AppHomepageTile.EditSQLDatasetTile) {
                            AppHomepageTile.EditSQLDatasetTile datasetTile = (AppHomepageTile.EditSQLDatasetTile)tile;
                            if (!oldDatasetLoc.getName().equals(datasetTile.datasetName)) continue;
                            datasetTile.datasetName = newDatasetLoc.getName();
                            continue;
                        }
                        if (tile instanceof AppHomepageTile.PropagateSchemaTile) {
                            AppHomepageTile.PropagateSchemaTile datasetTile = (AppHomepageTile.PropagateSchemaTile)tile;
                            if (!oldDatasetLoc.getName().equals(datasetTile.datasetName)) continue;
                            datasetTile.datasetName = newDatasetLoc.getName();
                            continue;
                        }
                        if (tile instanceof AppHomepageTile.UploadDatasetSetFileTile) {
                            AppHomepageTile.UploadDatasetSetFileTile datasetTile = (AppHomepageTile.UploadDatasetSetFileTile)tile;
                            if (!oldDatasetLoc.getName().equals(datasetTile.datasetName)) continue;
                            datasetTile.datasetName = newDatasetLoc.getName();
                            continue;
                        }
                        if (!(tile instanceof AppHomepageTile.DownloadDatasetTile)) continue;
                        AppHomepageTile.DownloadDatasetTile datasetTile = (AppHomepageTile.DownloadDatasetTile)tile;
                        if (!oldDatasetLoc.getName().equals(datasetTile.datasetName)) continue;
                        datasetTile.datasetName = newDatasetLoc.getName();
                    }
                }
                for (ProjectExportOptions.IncludedDatasetData dataset : manifest.projectExportManifest.includedDatasetsData) {
                    if (!oldDatasetLoc.getName().equals(dataset.name)) continue;
                    dataset.name = newDatasetLoc.getName();
                }
                if (manifest.useAsRecipeSettings != null) {
                    Stream.concat(manifest.useAsRecipeSettings.inputRoles.stream(), manifest.useAsRecipeSettings.outputRoles.stream()).forEach(role -> {
                        if (oldDatasetLoc.getName().equals(role.objectId)) {
                            role.objectId = newDatasetLoc.getName();
                        }
                    });
                }
                this.appsService.saveAppTemplateManifestForProject(oldDatasetLoc.getProjectKey(), manifest, true);
            }
            for (TaggableObjectsDeletionService.ImpactedRecipe recipe : impact.modifiedAppAsRecipes) {
                SerializedRecipe.OutputRole outputRole;
                SerializedRecipe sr = (SerializedRecipe)this.recipesDAO.getOrNull(recipe.projectKey, recipe.name);
                if (sr == null) continue;
                SerializedRecipe.InputRole inputRole = sr.getInputsUnsafe().remove(oldDatasetLoc.getName());
                if (inputRole != null) {
                    sr.getInputsUnsafe().put(newDatasetLoc.getName(), inputRole);
                }
                if ((outputRole = sr.getOutputsUnsafe().remove(oldDatasetLoc.getName())) != null) {
                    sr.getOutputsUnsafe().put(newDatasetLoc.getName(), outputRole);
                }
                String payload = this.recipesDAO.getPayloadOrNull(recipe.projectKey, recipe.name);
                this.recipeSaveService.save(recipe.projectKey, sr, payload);
            }
        }
    }

    private void performRenamingForExplore(DatasetLocUtils.DatasetLoc oldDataset, DatasetLocUtils.DatasetLoc newDataset) throws Exception {
        DatasetExploreSettings beforeExplore = this.exploresService.get(oldDataset.getProjectKey(), oldDataset.getName());
        this.exploresService.delete(oldDataset.getProjectKey(), oldDataset.getName());
        this.exploresService.save(oldDataset.getProjectKey(), newDataset.getName(), beforeExplore);
    }

    private void performRenamingForWorksheets(DatasetLocUtils.DatasetLoc newDataset, RenamingImpact impact, AuthCtx authCtx) throws Exception {
        for (TaggableObjectsDeletionService.ImpactedWorksheet worksheet : impact.modifiedWorksheets) {
            Worksheet params = this.worksheetsService.getWorksheetOrNull(worksheet.projectKey, worksheet.id);
            if (params == null) continue;
            params.dataSpec.inputDatasetSmartName = newDataset.getSmartName(worksheet.projectKey);
            this.worksheetsService.saveWorksheet(authCtx, params);
        }
    }

    private void performRenamingForAnalysis(DatasetLocUtils.DatasetLoc oldName, DatasetLocUtils.DatasetLoc newName, RenamingImpact impact) throws IOException, UnauthorizedException, CodedException {
        AnalysisCoreParams params;
        for (TaggableObjectsDeletionService.ImpactedAnalysis analysis : impact.modifiedAnalyses) {
            if (!this.analysisCRUDService.exists(analysis.projectKey, analysis.id)) continue;
            params = this.analysisCRUDService.getCoreMandatory(analysis.projectKey, analysis.id);
            params.inputDatasetSmartName = newName.getSmartName(analysis.projectKey);
            this.analysisCRUDService.saveCore(params, false);
        }
        for (TaggableObjectsDeletionService.ImpactedAnalysis analysis : impact.modifiedAnalysesWithJoin) {
            if (!this.analysisCRUDService.exists(analysis.projectKey, analysis.id)) continue;
            params = this.analysisCRUDService.getCoreMandatory(analysis.projectKey, analysis.id);
            this.checkRenamingOnShakerScript(oldName, newName, analysis.projectKey, params.script, true);
            this.analysisCRUDService.saveCore(params, false);
        }
    }

    private void performRenamingForAgents(DatasetLocUtils.DatasetLoc oldLoc, DatasetLocUtils.DatasetLoc newLoc, RenamingImpact impact, AuthCtx authCtx) throws IOException {
        TransactionContext.assertAttachedRWTransaction();
        for (ImpactedAgent ia : impact.modifiedAgents) {
            SavedModel sm = (SavedModel)this.savedModelsDAO.getOrNull(ia.projectKey(), ia.agentId());
            if (sm == null) continue;
            this.performRenamingForAgent(oldLoc, newLoc, sm, authCtx);
            this.savedModelsDAO.save(sm);
        }
    }

    private void performRenamingForAgent(DatasetLocUtils.DatasetLoc oldLoc, DatasetLocUtils.DatasetLoc newLoc, SavedModel sm, AuthCtx authCtx) {
        for (SavedModel.SavedModelInlineVersion smiv : sm.inlineVersions) {
            PythonCodeRenamer renamer;
            SavedModel.AgentSettings settings = sm.getAgentSettings(smiv);
            if (!(settings instanceof SavedModel.PythonAgentSettings)) continue;
            SavedModel.PythonAgentSettings codeAgentSettings = (SavedModel.PythonAgentSettings)settings;
            for (SavedModel.AgentDependency dep : codeAgentSettings.dependencies) {
                AnyLoc loc;
                if (!Objects.equals((Object)ITaggingService.TaggableType.DATASET, (Object)dep.type) || !Objects.equals(oldLoc, loc = AnyLoc.resolveSmart(sm.getProjectKey(), dep.ref))) continue;
                dep.ref = newLoc.getSmartName(sm.getProjectKey());
            }
            if (smiv.code == null || !(renamer = new PythonCodeRenamer(sm.getProjectKey(), oldLoc, newLoc, authCtx.getAssociatedDSSUser(), new Date())).requiresRenaming(smiv.code)) continue;
            smiv.code = renamer.updatePayload(smiv.code);
        }
    }

    private void performRenamingForAgentTools(DatasetLocUtils.DatasetLoc oldLoc, DatasetLocUtils.DatasetLoc newLoc, RenamingImpact impact, AuthCtx authCtx) throws IOException {
        TransactionContext.assertAttachedRWTransaction();
        for (ImpactedAgentTool iat : impact.modifiedAgentTools) {
            AgentTool tool = (AgentTool)this.agentToolsDAO.getOrNull(iat.projectKey(), iat.toolId());
            if (tool == null) continue;
            this.performRenamingForAgentTool(oldLoc, newLoc, tool, authCtx);
            this.agentToolsDAO.save(tool);
        }
    }

    private void performRenamingForAgentTool(DatasetLocUtils.DatasetLoc oldLoc, DatasetLocUtils.DatasetLoc newLoc, AgentTool tool, AuthCtx authCtx) {
        if (Objects.equals(DatasetRowAppendTool.META.getType(), tool.type)) {
            DatasetRowAppendTool.Params params = tool.getParamsCopyAs(DatasetRowAppendTool.Params.class);
            AnyLoc loc = AnyLoc.resolveSmart(tool.getProjectKey(), params.datasetRef);
            if (Objects.equals(oldLoc, loc)) {
                params.datasetRef = newLoc.getSmartName(tool.getProjectKey());
                tool.setParams(params);
            }
        } else if (Objects.equals(DatasetRowLookupTool.META.getType(), tool.type)) {
            DatasetRowLookupTool.Params params = tool.getParamsCopyAs(DatasetRowLookupTool.Params.class);
            AnyLoc loc = AnyLoc.resolveSmart(tool.getProjectKey(), params.datasetRef);
            if (Objects.equals(oldLoc, loc)) {
                params.datasetRef = newLoc.getSmartName(tool.getProjectKey());
                tool.setParams(params);
            }
        } else if (Objects.equals(InlinePythonTool.META.getType(), tool.type)) {
            PythonCodeRenamer renamer;
            InlinePythonTool.Params params = tool.getParamsCopyAs(InlinePythonTool.Params.class);
            for (SavedModel.AgentDependency dep : params.dependencies) {
                AnyLoc loc;
                if (!Objects.equals((Object)ITaggingService.TaggableType.DATASET, (Object)dep.type) || !Objects.equals(oldLoc, loc = AnyLoc.resolveSmart(tool.getProjectKey(), dep.ref))) continue;
                dep.ref = newLoc.getSmartName(tool.getProjectKey());
            }
            if (params.code != null && (renamer = new PythonCodeRenamer(tool.getProjectKey(), oldLoc, newLoc, authCtx.getAssociatedDSSUser(), new Date())).requiresRenaming(params.code)) {
                params.code = renamer.updatePayload(params.code);
            }
            tool.setParams(params);
        }
    }

    private void performRenamingForScenarios(DatasetLocUtils.DatasetLoc oldDataset, DatasetLocUtils.DatasetLoc newDataset, RenamingImpact impact, AuthCtx authCtx) throws Exception {
        List allImpactedScenarios = Streams.concat((Stream[])new Stream[]{impact.modifiedScenarios.stream(), impact.bestEffortAutomaticallyChangedScenarios.stream()}).toList();
        for (TaggableObjectsDeletionService.ImpactedScenario impactedScenario : allImpactedScenarios) {
            Scenario scenario = this.scenariosService.getOrNull(impactedScenario.projectKey, impactedScenario.id);
            if (scenario == null) continue;
            if (CustomPythonScenarioRunner.META.getType().equals(scenario.getType())) {
                String payload = this.scenariosService.getPayload(scenario.getProjectKey(), scenario.getId(), "py");
                PythonCodeRenamer renamer = new PythonCodeRenamer(scenario.projectKey, oldDataset, newDataset, authCtx.getAssociatedDSSUser(), new Date());
                payload = renamer.updatePayload(payload);
                this.scenariosService.savePayload(scenario.getProjectKey(), scenario.getId(), "py", payload);
            } else if (StepBasedScenarioRunner.META.getType().equals(scenario.getType())) {
                StepBasedScenarioRunner.StepBasedScenarioParams params = scenario.getParamsAs(StepBasedScenarioRunner.StepBasedScenarioParams.class);
                for (Step step : params.getSteps()) {
                    Object renamer;
                    Object stepParams;
                    if (step.params instanceof StepParamsWithComputables) {
                        stepParams = (StepParamsWithComputables)((Object)step.getParams());
                        String oldDatasetSmartName = oldDataset.getSmartName(scenario.projectKey);
                        String newDatasetSmartName = newDataset.getSmartName(scenario.projectKey);
                        for (FlowComputableSpecification item : stepParams.getComputablesSpec()) {
                            String itemSmartName;
                            if (!item.type.equals((Object)FlowComputable.FCType.DATASET) || !oldDatasetSmartName.equals(itemSmartName = item.getLoc(scenario.projectKey).getSmartName(scenario.projectKey))) continue;
                            item.itemId = newDataset.getName();
                        }
                        if (!(step.params instanceof FlowTestStepRunner.FlowTestStepParams)) continue;
                        FlowTestStepRunner.FlowTestStepParams flowTestParams = step.getParamsAs(FlowTestStepRunner.FlowTestStepParams.class);
                        flowTestParams.getSwaps().forEach(swap -> {
                            if (Objects.equals(swap.sourceSmartName, oldDatasetSmartName)) {
                                swap.sourceSmartName = newDatasetSmartName;
                            }
                            if (Objects.equals(swap.targetSmartName, oldDatasetSmartName)) {
                                swap.targetSmartName = newDatasetSmartName;
                            }
                        });
                        flowTestParams.getCompares().forEach(swap -> {
                            if (Objects.equals(swap.expectedSmartName, oldDatasetSmartName)) {
                                swap.expectedSmartName = newDatasetSmartName;
                            }
                            if (Objects.equals(swap.resultSmartName, oldDatasetSmartName)) {
                                swap.resultSmartName = newDatasetSmartName;
                            }
                        });
                        continue;
                    }
                    if (step.params instanceof SchemaPropagationStepRunner.SchemaPropagationStepParams) {
                        stepParams = (SchemaPropagationStepRunner.SchemaPropagationStepParams)step.getParams();
                        if (!oldDataset.getName().equals(((SchemaPropagationStepRunner.SchemaPropagationStepParams)stepParams).options.datasetName)) continue;
                        ((SchemaPropagationStepRunner.SchemaPropagationStepParams)stepParams).options.datasetName = newDataset.getName();
                        continue;
                    }
                    stepParams = step.params;
                    if (stepParams instanceof CustomPythonStepRunner.CustomPythonStepParams) {
                        CustomPythonStepRunner.CustomPythonStepParams stepParams2 = (CustomPythonStepRunner.CustomPythonStepParams)stepParams;
                        renamer = new PythonCodeRenamer(scenario.projectKey, oldDataset, newDataset, authCtx.getAssociatedDSSUser(), new Date());
                        stepParams2.script = ((RegexCodeRenamer)renamer).updatePayload(stepParams2.script);
                        continue;
                    }
                    renamer = step.params;
                    if (!(renamer instanceof SendReportStepRunner.SendReportStepParams)) continue;
                    SendReportStepRunner.SendReportStepParams stepParams3 = (SendReportStepRunner.SendReportStepParams)renamer;
                    IntegrationParams integrationParams = stepParams3.messaging.getConfiguration();
                    if (!(integrationParams instanceof DatasetScenarioIntegrationHandler.DatasetMessagingConfiguration)) continue;
                    DatasetScenarioIntegrationHandler.DatasetMessagingConfiguration configuration = (DatasetScenarioIntegrationHandler.DatasetMessagingConfiguration)integrationParams;
                    if (!oldDataset.getProjectKey().equals(configuration.projectKey) || !oldDataset.getName().equals(configuration.datasetName)) continue;
                    configuration.projectKey = newDataset.getProjectKey();
                    configuration.datasetName = newDataset.getName();
                }
            }
            for (Trigger trigger : scenario.triggers) {
                if (!DatasetModifiedTriggerRunner.META.getType().equals(trigger.getType())) continue;
                DatasetModifiedTriggerRunner.DatasetModifiedTriggerParams params = trigger.getParamsAs(DatasetModifiedTriggerRunner.DatasetModifiedTriggerParams.class);
                for (FlowComputableSpecification watch : params.watches) {
                    if ((watch.projectKey != null || !oldDataset.getProjectKey().equals(scenario.getProjectKey())) && !oldDataset.getProjectKey().equals(watch.projectKey) || !oldDataset.getName().equals(watch.itemId)) continue;
                    watch.itemId = newDataset.getName();
                }
            }
            for (ScenarioReporter reporter : scenario.getReporters()) {
                if (!(reporter.getMessaging().getConfiguration() instanceof DatasetScenarioIntegrationHandler.DatasetMessagingConfiguration)) continue;
                DatasetScenarioIntegrationHandler.DatasetMessagingConfiguration configuration = reporter.getMessaging().getConfigurationAs(DatasetScenarioIntegrationHandler.DatasetMessagingConfiguration.class);
                if (!oldDataset.getProjectKey().equals(configuration.projectKey) || !oldDataset.getName().equals(configuration.datasetName)) continue;
                configuration.projectKey = newDataset.getProjectKey();
                configuration.datasetName = newDataset.getName();
            }
            this.scenariosService.save(scenario.getProjectKey(), scenario);
        }
    }

    private void performRenamingForFlowZone(DatasetLocUtils.DatasetLoc oldDataset, String newName, RenamingImpact impact) throws IOException {
        for (TaggableObjectsDeletionService.ImpactedZone impactedZone : impact.modifiedZones) {
            SmartObjectRef oldRef = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.DATASET, oldDataset.getSmartName(impactedZone.projectKey));
            SmartObjectRef newRef = SmartObjectRef.fromResolved(ITaggingService.TaggableType.DATASET, oldRef.projectKey, newName, impactedZone.projectKey);
            if (impactedZone.isItems) {
                this.flowZonesService.detachObjectFromZone(impactedZone.projectKey, oldRef);
                this.flowZonesService.attachObjectToZone(impactedZone.zoneId, impactedZone.projectKey, newRef, false);
                continue;
            }
            this.flowZonesService.unshareObjectFromZone(impactedZone.projectKey, impactedZone.zoneId, oldRef);
            this.flowZonesService.shareObjectToZone(impactedZone.zoneId, impactedZone.projectKey, newRef);
        }
    }

    private void performRenamingForWorkspaces(DatasetLocUtils.DatasetLoc oldDataset, String newName) throws IOException {
        for (String workspaceKey : this.workspacesService.listAllWorkspacesContainingObject(oldDataset.getProjectKey(), ITaggingService.TaggableType.DATASET, oldDataset.getName())) {
            this.workspacesService.renameObjects(workspaceKey, oldDataset.getProjectKey(), oldDataset.getName(), newName);
        }
    }

    private void performRenamingForDashboardAuthorizations(DatasetLocUtils.DatasetLoc oldDataset, String newName, Set<String> projects) throws Exception {
        for (String targetProject : projects) {
            this.exposedObjectsService.renameObjectDashboardAuthorizations(targetProject, oldDataset.getProjectKey().equals(targetProject) ? null : oldDataset.getProjectKey(), ITaggingService.TaggableType.DATASET, oldDataset.getName(), newName);
        }
    }

    private List<TaggableObjectsDeletionService.ImpactedWikiArticle> computeImpactedWikiArticles(DatasetLocUtils.DatasetLoc dataset) throws IOException {
        List<String> projects;
        ArrayList<TaggableObjectsDeletionService.ImpactedWikiArticle> articles = new ArrayList<TaggableObjectsDeletionService.ImpactedWikiArticle>();
        try (Transaction t = this.transactionService.beginRead();){
            projects = this.projectsService.listProjectKeys();
        }
        for (String project : projects) {
            Transaction t = this.transactionService.beginRead();
            try {
                articles.addAll(this.computeImpactedWikiArticles(dataset, project));
            }
            finally {
                if (t == null) continue;
                t.close();
            }
        }
        return articles;
    }

    private List<TaggableObjectsDeletionService.ImpactedWikiArticle> computeImpactedWikiArticles(DatasetLocUtils.DatasetLoc dataset, String project) throws IOException {
        ArrayList<TaggableObjectsDeletionService.ImpactedWikiArticle> articles = new ArrayList<TaggableObjectsDeletionService.ImpactedWikiArticle>();
        Pattern pattern = DatasetRenameService.compileDatasetRefPattern(dataset, project);
        for (Article article : this.wikisService.listArticlesUnsafe(project, false)) {
            String payload = this.wikisService.getArticlePayloadOrNull(article.projectKey, article.id);
            boolean hasRefToDataset = payload != null && pattern.matcher(payload).find();
            boolean hasAttachmentToDataset = article.attachments.stream().anyMatch(a -> DatasetRenameService.attachmentIsRefToDataset(a, dataset, project));
            if (!hasRefToDataset && !hasAttachmentToDataset) continue;
            articles.add(new TaggableObjectsDeletionService.ImpactedWikiArticle(article.projectKey, article.id, hasRefToDataset, hasAttachmentToDataset));
        }
        return articles;
    }

    private void performRenamingForWikiArticle(DatasetLocUtils.DatasetLoc oldDataset, DatasetLocUtils.DatasetLoc newDataset, Set<TaggableObjectsDeletionService.ImpactedWikiArticle> articles) throws IOException {
        for (TaggableObjectsDeletionService.ImpactedWikiArticle impactedArticle : articles) {
            String payload;
            Article article = this.wikisService.getArticleOrNull(impactedArticle.projectKey, impactedArticle.id);
            if (article == null) continue;
            String newPayload = null;
            if (impactedArticle.hasRefToDataset && (payload = this.wikisService.getArticlePayloadOrNull(impactedArticle.projectKey, impactedArticle.id)) != null) {
                newPayload = this.performRenamingForArticlePayload(oldDataset, newDataset, article.projectKey, payload);
            }
            if (impactedArticle.hasAttachmentToDataset) {
                article.attachments.stream().filter(a -> DatasetRenameService.attachmentIsRefToDataset(a, oldDataset, article.projectKey)).forEach(a -> {
                    a.smartId = newDataset.getSmartName(article.projectKey);
                });
            }
            try {
                this.wikisService.saveArticle(article, newPayload);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to save wiki article pkey=" + article.projectKey + " article=" + article.id), (Throwable)e);
            }
        }
    }

    private String performRenamingForArticlePayload(DatasetLocUtils.DatasetLoc oldDataset, DatasetLocUtils.DatasetLoc newDataset, String project, String payload) {
        Matcher matcher = DatasetRenameService.compileDatasetRefPattern(oldDataset, project).matcher(payload);
        StringBuffer newPayload = new StringBuffer();
        while (matcher.find()) {
            String label = matcher.group(1);
            if (label.equals(oldDataset.getName())) {
                label = newDataset.getName();
            } else if (label.equals(oldDataset.getFullName())) {
                label = newDataset.getFullName();
            }
            String newLink = matcher.group(2).equals(oldDataset.getName()) ? newDataset.getName() : newDataset.getFullName();
            matcher.appendReplacement(newPayload, String.format("[%s](dataset:%s)", label, newLink));
        }
        matcher.appendTail(newPayload);
        return newPayload.toString();
    }

    private void computeImpactedNotebooks(Dataset dataset, Set<String> impactedProjects, Set<TaggableObjectsDeletionService.ImpactedNotebook> modifiedNotebooks, Set<TaggableObjectsDeletionService.ImpactedNotebook> modifiedLinkedNotebooks, Set<TaggableObjectsDeletionService.ImpactedNotebook> manuallyChangedNotebooks) throws IOException {
        for (String project : impactedProjects) {
            Set<TaggableObjectsDeletionService.ImpactedNotebook> sqlNotebooks = this.computeRenamingForSQLNotebooks(dataset, project);
            modifiedNotebooks.addAll(sqlNotebooks);
            Set<TaggableObjectsDeletionService.ImpactedNotebook> searchNotebooks = this.computeRenamingForSearchNotebooks(dataset, project);
            modifiedNotebooks.addAll(searchNotebooks);
            Set<TaggableObjectsDeletionService.ImpactedNotebook> jupyterNotebook = this.computeRenamingForJupyterNotebooks(dataset, project);
            modifiedNotebooks.addAll(jupyterNotebook);
            Set<TaggableObjectsDeletionService.ImpactedNotebook> linkedNotebooks = this.computeRenamingForLinkedNotebooks(dataset, project);
            modifiedLinkedNotebooks.addAll(linkedNotebooks);
            manuallyChangedNotebooks.addAll(linkedNotebooks.stream().filter(notebook -> !sqlNotebooks.contains(notebook) && !jupyterNotebook.contains(notebook)).toList());
        }
    }

    private Set<TaggableObjectsDeletionService.ImpactedNotebook> computeRenamingForSQLNotebooks(Dataset dataset, String project) throws IOException {
        HashSet<TaggableObjectsDeletionService.ImpactedNotebook> impact = new HashSet<TaggableObjectsDeletionService.ImpactedNotebook>();
        SqlCodeRenamer codeRenamer = new SqlCodeRenamer(dataset.getName());
        block0: for (SQLNotebook sqlNotebook : this.sqlNotebooksService.listWithoutTimelineUnsafe(project)) {
            for (List<SQLNotebookQuery> queryList : this.sqlNotebooksDAO.readQueriesUnsafe((String)project, (String)sqlNotebook.id).queries.values()) {
                if (queryList.isEmpty() || !codeRenamer.requiresRenaming(queryList.get(queryList.size() - 1).getUnexpandedSQL())) continue;
                impact.add(new TaggableObjectsDeletionService.ImpactedNotebook(project, sqlNotebook.id, sqlNotebook.name, "SQL"));
                continue block0;
            }
        }
        return impact;
    }

    private Set<TaggableObjectsDeletionService.ImpactedNotebook> computeRenamingForSearchNotebooks(Dataset dataset, String project) throws IOException {
        HashSet<TaggableObjectsDeletionService.ImpactedNotebook> impact = new HashSet<TaggableObjectsDeletionService.ImpactedNotebook>();
        block0: for (SearchNotebook notebook : this.searchNotebooksDAO.listUnsafe(project)) {
            for (SearchNotebook.SearchNotebookCell cell : notebook.cells) {
                if (cell.searchScope == null || cell.searchScope.scope != SearchNotebook.SearchNotebookCell.SearchScope.QueryScope.DATASETS || !cell.searchScope.datasets.contains(dataset.getFullName())) continue;
                impact.add(new TaggableObjectsDeletionService.ImpactedNotebook(notebook.projectKey, notebook.id, notebook.name, notebook.language));
                continue block0;
            }
        }
        return impact;
    }

    private Set<TaggableObjectsDeletionService.ImpactedNotebook> computeRenamingForJupyterNotebooks(Dataset dataset, String project) throws IOException {
        HashSet<TaggableObjectsDeletionService.ImpactedNotebook> impact = new HashSet<TaggableObjectsDeletionService.ImpactedNotebook>();
        for (JupyterUtils.JupyterNotebookListEntry notebook : this.jupyterService.listUnsafe(DSSAuthCtx.newNone(), project)) {
            if (!this.checkJupyterNotebookContainsDataset(notebook, dataset)) continue;
            impact.add(new TaggableObjectsDeletionService.ImpactedNotebook(notebook.projectKey, notebook.name, notebook.name, notebook.language));
        }
        return impact;
    }

    private Set<TaggableObjectsDeletionService.ImpactedNotebook> computeRenamingForLinkedNotebooks(Dataset dataset, String project) throws IOException {
        HashSet<TaggableObjectsDeletionService.ImpactedNotebook> impact = new HashSet<TaggableObjectsDeletionService.ImpactedNotebook>();
        for (DatasetNotebookService.SimpleNotebook notebook : this.datasetNotebookService.listDatasetNotebooksUnsafe(project, dataset.getSmartName(project))) {
            impact.add(new TaggableObjectsDeletionService.ImpactedNotebook(notebook.projectKey, notebook.id, notebook.name, notebook.type == DatasetNotebookService.NotebookType.JUPYTER ? notebook.language : "SQL"));
        }
        return impact;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkJupyterNotebookContainsDataset(JupyterUtils.JupyterNotebookListEntry notebook, Dataset dataset) throws IOException {
        void var6_9;
        TransactionRef t = TransactionContext.retrieveRead();
        RelFile nbFile = this.jupyterService.getNotebookFile(notebook.projectKey, notebook.name);
        JupyterUtils.NotebookSafeForWritingNew nbContent = (JupyterUtils.NotebookSafeForWritingNew)t.readObjectUnsafe(nbFile, JupyterUtils.NotebookSafeForWritingNew.class);
        Object var6_6 = null;
        if ("Python".equals(notebook.language)) {
            PythonCodeRenamer pythonCodeRenamer = new PythonCodeRenamer(notebook.projectKey, dataset.getLoc());
        } else if ("R".equals(notebook.language)) {
            RCodeRenamer rCodeRenamer = new RCodeRenamer(notebook.projectKey, dataset.getProjectKey(), dataset.getName());
        }
        if (var6_9 == null) return false;
        if (!nbContent.cells.stream().filter(cell -> "code".equals(cell.cell_type)).flatMap(cell -> cell.source.stream()).anyMatch(((CodeRenamer)var6_9)::requiresRenaming)) return false;
        return true;
    }

    private void performRenamingForNotebooks(DatasetLocUtils.DatasetLoc oldDatasetLoc, DatasetLocUtils.DatasetLoc newDatasetLoc, RenamingImpact impact, AuthCtx authCtx) throws Exception {
        block8: for (TaggableObjectsDeletionService.ImpactedNotebook impactedNotebook : impact.modifiedNotebooks) {
            switch (impactedNotebook.language) {
                case "SQL": {
                    this.performRenamingForSQLNotebook(impactedNotebook, oldDatasetLoc, newDatasetLoc, authCtx);
                    continue block8;
                }
                case "ES_QUERY_STRING": {
                    this.performRenamingForSearchNotebook(impactedNotebook, oldDatasetLoc, newDatasetLoc);
                    continue block8;
                }
            }
            this.performRenamingForJupyterNotebook(impactedNotebook, oldDatasetLoc, newDatasetLoc, authCtx);
        }
        for (TaggableObjectsDeletionService.ImpactedNotebook notebook : impact.modifiedLinkedNotebooks) {
            if (notebook.language.equals("ES_QUERY_STRING")) continue;
            if ("SQL".equals(notebook.language)) {
                SQLNotebook sqlNotebook = this.sqlNotebooksService.getOrNull(notebook.projectKey, notebook.id);
                if (sqlNotebook == null) continue;
                sqlNotebook.analyzedDataset = newDatasetLoc.getSmartName(notebook.projectKey);
                this.sqlNotebooksService.save(sqlNotebook, false);
                continue;
            }
            RWTransactionRef t = TransactionContext.retrieveWrite();
            JupyterUtils.JupyterNotebookListEntry jupyterNotebook = this.jupyterService.getOrNull(notebook.projectKey, notebook.id);
            if (jupyterNotebook == null) continue;
            jupyterNotebook.analyzedDataset = newDatasetLoc.getSmartName(notebook.projectKey);
            RelFile nbFile = this.jupyterService.getNotebookFile(notebook.projectKey, notebook.name);
            JupyterUtils.NotebookSafeForWritingNew nbContent = (JupyterUtils.NotebookSafeForWritingNew)t.readObjectUnsafe(nbFile, JupyterUtils.NotebookSafeForWritingNew.class);
            if (nbContent.metadata == null) {
                nbContent.metadata = new JsonObject();
            }
            nbContent.metadata.addProperty("analyzedDataset", newDatasetLoc.getSmartName(notebook.projectKey));
            t.writeObject(nbFile, (Object)nbContent);
        }
    }

    private void performRenamingForJupyterNotebook(TaggableObjectsDeletionService.ImpactedNotebook impactedNotebook, DatasetLocUtils.DatasetLoc oldDatasetLoc, DatasetLocUtils.DatasetLoc newDatasetLoc, AuthCtx authCtx) throws IOException {
        RegexCodeRenamer codeRenamer;
        JupyterUtils.JupyterNotebookListEntry notebook = this.jupyterService.getOrNull(impactedNotebook.projectKey, impactedNotebook.id);
        if (notebook == null) {
            return;
        }
        if ("Python".equals(notebook.language)) {
            codeRenamer = new PythonCodeRenamer(notebook.projectKey, oldDatasetLoc, newDatasetLoc, authCtx.getAssociatedDSSUser(), new Date());
        } else if ("R".equals(notebook.language)) {
            codeRenamer = new RCodeRenamer(notebook.projectKey, oldDatasetLoc.getProjectKey(), oldDatasetLoc.getId(), newDatasetLoc.getId(), authCtx.getAssociatedDSSUser(), new Date());
        } else {
            throw new NotImplementedException("Unsupported language " + notebook.language + " in notebook " + notebook.getFullId());
        }
        RWTransactionRef t = TransactionContext.retrieveWrite();
        RelFile nbFile = this.jupyterService.getNotebookFile(notebook.projectKey, notebook.name);
        JupyterUtils.NotebookSafeForWritingNew nbContent = (JupyterUtils.NotebookSafeForWritingNew)t.readObject(nbFile, JupyterUtils.NotebookSafeForWritingNew.class);
        for (JupyterUtils.CellForWriting cell : nbContent.cells) {
            if (!"code".equals(cell.cell_type)) continue;
            ListIterator<String> iterator = cell.source.listIterator();
            while (iterator.hasNext()) {
                String newPayload = codeRenamer.updatePayload(iterator.next());
                iterator.set(newPayload);
            }
        }
        t.writeObject(nbFile, (Object)nbContent);
    }

    private void performRenamingForSQLNotebook(TaggableObjectsDeletionService.ImpactedNotebook impactedNotebook, DatasetLocUtils.DatasetLoc oldDatasetLoc, DatasetLocUtils.DatasetLoc newDatasetLoc, AuthCtx authCtx) throws Exception {
        SqlCodeRenamer codeRenamer = new SqlCodeRenamer(oldDatasetLoc.getName(), newDatasetLoc.getName(), authCtx.getAssociatedDSSUser(), new Date());
        SQLNotebook notebook = this.sqlNotebooksService.getOrNull(impactedNotebook.projectKey, impactedNotebook.id);
        if (notebook == null) {
            return;
        }
        SQLNotebooksDAO.QueriesFile queries = this.sqlNotebooksDAO.getQueries(notebook.projectKey, notebook.id);
        for (String cellId : queries.queries.keySet()) {
            List<SQLNotebookQuery> queryList = queries.queries.get(cellId);
            if (queryList.isEmpty()) continue;
            SQLNotebookQuery query = queryList.get(queryList.size() - 1);
            query.updateUnexpandedSQL(codeRenamer.updatePayload(query.getUnexpandedSQL()));
            query.id = SecretKeyGenerator.generate((int)12);
            query.hash = DigestUtils.md5Hex((String)(query.connection + query.getUnexpandedSQL()));
            query.runOn = System.currentTimeMillis();
            query.runBy = authCtx.getIdentifier();
            query.state = JobState.NOT_STARTED;
            this.sqlNotebooksDAO.writeQueryToHistory(notebook.projectKey, notebook.id, cellId, query);
        }
    }

    private void performRenamingForSearchNotebook(TaggableObjectsDeletionService.ImpactedNotebook impactedNotebook, DatasetLocUtils.DatasetLoc oldDatasetLoc, DatasetLocUtils.DatasetLoc newDatasetLoc) throws Exception {
        SearchNotebook notebook = (SearchNotebook)this.searchNotebooksDAO.getOrNull(impactedNotebook.projectKey, impactedNotebook.id);
        if (notebook == null) {
            return;
        }
        for (SearchNotebook.SearchNotebookCell cell : notebook.cells) {
            if (cell.searchScope == null || cell.searchScope.scope != SearchNotebook.SearchNotebookCell.SearchScope.QueryScope.DATASETS) continue;
            for (int i = 0; i < cell.searchScope.datasets.size(); ++i) {
                String dataset = cell.searchScope.datasets.get(i);
                if (!dataset.equals(oldDatasetLoc.getFullName())) continue;
                cell.searchScope.datasets.set(i, newDatasetLoc.getFullName());
            }
        }
        this.searchNotebooksDAO.save(notebook);
    }

    private Set<ImpactedAgent> computeImpactedAgents(Dataset dataset, Set<String> impactedProjectKeys) throws IOException {
        DatasetLocUtils.DatasetLoc dsLoc = dataset.getLoc();
        HashSet<ImpactedAgent> impacts = new HashSet<ImpactedAgent>();
        for (String projectKey : impactedProjectKeys) {
            for (SavedModel sm : this.savedModelsDAO.listUnsafe(projectKey)) {
                if (!this.isAgentImpacted(sm, dsLoc, projectKey)) continue;
                impacts.add(new ImpactedAgent(sm.getProjectKey(), sm.getId(), sm.getDisplayName()));
            }
        }
        return impacts;
    }

    private boolean isAgentImpacted(SavedModel sm, DatasetLocUtils.DatasetLoc dsLoc, String contextProjectKey) {
        if (sm.savedModelType == null || !sm.savedModelType.isAgent()) {
            return false;
        }
        for (SavedModel.SavedModelInlineVersion smiv : sm.inlineVersions) {
            PythonCodeRenamer renamer;
            SavedModel.AgentSettings settings = sm.getAgentSettings(smiv);
            if (!(settings instanceof SavedModel.PythonAgentSettings)) continue;
            SavedModel.PythonAgentSettings codeAgentSettings = (SavedModel.PythonAgentSettings)settings;
            for (SavedModel.AgentDependency dep : codeAgentSettings.dependencies) {
                AnyLoc loc;
                if (!Objects.equals((Object)ITaggingService.TaggableType.DATASET, (Object)dep.type) || !Objects.equals(dsLoc, loc = AnyLoc.resolveSmart(contextProjectKey, dep.ref))) continue;
                return true;
            }
            if (smiv.code == null || !(renamer = new PythonCodeRenamer(sm.getProjectKey(), dsLoc)).requiresRenaming(smiv.code)) continue;
            return true;
        }
        return false;
    }

    private Set<ImpactedAgentTool> computeImpactedAgentTools(Dataset dataset, Set<String> impactedProjectKeys) throws IOException {
        DatasetLocUtils.DatasetLoc dsLoc = dataset.getLoc();
        HashSet<ImpactedAgentTool> impacts = new HashSet<ImpactedAgentTool>();
        for (String projectKey : impactedProjectKeys) {
            for (AgentTool tool : this.agentToolsDAO.listUnsafe(projectKey)) {
                if (!this.isAgentToolImpacted(tool, dsLoc, projectKey)) continue;
                impacts.add(new ImpactedAgentTool(tool.getProjectKey(), tool.getId(), tool.getDisplayName()));
            }
        }
        return impacts;
    }

    private boolean isAgentToolImpacted(AgentTool tool, DatasetLocUtils.DatasetLoc dsLoc, String contextProjectKey) {
        if (Objects.equals(DatasetRowAppendTool.META.getType(), tool.type)) {
            DatasetRowAppendTool.Params params = tool.getParamsCopyAs(DatasetRowAppendTool.Params.class);
            AnyLoc loc = AnyLoc.resolveSmart(contextProjectKey, params.datasetRef);
            return Objects.equals(dsLoc, loc);
        }
        if (Objects.equals(DatasetRowLookupTool.META.getType(), tool.type)) {
            DatasetRowLookupTool.Params params = tool.getParamsCopyAs(DatasetRowLookupTool.Params.class);
            AnyLoc loc = AnyLoc.resolveSmart(contextProjectKey, params.datasetRef);
            return Objects.equals(dsLoc, loc);
        }
        if (Objects.equals(InlinePythonTool.META.getType(), tool.type)) {
            InlinePythonTool.Params params = tool.getParamsCopyAs(InlinePythonTool.Params.class);
            for (SavedModel.AgentDependency dep : params.dependencies) {
                AnyLoc loc;
                if (!Objects.equals((Object)ITaggingService.TaggableType.DATASET, (Object)dep.type) || !Objects.equals(dsLoc, loc = AnyLoc.resolveSmart(contextProjectKey, dep.ref))) continue;
                return true;
            }
            if (params.code != null) {
                PythonCodeRenamer renamer = new PythonCodeRenamer(contextProjectKey, dsLoc);
                return renamer.requiresRenaming(params.code);
            }
            return false;
        }
        return false;
    }

    private Set<TaggableObjectsDeletionService.ImpactedReport> computeImpactedReports(Dataset dataset, Set<String> impactedProjects) throws IOException {
        HashSet<TaggableObjectsDeletionService.ImpactedReport> impactedReports = new HashSet<TaggableObjectsDeletionService.ImpactedReport>();
        for (String projectKey : impactedProjects) {
            for (Report report : this.reportsService.listUnsafe(projectKey)) {
                RCodeRenamer codeRenamer;
                String script = this.reportsService.getScript(projectKey, report.id);
                if (script == null || !(codeRenamer = new RCodeRenamer(report.projectKey, dataset.getProjectKey(), dataset.getName())).requiresRenaming(script)) continue;
                impactedReports.add(new TaggableObjectsDeletionService.ImpactedReport(report.projectKey, report.id, report.name));
            }
        }
        return impactedReports;
    }

    private Set<TaggableObjectsDeletionService.ImpactedWebApp> computeImpactedWebApps(Dataset dataset, Set<String> impactedProjects) throws IOException {
        HashSet<TaggableObjectsDeletionService.ImpactedWebApp> impactedWebApps = new HashSet<TaggableObjectsDeletionService.ImpactedWebApp>();
        for (String projectKey : impactedProjects) {
            for (WebApp webApp : this.webAppsService.listUnsafe(projectKey)) {
                if (!this.checkWebAppPythonContainsDataset(webApp, dataset) && !this.checkShinyWebAppContainsDataset(webApp, dataset)) continue;
                impactedWebApps.add(new TaggableObjectsDeletionService.ImpactedWebApp(webApp.projectKey, webApp.name, webApp.id, webApp.type));
            }
        }
        return impactedWebApps;
    }

    private boolean checkWebAppPythonContainsDataset(WebApp webApp, Dataset dataset) {
        String python = this.getWebAppPythonCodeOrNull(webApp);
        if (python == null) {
            return false;
        }
        PythonCodeRenamer codeRenamer = new PythonCodeRenamer(webApp.projectKey, dataset.getLoc());
        return codeRenamer.requiresRenaming(python);
    }

    private String getWebAppPythonCodeOrNull(WebApp webApp) {
        if (webApp == null) {
            return null;
        }
        switch (webApp.type) {
            case "STANDARD": {
                StandardWebAppMeta.StandardWebAppParams params = webApp.getParamsAs(StandardWebAppMeta.StandardWebAppParams.class);
                return params.python;
            }
            case "BOKEH": {
                BokehWebAppMeta.BokehWebAppParams params = webApp.getParamsAs(BokehWebAppMeta.BokehWebAppParams.class);
                return params.python;
            }
            case "DASH": {
                DashWebAppMeta.DashWebAppParams params = webApp.getParamsAs(DashWebAppMeta.DashWebAppParams.class);
                return params.python;
            }
            case "STREAMLIT": {
                StreamlitWebAppMeta.StreamlitWebAppParams params = webApp.getParamsAs(StreamlitWebAppMeta.StreamlitWebAppParams.class);
                return params.python;
            }
        }
        return null;
    }

    private void updateWebAppPythonCode(WebApp webApp, PythonCodeRenamer pythonRecipeRenamer) {
        switch (webApp.type) {
            case "STANDARD": {
                StandardWebAppMeta.StandardWebAppParams params = webApp.getParamsAs(StandardWebAppMeta.StandardWebAppParams.class);
                params.python = pythonRecipeRenamer.updatePayload(params.python);
                break;
            }
            case "BOKEH": {
                BokehWebAppMeta.BokehWebAppParams params = webApp.getParamsAs(BokehWebAppMeta.BokehWebAppParams.class);
                params.python = pythonRecipeRenamer.updatePayload(params.python);
                break;
            }
            case "DASH": {
                DashWebAppMeta.DashWebAppParams params = webApp.getParamsAs(DashWebAppMeta.DashWebAppParams.class);
                params.python = pythonRecipeRenamer.updatePayload(params.python);
                break;
            }
            case "STREAMLIT": {
                StreamlitWebAppMeta.StreamlitWebAppParams params = webApp.getParamsAs(StreamlitWebAppMeta.StreamlitWebAppParams.class);
                params.python = pythonRecipeRenamer.updatePayload(params.python);
                break;
            }
            default: {
                throw new NotImplementedException("Unexpected web app type " + webApp.type);
            }
        }
    }

    private boolean checkShinyWebAppContainsDataset(WebApp webApp, Dataset dataset) {
        if (!"SHINY".equals(webApp.type)) {
            return false;
        }
        ShinyWebAppMeta.ShinyWebAppParams params = webApp.getParamsAs(ShinyWebAppMeta.ShinyWebAppParams.class);
        RCodeRenamer codeRenamer = new RCodeRenamer(webApp.projectKey, dataset.getProjectKey(), dataset.getName());
        return codeRenamer.requiresRenaming(params.server);
    }

    private void updateShinyWebAppCode(WebApp webApp, RCodeRenamer rCodeRenamer) {
        ShinyWebAppMeta.ShinyWebAppParams params = webApp.getParamsAs(ShinyWebAppMeta.ShinyWebAppParams.class);
        params.server = rCodeRenamer.updatePayload(params.server);
    }

    private void performRenamingForReports(DatasetLocUtils.DatasetLoc oldDatasetLoc, DatasetLocUtils.DatasetLoc newDatasetLoc, Set<TaggableObjectsDeletionService.ImpactedReport> impactedReports, AuthCtx authCtx) throws Exception {
        for (TaggableObjectsDeletionService.ImpactedReport impactedReport : impactedReports) {
            String script;
            Report report = this.reportsService.getOrNull(impactedReport.projectKey, impactedReport.id);
            if (report == null || (script = this.reportsService.getScript(report.projectKey, report.id)) == null) continue;
            RCodeRenamer codeRenamer = new RCodeRenamer(report.projectKey, oldDatasetLoc.getProjectKey(), oldDatasetLoc.getId(), newDatasetLoc.getId(), authCtx.getAssociatedDSSUser(), new Date());
            script = codeRenamer.updatePayload(script);
            this.reportsService.save(report, script, false);
        }
    }

    private void performRenamingForWebApps(DatasetLocUtils.DatasetLoc oldDatasetLoc, DatasetLocUtils.DatasetLoc newDatasetLoc, Set<TaggableObjectsDeletionService.ImpactedWebApp> impactedWebApps, AuthCtx authCtx) throws Exception {
        TransactionContext.assertAttachedRWTransaction();
        for (TaggableObjectsDeletionService.ImpactedWebApp impactedWebApp : impactedWebApps) {
            WebApp webApp = this.webAppsService.getOrNull(impactedWebApp.projectKey, impactedWebApp.id);
            if (webApp == null) continue;
            if ("SHINY".equals(webApp.type)) {
                RCodeRenamer rCodeRenamer = new RCodeRenamer(webApp.projectKey, oldDatasetLoc.getProjectKey(), oldDatasetLoc.getId(), newDatasetLoc.getId(), authCtx.getAssociatedDSSUser(), new Date());
                this.updateShinyWebAppCode(webApp, rCodeRenamer);
            } else {
                PythonCodeRenamer pythonCodeRenamer = new PythonCodeRenamer(webApp.projectKey, oldDatasetLoc, newDatasetLoc, authCtx.getAssociatedDSSUser(), new Date());
                this.updateWebAppPythonCode(webApp, pythonCodeRenamer);
            }
            this.webAppsService.save(webApp, false);
            WebAppHandler wah = WebAppHandler.buildHandler(webApp);
            wah.writeCodeFiles();
        }
    }

    private void performRenamingForInsights(DatasetLocUtils.DatasetLoc oldDataset, DatasetLocUtils.DatasetLoc newDataset) throws Exception {
        HashSet<String> authorizedTargetProjectKeys = new HashSet<String>();
        String projectKey = oldDataset.getProjectKey();
        authorizedTargetProjectKeys.add(projectKey);
        authorizedTargetProjectKeys.addAll(this.insightsService.listTargetProjectKeys(projectKey, oldDataset.getName()));
        for (Insight insight : this.insightsService.listForSource(projectKey, ITaggingService.TaggableType.DATASET, oldDataset.getName(), authorizedTargetProjectKeys, true)) {
            String newDatasetSM = newDataset.getSmartName(insight.projectKey);
            InsightParams insightParams = insight.params;
            if (insightParams instanceof DatasetTableInsightParams) {
                DatasetTableInsightParams dtip = (DatasetTableInsightParams)insightParams;
                dtip.datasetSmartName = newDatasetSM;
            } else {
                insightParams = insight.params;
                if (insightParams instanceof ChartInsightParams) {
                    ChartInsightParams cip = (ChartInsightParams)insightParams;
                    cip.datasetSmartName = newDatasetSM;
                } else {
                    insightParams = insight.params;
                    if (insightParams instanceof DiscussionsInsightParams) {
                        DiscussionsInsightParams dip = (DiscussionsInsightParams)insightParams;
                        dip.objectId = newDatasetSM;
                    } else {
                        insightParams = insight.params;
                        if (insightParams instanceof MetricsInsightParams) {
                            MetricsInsightParams mip = (MetricsInsightParams)insightParams;
                            mip.objectSmartId = newDatasetSM;
                        } else {
                            insightParams = insight.params;
                            if (insightParams instanceof DataQualityInsightParams) {
                                DataQualityInsightParams dqip = (DataQualityInsightParams)insightParams;
                                dqip.objectSmartId = newDatasetSM;
                            } else {
                                logger.warn((Object)("Could not rename dataset for insight type '" + insight.getClass().getName() + "': not implemented"));
                            }
                        }
                    }
                }
            }
            this.insightsService.save(insight, false, null);
        }
    }

    private void performRenamingForDashboards(DatasetLocUtils.DatasetLoc oldDataset, DatasetLocUtils.DatasetLoc newDataset, AuthCtx authCtx) throws Exception {
        String projectKey = oldDataset.getProjectKey();
        String oldDatasetName = oldDataset.getSmartName(projectKey);
        String newDatasetSM = newDataset.getSmartName(projectKey);
        for (Dashboard dashboard : this.dashboardsService.listDashboards(authCtx, projectKey)) {
            for (DashboardPage page : dashboard.pages) {
                if (page.filtersParams.datasetSmartName == null || !page.filtersParams.datasetSmartName.equals(oldDatasetName)) continue;
                page.filtersParams.datasetSmartName = newDatasetSM;
            }
            this.dashboardsService.save(dashboard, false);
        }
    }

    private void performRenamingForLabelingTasks(DatasetLocUtils.DatasetLoc oldDataset, DatasetLocUtils.DatasetLoc newDataset, List<TaggableObjectsDeletionService.ImpactedLabelingTask> labelingTasks) throws Exception {
        for (TaggableObjectsDeletionService.ImpactedLabelingTask t : labelingTasks) {
            LabelingTask labelingTask = (LabelingTask)this.labelingTasksDAO.getOrNull(t.projectKey, t.id);
            if (labelingTask == null) continue;
            String oldDatasetName = oldDataset.getSmartName(labelingTask.projectKey);
            String newDatasetName = newDataset.getSmartName(labelingTask.projectKey);
            for (LabelingTask.LabelingTaskInput input : labelingTask.getFlatInputs()) {
                if (!input.ref.equals(oldDatasetName)) continue;
                input.ref = newDatasetName;
            }
            for (LabelingTask.LabelingTaskOutput output : labelingTask.getFlatOutputs()) {
                if (!output.ref.equals(oldDatasetName)) continue;
                output.ref = newDatasetName;
            }
            this.labelingTasksCRUDService.upsertLabelingTask(labelingTask, null);
        }
    }

    private void performRenamingForRecipes(DatasetLocUtils.DatasetLoc oldDataset, DatasetLocUtils.DatasetLoc newDataset, RenamingImpact impact, AuthCtx authCtx) throws Exception {
        List allImpactedRecipes = Streams.concat((Stream[])new Stream[]{impact.automaticallyChangedRecipes.stream(), impact.bestEffortAutomaticallyChangedRecipes.stream(), impact.manuallyChangedRecipes.stream()}).toList();
        for (TaggableObjectsDeletionService.ImpactedRecipe recipe : allImpactedRecipes) {
            logger.info((Object)("Updating IO in " + recipe.name + " from project " + recipe.projectKey));
            this.performRenamingForRecipe(oldDataset, newDataset, authCtx, recipe);
        }
    }

    public void performRenamingForRecipe(DatasetLocUtils.DatasetLoc oldDataset, DatasetLocUtils.DatasetLoc newDataset, AuthCtx authCtx, TaggableObjectsDeletionService.ImpactedRecipe recipe) throws IOException, DKUSecurityException, CodedException {
        this.performRenamingForRecipe(oldDataset, newDataset, authCtx, recipe, true);
    }

    public void performRenamingForRecipe(DatasetLocUtils.DatasetLoc oldDataset, DatasetLocUtils.DatasetLoc newDataset, AuthCtx authCtx, TaggableObjectsDeletionService.ImpactedRecipe recipe, boolean includeReplacementHeader) throws IOException, DKUSecurityException, CodedException {
        SerializedRecipe sr = (SerializedRecipe)this.recipesDAO.getOrNull(recipe.projectKey, recipe.name);
        if (sr == null) {
            return;
        }
        DatasetRenameService.performDatasetRenamingForRecipeInplace(oldDataset, newDataset, sr, recipe.projectKey);
        String payload = this.recipesDAO.getPayloadOrNull(sr.projectKey, sr.name);
        if (payload == null) {
            this.recipeSaveService.save(sr.projectKey, sr, null);
            return;
        }
        if (ShakerRecipeMeta.META.getType().equals(sr.type)) {
            SerializedShakerScript shakerScript = (SerializedShakerScript)JSON.parse((String)payload, SerializedShakerScript.class);
            this.checkRenamingOnShakerScript(oldDataset, newDataset, sr.projectKey, shakerScript, true);
            payload = JSON.json((Object)shakerScript);
        }
        payload = DatasetRenameService.renameDatasetInRecipePayload(sr, sr.projectKey, payload, oldDataset, newDataset, true, authCtx, includeReplacementHeader);
        this.recipeSaveService.save(sr.projectKey, sr, payload);
    }

    public static void performDatasetRenamingForRecipeInplace(DatasetLocUtils.DatasetLoc oldDataset, DatasetLocUtils.DatasetLoc newDataset, SerializedRecipe sr, String sourceProjectkey) {
        VariablesExpansionLoopConfig variablesExpansionLoopConfig;
        Object params;
        String oldDatasetName = oldDataset.getSmartName(sourceProjectkey);
        String newDatasetName = newDataset.getSmartName(sr.projectKey);
        PartitioningScheme newDatasetPartitionSchema = null;
        for (SerializedRecipe.InputRole inputRole : sr.getInputsUnsafe().values()) {
            for (SerializedRecipe.RecipeInput rinput : inputRole.items) {
                if (rinput.ref.equals(oldDatasetName)) {
                    rinput.ref = newDatasetName;
                    if (newDatasetPartitionSchema == null) {
                        newDatasetPartitionSchema = new PartitionableResolver().getPartitioningSchemeOrNull(sr, newDatasetName);
                    }
                    PartitioningScheme newDatasetPartitionSchemaFinal = newDatasetPartitionSchema;
                    rinput.deps = rinput.deps.stream().filter(dep -> {
                        boolean inputDimensionStillExists = false;
                        if (newDatasetPartitionSchemaFinal != null && newDatasetPartitionSchemaFinal.isPartitioned()) {
                            inputDimensionStillExists = newDatasetPartitionSchemaFinal.getDimension(dep.idim) != null;
                        }
                        return inputDimensionStillExists;
                    }).toList();
                }
                for (SerializedRecipe.SDep dep2 : rinput.deps) {
                    if (dep2 == null || dep2.out == null || !dep2.out.equals(oldDatasetName)) continue;
                    dep2.out = newDatasetName;
                }
            }
        }
        for (SerializedRecipe.OutputRole outputRole : sr.getOutputsUnsafe().values()) {
            for (SerializedRecipe.RecipeOutput routput : outputRole.items) {
                if (!routput.ref.equals(oldDatasetName)) continue;
                routput.ref = newDatasetName;
            }
        }
        if (SQLQueryRecipeMeta.META.getType().equals(sr.type)) {
            params = sr.getParamsAs(SQLQueryRecipeMeta.SQLQueryRecipeParams.class);
            if (oldDatasetName.equals(((SQLQueryRecipeMeta.SQLQueryRecipeParams)params).mainConnectionDataset)) {
                ((SQLQueryRecipeMeta.SQLQueryRecipeParams)params).mainConnectionDataset = newDatasetName;
            }
        } else if (SQLScriptRecipeMeta.META.getType().equals(sr.type)) {
            params = sr.getParamsAs(SQLScriptRecipeMeta.SQLScriptRecipeParams.class);
            if (oldDatasetName.equals(((SQLScriptRecipeMeta.SQLScriptRecipeParams)params).mainConnectionDataset)) {
                ((SQLScriptRecipeMeta.SQLScriptRecipeParams)params).mainConnectionDataset = newDatasetName;
            }
        } else if (ShellScriptRecipeMeta.META.getType().equals(sr.type)) {
            params = sr.getParamsAs(ShellScriptRecipeMeta.ShellScriptRecipeParams.class);
            if (oldDatasetName.equals(((ShellScriptRecipeMeta.ShellScriptRecipeParams)params).pipeIn)) {
                ((ShellScriptRecipeMeta.ShellScriptRecipeParams)params).pipeIn = newDatasetName;
            }
            if (oldDatasetName.equals(((ShellScriptRecipeMeta.ShellScriptRecipeParams)params).pipeOut)) {
                ((ShellScriptRecipeMeta.ShellScriptRecipeParams)params).pipeOut = newDatasetName;
            }
        }
        RecipeParams recipeParams = sr.params;
        if (recipeParams instanceof ParamsWithVariablesExpansionLoopConfig && (variablesExpansionLoopConfig = (params = (ParamsWithVariablesExpansionLoopConfig)((Object)recipeParams)).getVariablesExpansionLoopConfig()).isEnabled() && oldDatasetName.equals(variablesExpansionLoopConfig.datasetRef)) {
            variablesExpansionLoopConfig.datasetRef = newDatasetName;
        }
    }

    private void performRenamingForManualLineage(DatasetLocUtils.DatasetLoc oldDataset, DatasetLocUtils.DatasetLoc newDataset, RenamingImpact impact) throws Exception {
        List allImpactedRecipes = Streams.concat((Stream[])new Stream[]{impact.automaticallyChangedRecipes.stream(), impact.bestEffortAutomaticallyChangedRecipes.stream(), impact.manuallyChangedRecipes.stream()}).toList();
        for (TaggableObjectsDeletionService.ImpactedRecipe recipe : allImpactedRecipes) {
            logger.info((Object)("Updating manual lineage for outputs of recipe " + recipe.name + " from project " + recipe.projectKey));
            this.performRenamingForManualLineage(oldDataset, newDataset, recipe);
        }
    }

    public void performRenamingForManualLineage(DatasetLocUtils.DatasetLoc oldDataset, DatasetLocUtils.DatasetLoc newDataset, TaggableObjectsDeletionService.ImpactedRecipe recipe) throws IOException, CodedException, DKUSecurityException {
        String updatedHash;
        SerializedRecipe sr = (SerializedRecipe)this.recipesDAO.getOrNull(recipe.projectKey, recipe.name);
        if (sr == null) {
            return;
        }
        RecipeManualLineageConfig manualLineageConfig = sr.manualLineageConfig;
        if (manualLineageConfig != null && !Objects.equals(manualLineageConfig.dependenciesHash, updatedHash = this.dataLineageService.computeManualLineageDependenciesHash(recipe.projectKey, recipe.name))) {
            manualLineageConfig.dependenciesHash = updatedHash;
            this.recipeSaveService.save(recipe.projectKey, sr);
        }
        String oldDatasetFullName = oldDataset.getFullName();
        String newDatasetFullName = newDataset.getFullName();
        for (SerializedRecipe.OutputRole outputRole : sr.getOutputsUnsafe().values()) {
            for (SerializedRecipe.RecipeOutput recipeOutput : outputRole.items) {
                boolean renamed;
                SerializedDataset outputDataset = (SerializedDataset)this.datasetsDAO.getOrNull(recipeOutput.getLoc(recipe.projectKey));
                if (outputDataset == null || outputDataset.manualDataLineage == null || !(renamed = outputDataset.manualDataLineage.renameInputDataset(recipe.projectKey, oldDatasetFullName, newDatasetFullName))) continue;
                this.datasetsDAO.save(outputDataset);
            }
        }
    }

    private void performRenamingForDatasets(DatasetLocUtils.DatasetLoc oldDatasetLoc, DatasetLocUtils.DatasetLoc newDataset, RenamingImpact impact) throws Exception {
        for (TaggableObjectsDeletionService.ImpactedDataset ds : impact.modifiedDatasets) {
            logger.info((Object)("Updating implicit recipe in " + ds.name + " from project " + ds.projectKey));
            this.performRenamingForDataset(oldDatasetLoc, newDataset, ds);
        }
    }

    public void performRenamingForDataset(DatasetLocUtils.DatasetLoc oldDataset, DatasetLocUtils.DatasetLoc newDataset, TaggableObjectsDeletionService.ImpactedDataset ds) throws IOException {
        VariablesExpansionLoopConfig veLoopConfig;
        DatasetHandler.DatasetParams params;
        SerializedDataset dataset = (SerializedDataset)this.datasetsDAO.getOrNull(ds.projectKey, ds.name);
        if (dataset == null) {
            return;
        }
        String oldDatasetName = oldDataset.getSmartName(ds.projectKey);
        String newDatasetName = newDataset.getSmartName(ds.projectKey);
        boolean renamed = false;
        if (dataset.type.equals("JobsDB")) {
            params = dataset.getParamsAs(JobsdbDatasetParams.class);
            if (oldDatasetName.equals(((JobsdbDatasetParams)params).smartName)) {
                ((JobsdbDatasetParams)params).smartName = newDatasetName;
                dataset.setParams(params);
                renamed = true;
            }
        }
        if ((veLoopConfig = DatasetUtils.getDatasetVeLoopConfig(params = dataset.getParams())) != null && veLoopConfig.isEnabled() && oldDatasetName.equals(veLoopConfig.datasetRef)) {
            veLoopConfig.datasetRef = newDatasetName;
            dataset.setParams(params);
            renamed = true;
        }
        if (renamed) {
            this.datasetsDAO.save(dataset);
        }
    }

    public static String updateDatasetInRecipePayload(SerializedRecipe recipe, String originProject, String payload, DatasetLocUtils.DatasetLoc oldName, DatasetLocUtils.DatasetLoc newName, boolean input, AuthCtx authCtx) {
        if (DatasetRenameService.recipeTypeIsRenamable(recipe, input) && !oldName.getSmartName(originProject).equals(newName.getSmartName(recipe.projectKey))) {
            return DatasetRenameService.renameDatasetInRecipePayload(recipe, originProject, payload, oldName.toDatasetLoc(), newName.toDatasetLoc(), input, authCtx);
        }
        return payload;
    }

    public static boolean recipeTypeIsRenamable(SerializedRecipe recipe, boolean input) {
        return PythonCodeRenamer.RECIPE_TYPES.contains(recipe.type) || RCodeRenamer.RECIPE_TYPES.contains(recipe.type) || input && SqlCodeRenamer.RECIPE_TYPES.contains(recipe.type);
    }

    public static String renameDatasetInRecipePayload(SerializedRecipe recipe, String oldProjectKey, String payload, DatasetLocUtils.DatasetLoc oldDataset, DatasetLocUtils.DatasetLoc newDataset, boolean withSQL, AuthCtx authCtx) {
        return DatasetRenameService.renameDatasetInRecipePayload(recipe, oldProjectKey, payload, oldDataset, newDataset, withSQL, authCtx, true);
    }

    public static String renameDatasetInRecipePayload(SerializedRecipe recipe, String oldProjectKey, String payload, DatasetLocUtils.DatasetLoc oldDataset, DatasetLocUtils.DatasetLoc newDataset, boolean withSQL, AuthCtx authCtx, boolean includeReplacementHeader) {
        String newProjectKey = recipe.projectKey;
        String updateMessage = String.format("Updating script in recipe %s from project %s", recipe.getId(), oldProjectKey);
        if (PythonCodeRenamer.RECIPE_TYPES.contains(recipe.type)) {
            logger.info((Object)updateMessage);
            PythonCodeRenamer renamer = new PythonCodeRenamer(oldProjectKey, newProjectKey, oldDataset, newDataset, authCtx.getAssociatedDSSUser(), new Date());
            payload = renamer.updatePayload(payload, includeReplacementHeader);
        } else if (RCodeRenamer.RECIPE_TYPES.contains(recipe.type)) {
            logger.info((Object)updateMessage);
            RCodeRenamer renamer = new RCodeRenamer(oldProjectKey, newProjectKey, oldDataset, newDataset, authCtx.getAssociatedDSSUser(), new Date());
            payload = renamer.updatePayload(payload, includeReplacementHeader);
        } else if (withSQL && SqlCodeRenamer.RECIPE_TYPES.contains(recipe.type)) {
            logger.info((Object)updateMessage);
            SqlCodeRenamer renamer = new SqlCodeRenamer(oldDataset.getSmartName(oldProjectKey), newDataset.getSmartName(newProjectKey), authCtx.getAssociatedDSSUser(), new Date());
            payload = renamer.updatePayload(payload);
        }
        payload = DatasetRenameService.renameDatasetInSparkSQLReadParams(recipe, payload, oldDataset, newDataset);
        return payload;
    }

    private static String renameDatasetInSparkSQLReadParams(SerializedRecipe recipe, String payload, DatasetLocUtils.DatasetLoc oldDataset, DatasetLocUtils.DatasetLoc newDataset) {
        try {
            RecipeMeta meta = RecipeRegistry.getMeta(recipe);
            InputDatasetsReadParams inputDatasetsReadParams = meta.getInputDatasetsReadParams(recipe, payload);
            if (inputDatasetsReadParams != null) {
                InputDatasetsReadParams.InputDatasetReadParams param = inputDatasetsReadParams.map.remove(oldDataset.getId());
                if (param != null) {
                    inputDatasetsReadParams.map.put(newDataset.getId(), param);
                }
                payload = meta.setInputDatasetsReadParams(recipe, payload, inputDatasetsReadParams);
            }
        }
        catch (Exception e) {
            logger.info((Object)"Failed to rename dataset in sparkSQL read params", (Throwable)e);
        }
        return payload;
    }

    private boolean scriptContainsDataset(DatasetLocUtils.DatasetLoc oldName, String projectKey, SerializedShakerScript script) {
        return this.checkRenamingOnShakerScript(oldName, oldName, projectKey, script, false);
    }

    private boolean checkRenamingOnShakerScript(DatasetLocUtils.DatasetLoc oldName, DatasetLocUtils.DatasetLoc newName, String project, SerializedShakerScript script, boolean performRenaming) {
        boolean hasChanged = false;
        ArrayList<String> possibleNames = new ArrayList<String>();
        possibleNames.add(oldName.getSmartName(project));
        if (oldName.getProjectKey().equals(project)) {
            possibleNames.add(oldName.getFullName());
        }
        String newSmartName = newName.getSmartName(project);
        for (ScriptStep step : script.steps) {
            if (step.metaType == ScriptStep.MetaType.PROCESSOR) {
                boolean bl = hasChanged = this.checkRenamingOnProcessorStep(possibleNames, newSmartName, (ProcessorScriptStep)step, performRenaming) || hasChanged;
                if (performRenaming || !hasChanged) continue;
                return true;
            }
            if (step.metaType != ScriptStep.MetaType.GROUP) continue;
            for (ProcessorScriptStep processorStep : ((GroupScriptStep)step).steps) {
                boolean bl = hasChanged = this.checkRenamingOnProcessorStep(possibleNames, newSmartName, processorStep, performRenaming) || hasChanged;
                if (performRenaming || !hasChanged) continue;
                return true;
            }
        }
        return hasChanged;
    }

    private boolean checkRenamingOnProcessorStep(List<String> possibleNames, String newName, ProcessorScriptStep step, boolean performRenaming) {
        if (MemoryEquiJoiner.META.getName().equals(step.type) || MemoryEquiJoiner.META_FUZZY.getName().equals(step.type)) {
            MemoryEquiJoiner.Parameter params = (MemoryEquiJoiner.Parameter)step.params;
            if (possibleNames.contains(params.rightInput)) {
                if (performRenaming) {
                    params.rightInput = newName;
                }
                return true;
            }
        } else if (NearestNeighbourGeoJoiner.META.getName().equals(step.type)) {
            NearestNeighbourGeoJoiner.Parameter params = (NearestNeighbourGeoJoiner.Parameter)step.params;
            if (possibleNames.contains(params.rightInput)) {
                if (performRenaming) {
                    params.rightInput = newName;
                }
                return true;
            }
        } else if (FindReplace.META.getName().equals(step.type)) {
            FindReplace.Parameter params = (FindReplace.Parameter)step.params;
            if (possibleNames.contains(params.mappingDatasetRef)) {
                if (performRenaming) {
                    params.mappingDatasetRef = newName;
                }
                return true;
            }
        }
        return false;
    }

    public RenamingImpact computeRenamingImpact(Dataset dataset) throws Exception {
        RenamingImpact di = new RenamingImpact();
        try (Transaction t = this.transactionService.beginRead();){
            Set<String> impactedProjects = this.computeImpactedProjects(dataset);
            di.modifiedProjects = impactedProjects;
            this.computeImpactedLabelingTasks(dataset, impactedProjects, di.modifiedLabelingTasks);
            this.computeImpactedRecipes(dataset, impactedProjects, di.automaticallyChangedRecipes, di.bestEffortAutomaticallyChangedRecipes, di.manuallyChangedRecipes);
            this.computeImpactedDatasets(dataset, impactedProjects, di.modifiedDatasets);
            for (String project : impactedProjects) {
                for (AnalysisCoreParams.AnalysisListItem head : this.analysisCRUDService.listHeadsUnsafe(project, dataset.getSmartName(project))) {
                    di.modifiedAnalyses.add(new TaggableObjectsDeletionService.ImpactedAnalysis(project, dataset.getSmartName(project), head.id, head.name));
                }
                for (AnalysisCoreParams analysis : this.analysisCRUDService.listCoreUnsafe(project, null)) {
                    if (!this.scriptContainsDataset(dataset.getLoc(), project, analysis.script)) continue;
                    di.modifiedAnalysesWithJoin.add(new TaggableObjectsDeletionService.ImpactedAnalysis(project, dataset.getSmartName(project), analysis.id, analysis.name));
                }
            }
            for (WorksheetsService.WorksheetHead worksheetHead : this.worksheetsService.listWorksheetHeads(dataset.getProjectKey(), dataset.getName())) {
                di.modifiedWorksheets.add(new TaggableObjectsDeletionService.ImpactedWorksheet(dataset.getProjectKey(), worksheetHead.id, worksheetHead.name));
            }
            for (Insight insight : this.insightsService.listForSourceUnsafe(dataset.getProjectKey(), ITaggingService.TaggableType.DATASET, dataset.getName())) {
                di.modifiedInsights.add(new TaggableObjectsDeletionService.ImpactedInsight(dataset.getProjectKey(), insight.id, insight.name, insight.getClass().getName()));
            }
            this.computeImpactedScenarios(dataset, impactedProjects, di.modifiedScenarios, di.bestEffortAutomaticallyChangedScenarios);
            for (Zone zone : this.flowZonesService.listContains(dataset.getProjectKey(), ITaggingService.TaggableType.DATASET, dataset.getName())) {
                SmartObjectRef ref = SmartObjectRef.fromResolved(ITaggingService.TaggableType.DATASET, dataset.getProjectKey(), dataset.getName(), zone.getProjectKey());
                di.modifiedZones.add(new TaggableObjectsDeletionService.ImpactedZone(zone.getProjectKey(), zone.getId(), zone.getItems().contains(ref)));
            }
            di.modifiedWorkspaces.addAll(this.workspacesService.listAllWorkspacesContainingObject(dataset.getProjectKey(), ITaggingService.TaggableType.DATASET, dataset.getName()));
            this.computeImpactedNotebooks(dataset, impactedProjects, di.modifiedNotebooks, di.modifiedLinkedNotebooks, di.manuallyChangedNotebooks);
            di.modifiedWebApps.addAll(this.computeImpactedWebApps(dataset, impactedProjects));
            di.modifiedReports.addAll(this.computeImpactedReports(dataset, impactedProjects));
            di.modifiedDataCollections.addAll(this.computeImpactedDataCollections(dataset));
            di.modifiedDqRules.addAll(this.computeImpactedDataQualityRules(dataset));
            Set<ImpactedAgent> impactedAgents = this.computeImpactedAgents(dataset, impactedProjects);
            di.modifiedAgents.addAll(impactedAgents);
            Set<ImpactedAgentTool> impactedAgentTools = this.computeImpactedAgentTools(dataset, impactedProjects);
            di.modifiedAgentTools.addAll(impactedAgentTools);
        }
        di.modifiedWikiArticle.addAll(this.computeImpactedWikiArticles(dataset.getLoc()));
        di.clearedDataQuality = this.dataQualityService.datasetHasDataQualityHistory(dataset.getLoc());
        if (di.clearedDataQuality) {
            di.clearedBasicMetrics = true;
            di.clearedNonBasicMetrics = true;
        } else {
            di.clearedNonBasicMetrics = this.dataQualityService.datasetHasMetricHistory(dataset.getLoc(), new ReadOnlyJobsInternalDB.ProbeTypeFilter().withExcludedProbeTypes(BASIC_PROBE_TYPES));
            di.clearedBasicMetrics = di.clearedNonBasicMetrics || !this.dataQualityService.datasetHasMetricHistory(dataset.getLoc(), new ReadOnlyJobsInternalDB.ProbeTypeFilter().withIncludedProbeTypes(BASIC_PROBE_TYPES));
        }
        this.computeImpactedApp_NT(dataset, di);
        return di;
    }

    private Set<String> computeImpactedDataCollections(Dataset dataset) throws IOException {
        AbstractDataCollectionItemRef.DatasetRef expectedItem = new AbstractDataCollectionItemRef.DatasetRef(dataset.getProjectKey(), dataset.getName());
        return this.dataCollectionService.listUnsafe().stream().filter(dataCollection -> dataCollection.contains(expectedItem)).map(dataCollection -> dataCollection.id).collect(Collectors.toSet());
    }

    private List<TaggableObjectsDeletionService.ImpactedDataQualityRule> computeImpactedDataQualityRules(Dataset dataset) throws IOException {
        ArrayList<TaggableObjectsDeletionService.ImpactedDataQualityRule> impactedDqRules = new ArrayList<TaggableObjectsDeletionService.ImpactedDataQualityRule>();
        String projectKey = dataset.getProjectKey();
        for (SerializedDataset serializedDataset : this.datasetsDAO.listUnsafe(projectKey)) {
            for (DataQualityRule rule : serializedDataset.getDataQualityRuleSet().getRules()) {
                if (!(rule instanceof CompareMetricsRule)) continue;
                CompareMetricsRule compareMetricsRule = (CompareMetricsRule)rule;
                if (!Objects.equals(dataset.getName(), compareMetricsRule.datasetBName)) continue;
                impactedDqRules.add(new TaggableObjectsDeletionService.ImpactedDataQualityRule(projectKey, serializedDataset.getId(), rule.getId()));
            }
        }
        return impactedDqRules;
    }

    /*
     * Unable to fully structure code
     */
    private void computeImpactedApp_NT(Dataset dataset, RenamingImpact di) throws IOException {
        lookupAppAsRecipes = false;
        t = this.transactionService.beginRead();
        try {
            sp = this.projectsService.getMandatoryUnsafe(dataset.getProjectKey());
            projectAppType = sp.projectAppType;
            switch (1.$SwitchMap$com$dataiku$dip$coremodel$SerializedProject$ProjectAppType[projectAppType.ordinal()]) {
                case 1: {
                    manifest = this.appsService.getAppInstanceManifestForProject_T(DSSAuthCtx.newNone(), sp.projectKey);
                    ** break;
lbl10:
                    // 1 sources

                    break;
                }
                case 2: {
                    manifest = this.appsService.getAppTemplateManifestForProject_T(sp.projectKey);
                    ** break;
lbl14:
                    // 1 sources

                    break;
                }
                default: {
                    manifest = null;
                    break;
                }
            }
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
        if (manifest != null) {
            for (AppManifest.AppHomepageSection section : manifest.homepageSections) {
                for (AppHomepageTile tile : section.tiles) {
                    if (!DatasetRenameService.isAppTileReferencingDataset(tile, dataset)) continue;
                    di.modifiedAppManifest = true;
                }
            }
            for (ProjectExportOptions.IncludedDatasetData includedDataset : manifest.projectExportManifest.includedDatasetsData) {
                if (!dataset.getName().equals(includedDataset.name)) continue;
                di.modifiedAppManifest = true;
            }
            if (manifest.useAsRecipeSettings != null && Stream.concat(manifest.useAsRecipeSettings.inputRoles.stream(), manifest.useAsRecipeSettings.outputRoles.stream()).anyMatch((Predicate<AppManifest.AppUseAsRecipeSettings.RoleMapping>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$computeImpactedApp_NT$12(com.dataiku.dip.coremodel.Dataset com.dataiku.dip.coremodel.AppManifest$AppUseAsRecipeSettings$RoleMapping ), (Lcom/dataiku/dip/coremodel/AppManifest$AppUseAsRecipeSettings$RoleMapping;)Z)((Dataset)dataset))) {
                lookupAppAsRecipes = projectAppType == SerializedProject.ProjectAppType.APP_TEMPLATE;
                di.modifiedAppManifest = true;
            }
        }
        if (lookupAppAsRecipes) {
            appAsRecipeType = "App_PROJECT_" + dataset.getProjectKey();
            t = this.transactionService.beginRead();
            try {
                projects = this.projectsService.listProjectKeys();
            }
            finally {
                if (t != null) {
                    t.close();
                }
            }
            for (String project : projects) {
                t = this.transactionService.beginRead();
                try {
                    for (SerializedRecipe recipe : this.recipesDAO.listUnsafe(project)) {
                        if (!appAsRecipeType.equals(recipe.getType())) continue;
                        di.modifiedAppAsRecipes.add(new TaggableObjectsDeletionService.ImpactedRecipe(recipe.getProjectKey(), recipe.getId(), recipe.getType()));
                    }
                }
                finally {
                    if (t == null) continue;
                    t.close();
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isAppTileReferencingDataset(AppHomepageTile tile, Dataset dataset) {
        if (tile instanceof AppHomepageTile.EditAnyDatasetTile) {
            AppHomepageTile.EditAnyDatasetTile datasetTile = (AppHomepageTile.EditAnyDatasetTile)tile;
            if (dataset.getName().equals(datasetTile.datasetName)) return true;
        }
        if (tile instanceof AppHomepageTile.EditInlineDatasetTile) {
            AppHomepageTile.EditInlineDatasetTile editInlineDatasetTile = (AppHomepageTile.EditInlineDatasetTile)tile;
            if (dataset.getName().equals(editInlineDatasetTile.datasetName)) return true;
        }
        if (tile instanceof AppHomepageTile.EditFSDatasetTile) {
            AppHomepageTile.EditFSDatasetTile editFSDatasetTile = (AppHomepageTile.EditFSDatasetTile)tile;
            if (dataset.getName().equals(editFSDatasetTile.datasetName)) return true;
        }
        if (tile instanceof AppHomepageTile.EditSQLDatasetTile) {
            AppHomepageTile.EditSQLDatasetTile editSQLDatasetTile = (AppHomepageTile.EditSQLDatasetTile)tile;
            if (dataset.getName().equals(editSQLDatasetTile.datasetName)) return true;
        }
        if (tile instanceof AppHomepageTile.PropagateSchemaTile) {
            AppHomepageTile.PropagateSchemaTile propagateSchemeTile = (AppHomepageTile.PropagateSchemaTile)tile;
            if (dataset.getName().equals(propagateSchemeTile.datasetName)) return true;
        }
        if (tile instanceof AppHomepageTile.UploadDatasetSetFileTile) {
            AppHomepageTile.UploadDatasetSetFileTile uploadDatasetSetFileTile = (AppHomepageTile.UploadDatasetSetFileTile)tile;
            if (dataset.getName().equals(uploadDatasetSetFileTile.datasetName)) return true;
        }
        if (!(tile instanceof AppHomepageTile.DownloadDatasetTile)) return false;
        AppHomepageTile.DownloadDatasetTile downloadDatasetTile = (AppHomepageTile.DownloadDatasetTile)tile;
        if (!dataset.getName().equals(downloadDatasetTile.datasetName)) return false;
        return true;
    }

    private Set<String> computeImpactedProjects(Dataset dataset) throws IOException {
        HashSet<String> res = new HashSet<String>();
        Set<String> exposedProjects = this.projectsService.getMandatoryUnsafe((String)dataset.getProjectKey()).exposedObjects.getProjectsExposedTo(ITaggingService.TaggableType.DATASET, dataset.getName());
        for (String project : exposedProjects) {
            if (!this.projectsService.projectExists(project)) continue;
            res.add(project);
        }
        res.add(dataset.getProjectKey());
        return res;
    }

    private void computeImpactedScenarios(Dataset dataset, Set<String> impactedProjects, Set<TaggableObjectsDeletionService.ImpactedScenario> modifiedScenarios, Set<TaggableObjectsDeletionService.ImpactedScenario> bestEffortAutomaticallyChangedScenarios) throws IOException {
        for (String project : impactedProjects) {
            for (Scenario scenario : this.scenariosService.listUnsafe(project)) {
                if (scenario == null) continue;
                this.computeImpactedScenario(scenario, dataset, modifiedScenarios, bestEffortAutomaticallyChangedScenarios);
            }
        }
    }

    private void computeImpactedScenario(Scenario scenario, Dataset dataset, Set<TaggableObjectsDeletionService.ImpactedScenario> modifiedScenarios, Set<TaggableObjectsDeletionService.ImpactedScenario> bestEffortAutomaticallyChangedScenarios) throws IOException {
        StepParams stepParams;
        StepBasedScenarioRunner.StepBasedScenarioParams params;
        TaggableObjectsDeletionService.ImpactedScenario impactedScenario = new TaggableObjectsDeletionService.ImpactedScenario(scenario.getProjectKey(), scenario.getId(), scenario.getName());
        if (scenario.getType().equals(CustomPythonScenarioRunner.META.getType())) {
            String payload = this.scenariosService.getPayload(scenario.getProjectKey(), scenario.getId(), "py");
            PythonCodeRenamer renamer = new PythonCodeRenamer(scenario.projectKey, dataset.getLoc());
            if (renamer.requiresRenaming(payload)) {
                bestEffortAutomaticallyChangedScenarios.add(impactedScenario);
                return;
            }
        } else if (scenario.getType().equals(StepBasedScenarioRunner.META.getType())) {
            params = scenario.getParamsAs(StepBasedScenarioRunner.StepBasedScenarioParams.class);
            for (Step step : params.getSteps()) {
                if (step.params instanceof CustomPythonStepRunner.CustomPythonStepParams) {
                    stepParams = step.getParamsAs(CustomPythonStepRunner.CustomPythonStepParams.class);
                    PythonCodeRenamer renamer = new PythonCodeRenamer(scenario.projectKey, dataset.getLoc());
                    if (!renamer.requiresRenaming(((CustomPythonStepRunner.CustomPythonStepParams)stepParams).script)) continue;
                    bestEffortAutomaticallyChangedScenarios.add(impactedScenario);
                    return;
                }
                if (step.params instanceof SendReportStepRunner.SendReportStepParams) {
                    stepParams = step.getParamsAs(SendReportStepRunner.SendReportStepParams.class);
                    if (!(((SendReportStepRunner.SendReportStepParams)stepParams).messaging.configuration instanceof DatasetScenarioIntegrationHandler.DatasetMessagingConfiguration)) continue;
                    DatasetScenarioIntegrationHandler.DatasetMessagingConfiguration configuration = ((SendReportStepRunner.SendReportStepParams)stepParams).messaging.getConfigurationAs(DatasetScenarioIntegrationHandler.DatasetMessagingConfiguration.class);
                    if (!dataset.getProjectKey().equals(configuration.projectKey) || !dataset.getName().equals(configuration.datasetName)) continue;
                    modifiedScenarios.add(impactedScenario);
                    return;
                }
                if (!(step.params instanceof FlowTestStepRunner.FlowTestStepParams)) continue;
                stepParams = step.getParamsAs(FlowTestStepRunner.FlowTestStepParams.class);
                String datasetSmartName = dataset.getSmartName(scenario.projectKey);
                ((FlowTestStepRunner.FlowTestStepParams)stepParams).getSwaps().forEach(swap -> {
                    if (Objects.equals(datasetSmartName, swap.sourceSmartName) || Objects.equals(datasetSmartName, swap.targetSmartName)) {
                        modifiedScenarios.add(impactedScenario);
                    }
                });
                ((FlowTestStepRunner.FlowTestStepParams)stepParams).getCompares().forEach(compare -> {
                    if (Objects.equals(datasetSmartName, compare.expectedSmartName) || Objects.equals(datasetSmartName, compare.resultSmartName)) {
                        modifiedScenarios.add(impactedScenario);
                    }
                });
            }
        }
        if (scenario.getType().equals(StepBasedScenarioRunner.META.getType())) {
            params = scenario.getParamsAs(StepBasedScenarioRunner.StepBasedScenarioParams.class);
            for (Step step : params.getSteps()) {
                if (!(step.params instanceof SchemaPropagationStepRunner.SchemaPropagationStepParams)) continue;
                stepParams = (SchemaPropagationStepRunner.SchemaPropagationStepParams)step.getParams();
                if (!dataset.getName().equals(((SchemaPropagationStepRunner.SchemaPropagationStepParams)stepParams).options.datasetName)) continue;
                modifiedScenarios.add(impactedScenario);
                return;
            }
        }
        for (Trigger trigger : scenario.triggers) {
            if (!DatasetModifiedTriggerRunner.META.getType().equals(trigger.getType())) continue;
            DatasetModifiedTriggerRunner.DatasetModifiedTriggerParams params2 = trigger.getParamsAs(DatasetModifiedTriggerRunner.DatasetModifiedTriggerParams.class);
            for (FlowComputableSpecification watch : params2.watches) {
                if ((watch.projectKey != null || !dataset.getProjectKey().equals(scenario.projectKey)) && !dataset.getProjectKey().equals(watch.projectKey) || !dataset.getName().equals(watch.itemId)) continue;
                modifiedScenarios.add(impactedScenario);
                return;
            }
        }
        for (ScenarioReporter reporter : scenario.reporters) {
            if (!(reporter.getMessaging().getConfiguration() instanceof DatasetScenarioIntegrationHandler.DatasetMessagingConfiguration)) continue;
            DatasetScenarioIntegrationHandler.DatasetMessagingConfiguration configuration = reporter.getMessaging().getConfigurationAs(DatasetScenarioIntegrationHandler.DatasetMessagingConfiguration.class);
            if (!dataset.getProjectKey().equals(configuration.projectKey) || !dataset.getName().equals(configuration.datasetName)) continue;
            modifiedScenarios.add(impactedScenario);
            return;
        }
        if (this.scenariosService.usesSource(scenario, dataset.getProjectKey(), ITaggingService.TaggableType.DATASET, dataset.getName()) && !bestEffortAutomaticallyChangedScenarios.contains(impactedScenario)) {
            modifiedScenarios.add(impactedScenario);
        }
    }

    private void computeImpactedLabelingTasks(Dataset dataset, Set<String> projects, List<TaggableObjectsDeletionService.ImpactedLabelingTask> modifiedLabelingTasks) throws IOException {
        for (String project : projects) {
            ProjectFlowGraph graph = this.graphService.getProjectGraphUnsafe(project);
            FlowDataset fds = (FlowDataset)graph.datasets.get(dataset.getFullName());
            if (fds == null) continue;
            Stream.concat(fds.getPredecessors().stream(), fds.getSuccessors().stream()).filter(FlowLabelingTask.class::isInstance).map(FlowLabelingTask.class::cast).map(labelingTask -> new TaggableObjectsDeletionService.ImpactedLabelingTask(labelingTask.getProjectKey(), labelingTask.getId(), labelingTask.getName())).forEach(modifiedLabelingTasks::add);
        }
    }

    private void computeImpactedRecipes(Dataset dataset, Set<String> projects, List<TaggableObjectsDeletionService.ImpactedRecipe> automaticallyChangedRecipes, List<TaggableObjectsDeletionService.ImpactedRecipe> bestEffortAutomaticallyChangedRecipes, List<TaggableObjectsDeletionService.ImpactedRecipe> manuallyChangedRecipes) throws IOException {
        for (String project : projects) {
            this.computeImpactedRecipes(project, dataset, automaticallyChangedRecipes, bestEffortAutomaticallyChangedRecipes, manuallyChangedRecipes);
        }
    }

    private void computeImpactedRecipes(String projectKey, Dataset dataset, List<TaggableObjectsDeletionService.ImpactedRecipe> automaticallyChangedRecipes, List<TaggableObjectsDeletionService.ImpactedRecipe> bestEffortAutomaticallyChangedRecipes, List<TaggableObjectsDeletionService.ImpactedRecipe> manuallyChangedRecipes) throws IOException {
        ProjectFlowGraph graph = this.graphService.getProjectGraphUnsafe(projectKey);
        FlowDataset fds = (FlowDataset)graph.datasets.get(dataset.getFullName());
        Set ioNodes = fds == null ? Collections.emptySet() : Stream.concat(fds.getPredecessors().stream(), fds.getSuccessors().stream()).collect(Collectors.toSet());
        for (FlowRecipe recipe : graph.recipes) {
            List<CodeRenamer> connectedNodeCodeRenamers = Arrays.asList(new PythonCodeRenamer(recipe.getProjectKey(), dataset.getLoc()), new SqlCodeRenamer(dataset.getSmartName(recipe.getProjectKey())), new RCodeRenamer(recipe.getProjectKey(), dataset.getProjectKey(), dataset.getName()));
            List<CodeRenamer> unconnectedNodeCodeRenamers = Arrays.asList(new PythonCodeRenamer(recipe.getProjectKey(), dataset.getLoc()), new RCodeRenamer(recipe.getProjectKey(), dataset.getProjectKey(), dataset.getName()));
            SerializedRecipe sr = recipe.getModel();
            TaggableObjectsDeletionService.ImpactedRecipe impactedRecipe = new TaggableObjectsDeletionService.ImpactedRecipe(recipe.getProjectKey(), recipe.getName(), sr.type);
            if (ioNodes.contains(recipe)) {
                if (ShakerRecipeMeta.META.getType().equals(sr.type) && (sr.getInput("scriptDeps", dataset.getSmartName(projectKey)) != null || sr.getInput("scriptDeps", dataset.getFullName()) != null)) {
                    automaticallyChangedRecipes.add(impactedRecipe);
                    continue;
                }
                if (ShellScriptRecipeMeta.META.getType().equals(sr.type) || connectedNodeCodeRenamers.stream().anyMatch(renamer -> renamer.getRecipeTypes().contains(sr.type))) {
                    bestEffortAutomaticallyChangedRecipes.add(impactedRecipe);
                    continue;
                }
                if (!RecipeRegistry.getMeta((String)sr.type).getCategoryFlags().isUserCode) {
                    automaticallyChangedRecipes.add(impactedRecipe);
                    continue;
                }
                manuallyChangedRecipes.add(impactedRecipe);
                continue;
            }
            String payload = this.recipesDAO.getPayloadOrNull(projectKey, recipe.getName());
            if (payload == null || !unconnectedNodeCodeRenamers.stream().anyMatch(renamer -> renamer.getRecipeTypes().contains(sr.type) && renamer.requiresRenaming(payload))) continue;
            bestEffortAutomaticallyChangedRecipes.add(impactedRecipe);
        }
    }

    private void computeImpactedDatasets(Dataset dataset, Set<String> projects, List<TaggableObjectsDeletionService.ImpactedDataset> modifiedDatasets) throws IOException {
        for (String project : projects) {
            this.computeImpactedDatasets(project, dataset, modifiedDatasets);
        }
    }

    private void computeImpactedDatasets(String projectKey, Dataset dataset, List<TaggableObjectsDeletionService.ImpactedDataset> modifiedDatasets) throws IOException {
        ProjectFlowGraph graph = this.graphService.getProjectGraphUnsafe(projectKey);
        FlowDataset fds = (FlowDataset)graph.datasets.get(dataset.getFullName());
        HashSet<? extends GraphNode> ioNodes = fds == null ? Collections.emptySet() : new HashSet<GraphNode>(fds.getSuccessors());
        for (FlowImplicitRecipe recipe : graph.implicitRecipes) {
            if (!ioNodes.contains(recipe)) continue;
            AnyLoc datasetLoc = AnyLoc.resolveSmart(recipe.getProjectKey(), recipe.getSuccessor().getFullId());
            TaggableObjectsDeletionService.ImpactedDataset impactedDataset = new TaggableObjectsDeletionService.ImpactedDataset(recipe.getProjectKey(), datasetLoc.getId(), recipe.getDatasetType());
            modifiedDatasets.add(impactedDataset);
        }
    }

    private static /* synthetic */ boolean lambda$computeImpactedApp_NT$12(Dataset dataset, AppManifest.AppUseAsRecipeSettings.RoleMapping role) {
        return dataset.getName().equals(role.objectId);
    }

    public static class RenamingImpact {
        public List<TaggableObjectsDeletionService.ImpactedRecipe> automaticallyChangedRecipes = new ArrayList<TaggableObjectsDeletionService.ImpactedRecipe>();
        public List<TaggableObjectsDeletionService.ImpactedRecipe> bestEffortAutomaticallyChangedRecipes = new ArrayList<TaggableObjectsDeletionService.ImpactedRecipe>();
        public List<TaggableObjectsDeletionService.ImpactedRecipe> manuallyChangedRecipes = new ArrayList<TaggableObjectsDeletionService.ImpactedRecipe>();
        public List<TaggableObjectsDeletionService.ImpactedAnalysis> modifiedAnalyses = new ArrayList<TaggableObjectsDeletionService.ImpactedAnalysis>();
        public List<TaggableObjectsDeletionService.ImpactedAnalysis> modifiedAnalysesWithJoin = new ArrayList<TaggableObjectsDeletionService.ImpactedAnalysis>();
        public List<TaggableObjectsDeletionService.ImpactedWorksheet> modifiedWorksheets = new ArrayList<TaggableObjectsDeletionService.ImpactedWorksheet>();
        public Set<TaggableObjectsDeletionService.ImpactedInsight> modifiedInsights = new HashSet<TaggableObjectsDeletionService.ImpactedInsight>();
        public Set<TaggableObjectsDeletionService.ImpactedScenario> bestEffortAutomaticallyChangedScenarios = new HashSet<TaggableObjectsDeletionService.ImpactedScenario>();
        public Set<TaggableObjectsDeletionService.ImpactedScenario> modifiedScenarios = new HashSet<TaggableObjectsDeletionService.ImpactedScenario>();
        public Set<TaggableObjectsDeletionService.ImpactedZone> modifiedZones = new HashSet<TaggableObjectsDeletionService.ImpactedZone>();
        public Set<TaggableObjectsDeletionService.ImpactedWikiArticle> modifiedWikiArticle = new HashSet<TaggableObjectsDeletionService.ImpactedWikiArticle>();
        public Set<TaggableObjectsDeletionService.ImpactedNotebook> modifiedNotebooks = new HashSet<TaggableObjectsDeletionService.ImpactedNotebook>();
        public Set<TaggableObjectsDeletionService.ImpactedNotebook> modifiedLinkedNotebooks = new HashSet<TaggableObjectsDeletionService.ImpactedNotebook>();
        public Set<TaggableObjectsDeletionService.ImpactedNotebook> manuallyChangedNotebooks = new HashSet<TaggableObjectsDeletionService.ImpactedNotebook>();
        public Set<TaggableObjectsDeletionService.ImpactedWebApp> modifiedWebApps = new HashSet<TaggableObjectsDeletionService.ImpactedWebApp>();
        public Set<String> modifiedWorkspaces = new HashSet<String>();
        public Set<String> modifiedProjects = new HashSet<String>();
        public List<TaggableObjectsDeletionService.ImpactedLabelingTask> modifiedLabelingTasks = new ArrayList<TaggableObjectsDeletionService.ImpactedLabelingTask>();
        public Set<TaggableObjectsDeletionService.ImpactedReport> modifiedReports = new HashSet<TaggableObjectsDeletionService.ImpactedReport>();
        public boolean modifiedAppManifest;
        public Set<TaggableObjectsDeletionService.ImpactedRecipe> modifiedAppAsRecipes = new HashSet<TaggableObjectsDeletionService.ImpactedRecipe>();
        public Set<String> modifiedDataCollections = new HashSet<String>();
        public List<TaggableObjectsDeletionService.ImpactedDataset> modifiedDatasets = new ArrayList<TaggableObjectsDeletionService.ImpactedDataset>();
        public List<TaggableObjectsDeletionService.ImpactedDataQualityRule> modifiedDqRules = new ArrayList<TaggableObjectsDeletionService.ImpactedDataQualityRule>();
        public Set<ImpactedAgent> modifiedAgents = new HashSet<ImpactedAgent>();
        public Set<ImpactedAgentTool> modifiedAgentTools = new HashSet<ImpactedAgentTool>();
        public boolean clearedDataQuality;
        public boolean clearedBasicMetrics;
        public boolean clearedNonBasicMetrics;
    }

    public record ImpactedAgent(String projectKey, String agentId, String name) {
    }

    public record ImpactedAgentTool(String projectKey, String toolId, String name) {
    }

    public static class PartitionableResolver {
        @Autowired
        private DatasetAccessService datasetAccessService;
        @Autowired
        private KernelsManagedFolderService managedFoldersService;
        @Autowired
        private SavedModelsDAO savedModelsDAO;
        @Autowired
        private ModelEvaluationStoresDAO modelEvaluationStoresDAO;

        public PartitionableResolver() {
            SpringUtils.getInstance().autowire((Object)this);
        }

        private Partitionable resolvePartitionable(String projectKey, String elementId) throws IOException {
            Partitionable output = this.datasetAccessService.getOrNull(projectKey, elementId);
            if (output == null && (output = this.managedFoldersService.getOrNull(projectKey, elementId)) == null && (output = (Partitionable)this.savedModelsDAO.getOrNull(projectKey, elementId)) == null && (output = (Partitionable)this.modelEvaluationStoresDAO.getOrNull(projectKey, elementId)) == null) {
                throw new NotFoundException("Output element not found: " + elementId);
            }
            return output;
        }

        @Nullable
        private PartitioningScheme getPartitioningSchemeOrNull(SerializedRecipe sr, String datasetName) {
            Partitionable parititionableInput = null;
            try {
                parititionableInput = this.resolvePartitionable(sr.projectKey, datasetName);
            }
            catch (IOException e) {
                logger.warn((Object)"Could not get partitioning info on dataset for a renaming operation", (Throwable)e);
            }
            PartitioningScheme partitionSchema = parititionableInput == null ? null : parititionableInput.getPartitioningSchema();
            return partitionSchema;
        }
    }
}

