/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.backend;

import com.dataiku.dip.server.notifications.MarkupFormatter;
import com.dataiku.dip.server.notifications.backend.BackendEvent;
import com.dataiku.dip.server.notifications.backend.EventWithHumanReadableString;
import com.dataiku.dip.server.notifications.backend.UserEvent;
import java.util.Objects;

public class LogoutEvent
extends BackendEvent
implements UserEvent,
EventWithHumanReadableString {
    public static final String NAME = "logout";
    public final String user;
    public final String userDisplayName;

    LogoutEvent(String user, String userDisplayName) {
        this.user = user;
        this.userDisplayName = userDisplayName;
    }

    public static LogoutEvent withUsername(String username, String displayName) {
        return new LogoutEvent(username, displayName);
    }

    public String getName() {
        return NAME;
    }

    @Override
    public String getUserLogin() {
        return this.user;
    }

    @Override
    public String toHumanReadableString(MarkupFormatter markup) {
        return String.format("%s just logged-out", markup.user(this.user, this.userDisplayName));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogoutEvent that = (LogoutEvent)o;
        return Objects.equals(this.user, that.user) && Objects.equals(this.userDisplayName, that.userDisplayName);
    }

    public int hashCode() {
        return Objects.hash(this.user, this.userDisplayName);
    }
}

