/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.emails;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.requestcenter.Request;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.HrefContext;
import com.dataiku.dip.server.notifications.VariableLookup;
import com.dataiku.dip.server.notifications.backend.PluginRequestGrantedEvent;
import com.dataiku.dip.server.notifications.emails.AbstractPluginRequestEmailBuilder;
import com.dataiku.dip.server.notifications.emails.MessageContentBuilder;
import com.dataiku.dip.server.notifications.emails.TemplatedContent;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class PluginRequestGrantedEmailBuilder
extends AbstractPluginRequestEmailBuilder<PluginRequestGrantedEvent> {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private GeneralSettingsService generalSettingsService;
    protected static final Logger logger = Logger.getLogger((String)"dku.notifications.plugin.request.granted");

    public PluginRequestGrantedEmailBuilder() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    protected String makeSubject(PluginRequestGrantedEvent evt, PublicUser usr, String displayedPluginName) {
        String requestTypeLabel = this.getRequestTypeLabel(evt);
        return "Plugin " + displayedPluginName + " has been " + requestTypeLabel;
    }

    @Override
    protected String getRequestTypeLabel(PluginRequestGrantedEvent evt) {
        return switch (evt.getRequestType()) {
            case Request.RequestType.INSTALL_PLUGIN -> "installed";
            case Request.RequestType.UPDATE_PLUGIN -> "updated";
            default -> throw new IllegalArgumentException("Invalid request type for plugin request");
        };
    }

    @Override
    protected String makeBody(PluginRequestGrantedEvent evt, PublicUser usr, String objectDisplayName) throws IOException, TemplateException {
        GeneralSettingsDAO.GeneralSettings settings;
        File templateFile = ApplicationConfigurator.getResourceFile((String[])new String[]{"notifications", "plugin-request-email.ftl"});
        VariableLookup lookup = new VariableLookup();
        try (Transaction ignored = this.transactionService.beginRead();){
            settings = this.generalSettingsService.read();
        }
        lookup.addVariable("isRequestEmail", false);
        lookup.addVariable("studioExternalUrl", StringUtils.isBlank((String)settings.studioExternalUrl) ? null : settings.studioExternalUrl);
        lookup.addVariable("emailPreferencesLink", settings.studioExternalUrl + "/profile/");
        lookup.addVariable("title", "The plugin you requested has been " + this.getRequestTypeLabel(evt));
        HrefContext href = new HrefContext(settings.studioExternalUrl);
        lookup.addVariable("objectLink", href.pluginSummary(evt.getObjectId()));
        lookup.addVariable("objectName", objectDisplayName);
        lookup.addVariable("iconPath", "bird.png");
        MessageContentBuilder.ExpandedTemplate expandedTemplate = new MessageContentBuilder(lookup).buildMessage(new TemplatedContent(), templateFile);
        return expandedTemplate.message;
    }
}

