/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.scheduler.ScenarioThread;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.scenarios.ScenarioRun;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunKey;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ScenarioRunsService {
    private Map<ScenarioRunKey, ScenarioThread> activeScenarioRuns = Maps.newHashMap();

    public synchronized void onScenarioRunStart(ScenarioThread scenarioThread) {
        ScenarioRun scenarioRun = scenarioThread.getScenarioRun();
        this.activeScenarioRuns.put(scenarioRun, scenarioThread);
    }

    public synchronized void onScenarioRunCompleteGetQueuedTriggers(ScenarioRunKey scenarioRunKey) {
        this.activeScenarioRuns.remove(scenarioRunKey);
    }

    public synchronized ScenarioRun getScenarioRun(ScenarioRunKey scenarioRunKey) {
        ScenarioThread scenarioThread = this.getScenarioThread(scenarioRunKey);
        return scenarioThread == null ? null : scenarioThread.getScenarioRun();
    }

    public synchronized ScenarioThread getScenarioThread(ScenarioRunKey scenarioRunKey) {
        return this.activeScenarioRuns.get(scenarioRunKey);
    }

    public synchronized ScenarioThread getMostRecentScenarioRun(Scenario scenario) {
        ArrayList running = Lists.newArrayList();
        for (Map.Entry<ScenarioRunKey, ScenarioThread> e : this.activeScenarioRuns.entrySet()) {
            Scenario runningScenario = e.getKey().getScenario();
            if (!runningScenario.getProjectKey().equals(scenario.getProjectKey()) || !runningScenario.getId().equals(scenario.getId())) continue;
            running.add(e.getValue());
        }
        if (running.size() == 0) {
            return null;
        }
        Collections.sort(running, new Comparator<ScenarioThread>(){

            @Override
            public int compare(ScenarioThread a, ScenarioThread b) {
                return -a.getScenarioRun().getRunId().compareTo(b.getScenarioRun().getRunId());
            }
        });
        return (ScenarioThread)((Object)running.get(0));
    }

    public synchronized boolean isRunning(Scenario scenario) {
        for (Map.Entry<ScenarioRunKey, ScenarioThread> e : this.activeScenarioRuns.entrySet()) {
            Scenario runningScenario = e.getKey().getScenario();
            if (!runningScenario.getProjectKey().equals(scenario.getProjectKey()) || !runningScenario.getId().equals(scenario.getId())) continue;
            return true;
        }
        return false;
    }

    public synchronized Map<String, List<ScenarioRun>> getAllClustersUsages() {
        HashMap usages = Maps.newHashMap();
        for (ScenarioThread scenarioThread : this.activeScenarioRuns.values()) {
            ScenarioRun scenarioRun = scenarioThread.getScenarioRun();
            for (SimpleKeyValue usage : scenarioRun.getClustersUsed()) {
                String clusterId = usage.value;
                if (!usages.containsKey(clusterId)) {
                    usages.put(clusterId, new ArrayList());
                }
                ((List)usages.get(clusterId)).add(scenarioRun);
            }
        }
        return usages;
    }

    public synchronized List<ScenarioRun> getAllClusterUsages(String clusterId) {
        ArrayList usages = Lists.newArrayList();
        for (ScenarioThread scenarioThread : this.activeScenarioRuns.values()) {
            ScenarioRun scenarioRun = scenarioThread.getScenarioRun();
            for (SimpleKeyValue usage : scenarioRun.getClustersUsed()) {
                if (!StringUtils.equals((String)clusterId, (String)usage.value)) continue;
                usages.add(scenarioRun);
            }
        }
        return usages;
    }
}

