/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.facet;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.shaker.facet.ArrayFacet;
import com.dataiku.dip.shaker.facet.CountMap;
import com.dataiku.dip.shaker.facet.FacetUtils;
import com.dataiku.dip.utils.DKUMathsUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;

public class ArrayFacetBuilder {
    /*
     * WARNING - void declaration
     */
    public ArrayFacet build(MemTable mt, FacetUtils.Sort sort, int maxResults, Column col) {
        void var10_16;
        CountMap<String> counts = new CountMap<String>();
        int missing = 0;
        int bad = 0;
        for (MemRow memRow : mt.rows) {
            if (memRow.isDeleted()) continue;
            String string = memRow.get(col);
            if (StringUtils.isBlank((String)string)) {
                ++missing;
                continue;
            }
            try {
                JSONArray arr = new JSONArray(string);
                for (int i = 0; i < arr.length(); ++i) {
                    Object o = arr.get(i);
                    if (o == null) continue;
                    counts.inc(o.toString());
                }
            }
            catch (Exception e) {
                ++bad;
            }
        }
        ArrayList<FacetUtils.FacetValue> values = new ArrayList<FacetUtils.FacetValue>();
        for (Map.Entry entry : counts) {
            FacetUtils.FacetValue fv = new FacetUtils.FacetValue();
            fv.key = (String)entry.getKey();
            fv.value = entry.getValue().intValue();
            values.add(fv);
        }
        Collections.sort(values, sort);
        ArrayFacet arrayFacet = new ArrayFacet();
        arrayFacet.totalNbValues = counts.size();
        arrayFacet.counts = new int[Math.min(counts.size(), maxResults)];
        arrayFacet.values = new String[Math.min(counts.size(), maxResults)];
        arrayFacet.percentages = new double[Math.min(counts.size(), maxResults)];
        arrayFacet.cumPercentages = new double[Math.min(counts.size(), maxResults)];
        arrayFacet.missing = mt.nrows() == 0 ? 0.0 : (double)missing / (double)mt.nrows();
        arrayFacet.totalRows = mt.nrows();
        boolean bl = false;
        for (FacetUtils.FacetValue fv : values) {
            var10_16 += fv.value;
        }
        int i = 0;
        int cur = 0;
        for (FacetUtils.FacetValue fv : values) {
            arrayFacet.values[i] = fv.key;
            arrayFacet.counts[i] = fv.value;
            arrayFacet.percentages[i] = DKUMathsUtils.safeDivide((int)fv.value, (int)var10_16);
            arrayFacet.cumPercentages[i] = DKUMathsUtils.safeDivide((int)(cur += fv.value), (int)var10_16);
            if (++i < maxResults) continue;
            break;
        }
        arrayFacet.badRows = bad;
        arrayFacet.nok = DKUMathsUtils.safeDivide((int)bad, (int)var10_16);
        return arrayFacet;
    }
}

