/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.filtering;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.frontend.model.ChartFilter;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.FilterAndFlagProcessor;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.processors.filtering.FilterAndFlagOnDate;
import com.dataiku.dip.shaker.processors.filtering.FilterAndFlagOnNumericalRange;
import com.dataiku.dip.shaker.processors.filtering.FilterAndFlagOnValue;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.text.StringMatchingMode;
import com.dataiku.dip.shaker.text.StringNormalizationMode;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class FilterAndFlagOnExplicitConditions
extends FilterAndFlagProcessor
implements Processor {
    private final Parameter parameters;
    private List<FilterAndFlagProcessor> processors = new ArrayList<FilterAndFlagProcessor>();
    public static final ProcessorMeta<FilterAndFlagOnExplicitConditions, Parameter> META_FILTER = new FilterAndFlagProcessor.FilterProcessorMeta<FilterAndFlagOnExplicitConditions, Parameter>(){

        @Override
        public String getName() {
            return "FilterOnExplicitConditions";
        }

        @Override
        public Category getCategory() {
            return Category.FILTER;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.FILTER, ProcessorTag.MATH});
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            return null;
        }

        @Override
        public FilterAndFlagOnExplicitConditions build(Parameter parameter) {
            return new FilterAndFlagOnExplicitConditions(parameter);
        }
    };

    public FilterAndFlagOnExplicitConditions(Parameter parameters) {
        if (parameters.explicitConditions == null) {
            throw new IllegalArgumentException("Explicit conditions cannot be null");
        }
        this.parameters = parameters;
    }

    @Override
    public void init() throws Exception {
        super.init();
        ArrayList<FilterAndFlagProcessor> localProcessors = new ArrayList<FilterAndFlagProcessor>(this.parameters.explicitConditions.size());
        for (ChartFilter.ExplicitCondition explicitCondition : this.parameters.explicitConditions) {
            FilterAndFlagProcessor processor = switch (explicitCondition.columnType) {
                case AxisDef.Type.ALPHANUM -> this.createAlphanumProcessor(explicitCondition);
                case AxisDef.Type.DATE -> this.createDateProcessor(explicitCondition);
                case AxisDef.Type.NUMERICAL -> this.createNumericalProcessor(explicitCondition);
                default -> throw new IllegalStateException("Unhandled explicit condition column type: " + String.valueOf((Object)explicitCondition.columnType));
            };
            if (processor == null) {
                throw new IllegalStateException("Processor for explicit condition " + String.valueOf(explicitCondition) + " is null");
            }
            processor.setColumnFactory(this.getColumnFactory());
            processor.init();
            localProcessors.add(processor);
        }
        this.processors = localProcessors;
    }

    public void postProcess() throws Exception {
    }

    @Override
    public FilterAndFlagProcessor.FilterAndFlagParams getParams() {
        return this.parameters;
    }

    @Override
    public boolean matchCell(Row row, Column column) throws Exception {
        int n = this.parameters.explicitConditions.size();
        for (int i = 0; i < n; ++i) {
            if (!Objects.equals(this.parameters.explicitConditions.get((int)i).column, column.getName())) continue;
            return this.processors.get(i).matchCell(row, column);
        }
        return false;
    }

    private FilterAndFlagOnNumericalRange.StreamImpl createNumericalProcessor(ChartFilter.ExplicitCondition explicitCondition) {
        FilterAndFlagOnNumericalRange.Parameter params = new FilterAndFlagOnNumericalRange.Parameter();
        params.columns = Collections.singletonList(explicitCondition.column);
        params.min = explicitCondition.minValue;
        params.max = explicitCondition.maxValue;
        if (params.min == null && params.max == null) {
            return null;
        }
        return new FilterAndFlagOnNumericalRange.StreamImpl(params);
    }

    private FilterAndFlagOnValue.StreamImpl createAlphanumProcessor(ChartFilter.ExplicitCondition explicitCondition) {
        FilterAndFlagOnValue.Parameter params = new FilterAndFlagOnValue.Parameter();
        String singleValue = explicitCondition.singleValue;
        List<String> values = Collections.singletonList(singleValue);
        params.columns = Collections.singletonList(explicitCondition.column);
        params.values = values;
        params.matchingMode = StringMatchingMode.FULL_STRING;
        params.normalizationMode = StringNormalizationMode.EXACT;
        params.processNullOrEmptyValues = true;
        return new FilterAndFlagOnValue.StreamImpl(params);
    }

    private FilterAndFlagOnDate createDateProcessor(ChartFilter.ExplicitCondition explicitCondition) {
        FilterAndFlagOnDate.Parameter params = new FilterAndFlagOnDate.Parameter();
        params.columns = Collections.singletonList(explicitCondition.column);
        if (explicitCondition.dateFilterType == null) {
            return null;
        }
        params.filterType = Enum.valueOf(FilterAndFlagOnDate.DateFilterType.class, explicitCondition.dateFilterType.toString());
        switch (params.filterType) {
            case RANGE: {
                Double maxDate;
                params.timezone_id = "UTC";
                Double minDate = explicitCondition.minValue;
                if (minDate != null) {
                    params.min = ISODateTimeFormat.dateHourMinuteSecondMillis().withZone(DateTimeZone.UTC).print((long)minDate.doubleValue());
                }
                if ((maxDate = explicitCondition.maxValue) != null) {
                    params.max = ISODateTimeFormat.dateHourMinuteSecondMillis().withZone(DateTimeZone.UTC).print((long)maxDate.doubleValue());
                }
                if (params.min != null || params.max != null) break;
                return null;
            }
            case PART: {
                params.part = Enum.valueOf(ChartFilter.DateFilterPart.class, explicitCondition.dateFilterPart.toString());
                String singleValue = explicitCondition.singleValue;
                if (singleValue == null) {
                    return null;
                }
                params.values = Collections.singletonList(singleValue);
                if (params.part == ChartFilter.DateFilterPart.YEAR || params.part == ChartFilter.DateFilterPart.HOUR_OF_DAY) break;
                params.values = params.values.stream().map(str -> String.valueOf(Integer.parseInt(str) + 1)).collect(Collectors.toList());
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled filter explicit condition date type: " + String.valueOf(params.filterType));
            }
        }
        return new FilterAndFlagOnDate(params);
    }

    public static class Parameter
    extends FilterAndFlagProcessor.FilterAndFlagParams
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public List<ChartFilter.ExplicitCondition> explicitConditions;
    }
}

