/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.join;

import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.shaker.processors.expr.WordType;
import com.dataiku.dip.shaker.processors.join.FuzzySearchEngine;
import com.dataiku.dip.shaker.processors.join.MemoryEquiJoiner;
import com.dataiku.dip.utils.DKULogger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class RawLevenshteinSearchEngine
extends FuzzySearchEngine {
    private final Map<String, String> originalMapping = new HashMap<String, String>();
    private final AtomicInteger totalProcessedRows = new AtomicInteger(0);
    private final AtomicInteger totalProcessedInputChars = new AtomicInteger(0);
    private final AtomicInteger totalAvoidedDistances = new AtomicInteger(0);
    private final AtomicInteger totalComputedDistances = new AtomicInteger(0);
    private final AtomicInteger totalProcessedInThreshold = new AtomicInteger(0);
    private final AtomicInteger totalMatches = new AtomicInteger(0);
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.shaker.fuzzy_join");

    public RawLevenshteinSearchEngine(MemoryEquiJoiner.Parameter params) {
        super(params);
    }

    @Override
    public void populate(String s) {
        String simplified = this.simplify(s);
        this.originalMapping.put(simplified, s);
    }

    @Override
    public void endPopulating() {
        logger.infoV("RawLevensthein engine built mappingSize=%d", new Object[]{this.originalMapping.size()});
    }

    @Override
    public String search(String search) throws InterruptedException {
        int totalMatchesLoc;
        int processedRows = this.totalProcessedRows.incrementAndGet();
        String preprocessed = this.simplify(search);
        int processedInputChars = this.totalProcessedInputChars.addAndGet(preprocessed.length());
        int minD = this.threshold + 1;
        String res = null;
        int avoidedDistances = 0;
        int computedDistances = 0;
        int processedInThreshold = 0;
        for (String s : this.originalMapping.keySet()) {
            int searchlength;
            int slength = s.length();
            if (slength - (searchlength = preprocessed.length()) > this.threshold || slength - searchlength < -this.threshold) {
                ++avoidedDistances;
                continue;
            }
            ++computedDistances;
            int d = WordType.levenshtein((String)s, (String)preprocessed);
            if (d < minD) {
                minD = d;
                res = this.originalMapping.get(s);
                ++processedInThreshold;
            }
            if (minD != 0) continue;
            return res;
        }
        int totalAvoidedDistancesLoc = this.totalAvoidedDistances.addAndGet(avoidedDistances);
        int totalComputedDistancesLoc = this.totalComputedDistances.addAndGet(computedDistances);
        int totalProcessedInThresholdLoc = this.totalProcessedInThreshold.addAndGet(processedInThreshold);
        int n = totalMatchesLoc = res != null ? this.totalMatches.incrementAndGet() : this.totalMatches.get();
        if (processedRows % 100 == 0) {
            FutureProgressState.checkInterrupt();
        }
        if (processedRows % 50 == 0) {
            logger.infoV("Raw Fuzzy report rows=%d inputChars=%d computedLD=%d avoidedLD=%d inThreshold=%d match=%d", new Object[]{processedRows, processedInputChars, totalComputedDistancesLoc, totalAvoidedDistancesLoc, totalProcessedInThresholdLoc, totalMatchesLoc});
        }
        return res;
    }
}

