/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.reshaping;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.processors.AppliesToProcessor;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.types.JSONArrayMeaning;
import com.dataiku.dip.shaker.types.JSONObjectMeaning;
import com.dataiku.dip.util.JsonUtils;
import com.dataiku.dip.utils.Pair;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NestProcessor
extends AppliesToProcessor {
    public static final ProcessorMeta<NestProcessor, Parameter> META = new AppliesToProcessor.AppliesToProcessorMeta<NestProcessor, Parameter>(){

        @Override
        public String getName() {
            return "NestProcessor";
        }

        @Override
        public String getDocPage() {
            return "object-nest";
        }

        @Override
        public Category getCategory() {
            return Category.RESHAPING;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.RESHAPING});
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.NestProcessor.HELP", "Combine N input columns into a single JSON object column.\n\n# Example\n\nInput:\n\n```\n   a       b\n   1       2\n```\nOutput:\n\n```\n   {\"a\": 1, \"b\": 2}\n```\n\n# Options\n\n**Column**\nApply the nest processor to the following:\n- A single column\n- An explicit list of columns\n- All columns matching a regex pattern\n- All columns\n\n**Output column**\nName the created output column. Cannot be left blank.");
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withGenericForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.NestProcessor.DESCRIPTION", 1.actionVerb("Nest") + " columns")).withMNESParam("outputColumn", this.translate(language, "SHAKER.PROCESSORS.DESCRIPTION.OUTPUT_COLUMN", "Output column"));
        }

        @Override
        public Object selfReport(Parameter p) {
            JsonObject out = AppliesToProcessor.selfReport(p);
            out.remove("outputColumn");
            return out;
        }

        @Override
        public NestProcessor build(Parameter parameter) throws Exception {
            return new NestProcessor(parameter);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            Parameter nestParams = (Parameter)pss.params;
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = this.getUpdatedDatasetPairLineage(nestParams, (DatasetPairLineage)previousDatasetPairLineage, nestParams.outputColumn, AppliesToProcessor.AppliesToProcessorMeta.RelationDirection.TO, true);
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };
    Parameter parameter;
    private Column outputColumn;

    public NestProcessor(Parameter parameter) {
        this.parameter = parameter;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.outputColumn = this.getParams().appliesTo == AppliesToProcessor.AppliesTo.PATTERN || this.getParams().appliesTo == AppliesToProcessor.AppliesTo.ALL ? this.getColumnFactory().column(this.parameter.outputColumn, Processor.ProcessorRole.OUTPUT_COLUMN) : this.getColumnFactory().columnAfter((String)this.parameter.columns.get(this.parameter.columns.size() - 1), this.parameter.outputColumn, Processor.ProcessorRole.OUTPUT_COLUMN);
    }

    @Override
    public void processRowForColumns(Row row, Iterable<Column> columns) throws Exception {
        JSONObject output = new JSONObject();
        for (Column col : columns) {
            String value;
            if (col.getName().equals(this.outputColumn.getName()) || (value = row.get(col)) == null) continue;
            output.put(col.getName(), this.typeValue(value));
        }
        row.put(this.outputColumn, output.toString());
    }

    private Object typeValue(String s) {
        Object typedValue;
        JSONObjectMeaning jSONObjectMeaning = new JSONObjectMeaning();
        if (jSONObjectMeaning.detects(s) > 0.0) {
            try {
                return new JSONObject(s);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        JSONArrayMeaning jSONArrayMeaning = new JSONArrayMeaning();
        if (jSONArrayMeaning.detects(s) > 0.0) {
            try {
                return new JSONArray(s);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        if ((typedValue = JsonUtils.stringToValue(s)) instanceof Double) {
            if (StringUtils.containsIgnoreCase((String)s, (String)"E") || StringUtils.containsIgnoreCase((String)s, (String)"d") || StringUtils.containsIgnoreCase((String)s, (String)"o") || StringUtils.containsIgnoreCase((String)s, (String)"h")) {
                typedValue = s;
            } else {
                try {
                    typedValue = new BigDecimal(s);
                }
                catch (NumberFormatException e) {
                    typedValue = s;
                }
            }
        } else if (typedValue instanceof Integer) {
            try {
                typedValue = Integer.parseInt(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return typedValue;
    }

    public void postProcess() throws Exception {
    }

    @Override
    public Parameter getParams() {
        return this.parameter;
    }

    public static class Parameter
    extends AppliesToProcessor.AppliesToParams {
        private static final long serialVersionUID = -1L;
        public String outputColumn;
    }
}

