/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark;

import com.dataiku.dip.coremodel.InfoMessage;

public enum SparkCodes implements InfoMessage.MessageCode
{
    ERR_SPARK_PYSPARK_CODE_FAILED_UNSPECIFIED("Pyspark code failed", InfoMessage.FixabilityCategory.UNKNOWN),
    ERR_SPARK_SCALA_CODE_FAILED_UNSPECIFIED("Scala code failed", InfoMessage.FixabilityCategory.UNKNOWN),
    ERR_SPARK_FAILED_YARN_KILLED_MEMORY("Spark failure: killed by YARN (excessive memory usage)", InfoMessage.FixabilityCategory.UNKNOWN),
    ERR_SPARK_FAILED_TASK_OOM("Spark failure: out of memory in task", InfoMessage.FixabilityCategory.UNKNOWN),
    ERR_SPARK_FAILED_DRIVER_OOM("Spark failure: out of memory in driver", InfoMessage.FixabilityCategory.UNKNOWN),
    ERR_SPARK_FAILED_CONTAINER_OOM("Spark failure: out of memory in container", InfoMessage.FixabilityCategory.UNKNOWN),
    ERR_SPARK_SQL_LEGACY_UNION_SUPPORT("Your current Spark version doesn't support UNION clause", InfoMessage.FixabilityCategory.THIRD_PARTY_SYSTEM),
    ERR_SPARK_YARN_CLUSTER_SETTING_INCOMPLETE("Your Spark settings don't define a temporary storage for yarn-cluster mode", InfoMessage.FixabilityCategory.ADMIN_SETTINGS_MISC),
    ERR_SPARK_LIVY_CONNECTION_FAILED("Failed to connect to Livy", InfoMessage.FixabilityCategory.HADOOP_INTEGRATION),
    ERR_SPARK_MISSING_KAFKA_JARS("Kafka datasource jars not present in the Spark installation", InfoMessage.FixabilityCategory.ADMIN_INSTALLATION),
    ERR_SPARK_COMMONS_LANG3_JAR_CONFLICT("Version of commons-lang3 is invalid for Spark Streaming, use 3.8+", InfoMessage.FixabilityCategory.ADMIN_INSTALLATION),
    WARN_SPARK_NON_DISTRIBUTED_READ("Performance warning: Input dataset is read in a non-distributed way", InfoMessage.FixabilityCategory.USER_CONFIG_OR_ADMIN),
    WARN_SPARK_NON_DISTRIBUTED_WRITE("Performance warning: Output dataset is written in a non-distributed way", InfoMessage.FixabilityCategory.USER_CONFIG_OR_ADMIN),
    WARN_SPARK_UDFS_MAY_BE_BROKEN("Setup warning: the image for the executors wasn't built for the code env of the driver, Python UDFs may fail.", InfoMessage.FixabilityCategory.USER_CONFIG_OR_ADMIN),
    WARN_SPARK_TASK_OOM("Some Spark tasks encountered out of memory", InfoMessage.FixabilityCategory.USER_CONFIG_OR_ADMIN),
    WARN_SPARK_TASK_DISKFULL("Some Spark tasks encountered disk space issues", InfoMessage.FixabilityCategory.USER_CONFIG_OR_ADMIN),
    WARN_SPARK_MISSING_DRIVER_TO_EXECUTOR_CONNECTIVITY("The Spark driver cannot call into the execturors", InfoMessage.FixabilityCategory.USER_CONFIG_OR_ADMIN),
    WARN_SPARK_K8S_KILLED_EXECUTORS("Some Kubernetes executors were killed. Possibly insufficient memory", InfoMessage.FixabilityCategory.USER_CONFIG_OR_ADMIN),
    WARN_SPARK_WITH_DATABRICKS_DATASET("Use SQL recipe/engine to leverage your Databricks cluster's compute resources", InfoMessage.FixabilityCategory.USER_CONFIG);

    private final String title;
    private final InfoMessage.FixabilityCategory fixability;

    private SparkCodes(String title, InfoMessage.FixabilityCategory fixability) {
        this.title = title;
        this.fixability = fixability;
    }

    public String getCode() {
        return this.name();
    }

    public String getCodeTitle() {
        return this.title;
    }

    public InfoMessage.FixabilityCategory getFixability() {
        return this.fixability;
    }
}

