/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.cluster.HadoopSettings;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.AzureConnection;
import com.dataiku.dip.connections.ConnectionWithAWSAuthCredentials;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.EC2Connection;
import com.dataiku.dip.connections.GCSConnection;
import com.dataiku.dip.connections.HDFSConnection;
import com.dataiku.dip.connections.KafkaConnection;
import com.dataiku.dip.connections.SQSConnection;
import com.dataiku.dip.connections.SnowflakeConnection;
import com.dataiku.dip.dao.impl.ManualConnectionsDAO;
import com.dataiku.dip.dao.impl.ThreadLocalManualConnectionsDAO;
import com.dataiku.dip.meanings.MeaningsDAO;
import com.dataiku.dip.meanings.model.UserDefinedMeaning;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.IImpersonationResolverService;
import com.dataiku.dip.security.impersonation.NoopImpersonationResolverService;
import com.dataiku.dip.security.impersonation.ThreadLocalManualImpersonationResolverService;
import com.dataiku.dip.security.impersonation.UserImpersonationTarget;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Params;
import com.dataiku.dip.variables.HierarchicalVariablesContext;
import com.dataiku.dip.variables.ManualVariablesService;
import com.dataiku.dip.variables.ThreadLocalManualVariablesService;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SparkJobExecEnv {
    public static final String SPARK_OVERRIDE_PREFIX = "dku.spark.override.";
    public Map<String, DSSConnection> connections = new HashMap<String, DSSConnection>();
    Map<String, String> dipProperties;
    HierarchicalVariablesContext global;
    Map<String, HierarchicalVariablesContext> perProject = new HashMap<String, HierarchicalVariablesContext>();
    private String dssUserLogin = "";
    public MeaningsDAO.MeaningsList meaningsList = new MeaningsDAO.MeaningsList();
    public List<AbstractSQLConnection.CustomDatabaseProperty> additionalSparkConf = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
    public ConnectionWithAWSAuthCredentials.SerializableAWSCredential awsCredential;
    public transient Set<String> additionalLocalJars = Sets.newHashSet();
    boolean impersonationEnabled;
    UserImpersonationTarget impersonatedUser;
    HadoopSettings hadoopSettings;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.spark.exec");

    public static boolean allowInsecureAccessToConnection() {
        boolean secureConnectionsEvenInSUSecurity = false;
        IImpersonationResolverService resolver = (IImpersonationResolverService)SpringUtils.getBean(IImpersonationResolverService.class);
        if (resolver.isEnabled()) {
            return false;
        }
        secureConnectionsEvenInSUSecurity = ApplicationConfigurator.getProperty((String)"security.hideConnectionsInSingleUserSecurity", (String)"false").equalsIgnoreCase("true");
        return !secureConnectionsEvenInSUSecurity;
    }

    public void fillInBackendOrJEK(Iterable<String> relevantProjects, AuthCtx authCtx, UserImpersonationTarget impersonatedUser, HadoopSettings hadoopSettings, boolean canAddAdditionalJar) throws IOException {
        this.hadoopSettings = hadoopSettings;
        if (authCtx.getAuthSource() != AuthCtx.AuthSource.NONE) {
            this.dssUserLogin = authCtx.getDSSUserForImpersonation();
        }
        this.meaningsList.meanings.addAll(this.getMeanings_autoTxn());
        try (FileInputStream fis = new FileInputStream(ApplicationConfigurator.getFile((String[])new String[]{"config", "dip.properties"}));){
            Properties config = new Properties();
            config.load(fis);
            this.dipProperties = new HashMap<String, String>((Map<String, String>)Maps.fromProperties((Properties)config));
        }
        ConnectionsDAO dao = (ConnectionsDAO)SpringUtils.getBean(ConnectionsDAO.class);
        IImpersonationResolverService resolver = (IImpersonationResolverService)SpringUtils.getBean(IImpersonationResolverService.class);
        logger.infoV("Building Spark exec env impersonationEnabled=%s user=%s auth=%s", new Object[]{resolver.isEnabled(), impersonatedUser, authCtx.getAuthSource().name()});
        if (resolver.isEnabled()) {
            this.impersonationEnabled = true;
            this.impersonatedUser = impersonatedUser;
        }
        boolean insecureAccessToConnection = SparkJobExecEnv.allowInsecureAccessToConnection();
        for (Map.Entry<String, DSSConnection> conn : dao.list().entrySet()) {
            if (!insecureAccessToConnection && !conn.getValue().detailsReadableBy(authCtx)) continue;
            try {
                Set postgresJars;
                DSSConnection decryptedConn;
                if (conn.getValue().getType().equals("HDFS")) {
                    logger.infoV("Possibly adding details for connection type=%s name=%s", new Object[]{conn.getValue().getType(), conn.getKey()});
                    decryptedConn = (HDFSConnection)JSON.deepCopy((Object)((HDFSConnection)conn.getValue()));
                    this.connections.put(conn.getKey(), decryptedConn);
                    continue;
                }
                if (conn.getValue().getType().equals("EC2")) {
                    logger.infoV("Possibly adding details for connection type=%s name=%s", new Object[]{conn.getValue().getType(), conn.getKey()});
                    decryptedConn = (EC2Connection)JSON.deepCopy((Object)((EC2Connection)conn.getValue()));
                    if (decryptedConn.getProxySettings() != null && decryptedConn.getProxySettings().hasProxy()) {
                        logger.info((Object)"Proxy access not supported in the Spark driver -> don't put the connection");
                        continue;
                    }
                    this.connections.put(conn.getKey(), decryptedConn);
                    continue;
                }
                if (conn.getValue().getType().equals("Azure")) {
                    logger.infoV("Possibly adding details for connection type=%s name=%s", new Object[]{conn.getValue().getType(), conn.getKey()});
                    decryptedConn = (AzureConnection)JSON.deepCopy((Object)((AzureConnection)conn.getValue()));
                    if (decryptedConn.getProxySettings() != null && decryptedConn.getProxySettings().hasProxy()) {
                        logger.info((Object)"Proxy access not supported in the Spark driver -> don't put the connection");
                        continue;
                    }
                    this.connections.put(conn.getKey(), decryptedConn);
                    continue;
                }
                if (conn.getValue().getType().equals("GCS")) {
                    logger.infoV("Possibly adding details for connection type=%s name=%s", new Object[]{conn.getValue().getType(), conn.getKey()});
                    decryptedConn = (GCSConnection)JSON.deepCopy((Object)((GCSConnection)conn.getValue()));
                    if (decryptedConn.getProxySettings() != null && decryptedConn.getProxySettings().hasProxy()) {
                        logger.info((Object)"Proxy access not supported in the Spark driver -> don't put the connection");
                        continue;
                    }
                    this.connections.put(conn.getKey(), decryptedConn);
                    continue;
                }
                if ("Snowflake".equals(conn.getValue().getType())) {
                    logger.infoV("Possibly adding details for connection type=%s name=%s", new Object[]{conn.getValue().getType(), conn.getKey()});
                    decryptedConn = (SnowflakeConnection)JSON.deepCopy((Object)((SnowflakeConnection)conn.getValue()));
                    if (decryptedConn.getProxySettings() != null && decryptedConn.getProxySettings().hasProxy()) {
                        logger.info((Object)"Proxy access not supported in the Spark driver -> don't put the connection");
                        continue;
                    }
                    this.connections.put(conn.getKey(), decryptedConn);
                    continue;
                }
                if (conn.getValue().getType().equals("Kafka")) {
                    logger.infoV("Possibly adding details for connection type=%s name=%s", new Object[]{conn.getValue().getType(), conn.getKey()});
                    decryptedConn = (KafkaConnection)JSON.deepCopy((Object)((KafkaConnection)conn.getValue()));
                    this.connections.put(conn.getKey(), decryptedConn);
                    continue;
                }
                if (conn.getValue().getType().equals("SQS")) {
                    logger.infoV("Possibly adding details for connection type=%s name=%s", new Object[]{conn.getValue().getType(), conn.getKey()});
                    decryptedConn = (SQSConnection)JSON.deepCopy((Object)((SQSConnection)conn.getValue()));
                    if (decryptedConn.getProxySettings() != null && decryptedConn.getProxySettings().hasProxy()) {
                        logger.info((Object)"Proxy access not supported in the Spark driver -> don't put the connection");
                        continue;
                    }
                    this.connections.put(conn.getKey(), decryptedConn);
                    continue;
                }
                if (conn.getValue().getType().equals("Filesystem")) {
                    logger.infoV("Possibly adding details for connection type=%s name=%s", new Object[]{conn.getValue().getType(), conn.getKey()});
                    this.connections.put(conn.getKey(), conn.getValue());
                    continue;
                }
                if (!(conn.getValue() instanceof AbstractSQLConnection)) continue;
                logger.infoV("Possibly adding details for connection type=%s name=%s", new Object[]{conn.getValue().getType(), conn.getKey()});
                decryptedConn = (AbstractSQLConnection)JSON.deepCopy((Object)((AbstractSQLConnection)conn.getValue()));
                if (decryptedConn.getProxySettings() != null && decryptedConn.getProxySettings().hasProxy()) {
                    logger.info((Object)"Proxy access not supported in the Spark driver -> don't put the connection");
                    continue;
                }
                ArrayList jarsToAdd = Lists.newArrayList();
                try {
                    List<String> driverJars = ((AbstractSQLConnection)decryptedConn).getKnownDriverJars();
                    if (driverJars.size() > 0) {
                        logger.info((Object)("Got " + driverJars.size() + " jars to add for the driver of " + conn.getKey()));
                    }
                    jarsToAdd.addAll(driverJars);
                }
                catch (Exception e) {
                    logger.warn((Object)"Unable to list jars to use for drivers in spark", (Throwable)e);
                }
                if (!jarsToAdd.isEmpty() && !canAddAdditionalJar) {
                    logger.debug((Object)"Connection wants to pass jars for drivers but isn't allowed to -> don't put the connection");
                    continue;
                }
                Pattern postgresJarName = Pattern.compile(".*/postgresql\\-([0-9]+\\.[0-9]+)[\\.\\-].*.jar");
                if (jarsToAdd.stream().anyMatch(f -> postgresJarName.matcher((CharSequence)f).matches()) && (postgresJars = Stream.concat(this.additionalLocalJars.stream(), jarsToAdd.stream()).filter(f -> postgresJarName.matcher((CharSequence)f).matches()).collect(Collectors.toSet())).size() > 1) {
                    logger.debug((Object)("Connection would add potentially incompatible postgresql drivers, skipping. Jars: " + postgresJars.stream().collect(Collectors.joining(", "))));
                    continue;
                }
                this.additionalLocalJars.addAll(jarsToAdd);
                this.connections.put(conn.getKey(), decryptedConn);
            }
            catch (IllegalArgumentException e) {
                if (ExceptionUtils.hasCauseWithMessage((Throwable)e, (String)"Failed to decrypt")) {
                    logger.warn((Object)("Could not resolve connection details for connection " + conn.getKey() + ", it won't be available for fast access, because of a wrongfully encrypted password: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                    continue;
                }
                logger.warn((Object)("Could not resolve connection details for connection " + conn.getKey() + ", it won't be available for fast access"), (Throwable)e);
            }
            catch (UnsupportedOperationException e) {
                logger.warn((Object)("Could not resolve connection details for connection " + conn.getKey() + ", it won't be available for fast access: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            }
            catch (SecurityException e) {
                logger.warn((Object)("Could not resolve connection details for connection " + conn.getKey() + ", it won't be available for fast access: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            }
            catch (Exception e) {
                logger.warn((Object)("Could not resolve connection details for connection " + conn.getKey() + ", it won't be available for fast access"), (Throwable)e);
            }
        }
        logger.debug((Object)"End of connections resolution");
        VariablesService vs = (VariablesService)SpringUtils.getBean(VariablesService.class);
        this.global = (HierarchicalVariablesContext)vs.getForGlobal();
        for (String project : relevantProjects) {
            if ("__DKU_ANY_PROJECT__".equals(project)) continue;
            this.perProject.put(project, (HierarchicalVariablesContext)vs.getForProject(project));
        }
    }

    private List<UserDefinedMeaning> getMeanings_autoTxn() throws IOException {
        if (TransactionContext.hasAttachedTransaction()) {
            return this.getMeanings_T();
        }
        TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
        try (Transaction t = transactionService.beginRead();){
            List<UserDefinedMeaning> list = this.getMeanings_T();
            return list;
        }
    }

    private List<UserDefinedMeaning> getMeanings_T() throws IOException {
        MeaningsDAO meaningsDAO = (MeaningsDAO)SpringUtils.getBean(MeaningsDAO.class);
        return meaningsDAO.listUnsafe();
    }

    private void setForcedDipProperties() {
        if (ApplicationConfigurator.getRunsWithoutConfig()) {
            HashMap<String, String> properties = new HashMap<String, String>(this.dipProperties);
            HashMap<String, String> overridenProperties = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : this.dipProperties.entrySet()) {
                if (!entry.getKey().startsWith(SPARK_OVERRIDE_PREFIX)) continue;
                String keyToOverride = entry.getKey().replace(SPARK_OVERRIDE_PREFIX, "");
                logger.info((Object)String.format("Will override dip.properties '%s' with '%s'", keyToOverride, entry.getValue()));
                overridenProperties.put(keyToOverride, entry.getValue());
            }
            properties.putAll(overridenProperties);
            ApplicationConfigurator.setForcedParams((Params)new Params(properties));
        }
    }

    public void loadInDriver() {
        this.setForcedDipProperties();
        ManualConnectionsDAO driverDAO = (ManualConnectionsDAO)SpringUtils.getBean(ManualConnectionsDAO.class);
        for (Map.Entry<String, DSSConnection> conn : this.connections.entrySet()) {
            driverDAO.map.put(conn.getKey(), conn.getValue());
        }
        ManualVariablesService mvs = (ManualVariablesService)SpringUtils.getBean(ManualVariablesService.class);
        mvs.global = this.global;
        mvs.perProject = this.perProject;
        mvs.dssUserLogin = this.dssUserLogin;
        logger.infoV("Loading exec env with impersonation enabled=%s user=%s login=%s", new Object[]{this.impersonationEnabled, this.impersonatedUser, this.dssUserLogin});
        NoopImpersonationResolverService resolver = (NoopImpersonationResolverService)SpringUtils.getBean(NoopImpersonationResolverService.class);
        resolver.setSettings(this.impersonationEnabled, this.impersonatedUser);
        ClusterSelector.forceSettings(ClusterSettings.makeFromHadoopSettings(this.hadoopSettings));
    }

    public void loadInDriverMultithread() {
        logger.infoV("Loading exec env with impersonation enabled=%s user=%s login=%s", new Object[]{this.impersonationEnabled, this.impersonatedUser, this.dssUserLogin});
        this.setForcedDipProperties();
        ThreadLocalManualConnectionsDAO driverDAO = (ThreadLocalManualConnectionsDAO)SpringUtils.getBean(ThreadLocalManualConnectionsDAO.class);
        driverDAO.set(this.connections);
        ThreadLocalManualVariablesService mvs = (ThreadLocalManualVariablesService)SpringUtils.getBean(ThreadLocalManualVariablesService.class);
        mvs.setGlobalContext(this.global);
        mvs.setProjectContexts(this.perProject);
        mvs.setDSSUserLogin(this.dssUserLogin);
        ThreadLocalManualImpersonationResolverService resolver = (ThreadLocalManualImpersonationResolverService)SpringUtils.getBean(ThreadLocalManualImpersonationResolverService.class);
        resolver.setSettings(this.impersonationEnabled, this.impersonatedUser);
        ClusterSelector.forceSettingsOnCurrentThread(ClusterSettings.makeFromHadoopSettings(this.hadoopSettings));
    }
}

