/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.strings;

import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Properties;
import org.json.JSONException;
import org.json.JSONTokener;

public class ParseJson
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        Object o1;
        if (args.length >= 1 && (o1 = args[0]) != null) {
            try {
                return new JSONTokener(o1.toString()).nextValue();
            }
            catch (JSONException e) {
                return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " failed: " + e.getMessage());
            }
        }
        return null;
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.ParseJson.DOCUMENTATION", "Parses a JSON string as an array or object.").withParams("string s").withReturns("object or array").withCategory("GREL.FUNCTIONS.CATEGORY.OBJECT", "Object functions");
    }
}

