/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.commons.configuration2.interpol;

import com.dataiku.dss.shadelib.org.apache.commons.configuration2.interpol.Lookup;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.ClassUtils;
import com.dataiku.dss.shadelib.org.apache.commons.logging.Log;
import com.dataiku.dss.shadelib.org.apache.commons.logging.LogFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ConstantLookup
implements Lookup {
    private static final char FIELD_SEPRATOR = '.';
    private static final Map<String, Object> CACHE = new ConcurrentHashMap<String, Object>();
    private final Log log = LogFactory.getLog(this.getClass());

    public static void clear() {
        CACHE.clear();
    }

    protected Class<?> fetchClass(String className) throws ClassNotFoundException {
        return ClassUtils.getClass(className);
    }

    @Override
    public Object lookup(String var) {
        if (var == null) {
            return null;
        }
        return CACHE.computeIfAbsent(var, k -> {
            int fieldPos = var.lastIndexOf(46);
            if (fieldPos >= 0) {
                try {
                    return this.resolveField(var.substring(0, fieldPos), var.substring(fieldPos + 1));
                }
                catch (Exception ex) {
                    this.log.warn("Could not obtain value for variable " + var, ex);
                }
            }
            return null;
        });
    }

    protected Object resolveField(String className, String fieldName) throws Exception {
        return this.fetchClass(className).getField(fieldName).get(null);
    }
}

