/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.facet.rangeonrange;

import com.dataiku.dss.shadelib.org.apache.lucene.facet.rangeonrange.Range;
import java.util.Arrays;
import java.util.Objects;

public class LongRange
extends Range {
    public final long[] min;
    public final long[] max;

    public LongRange(String label, long minIn, boolean minInclusive, long maxIn, boolean maxInclusive) {
        super(label, 1);
        if (!minInclusive) {
            if (minIn != Long.MAX_VALUE) {
                ++minIn;
            } else {
                this.failNoMatch();
            }
        }
        if (!maxInclusive) {
            if (maxIn != Long.MIN_VALUE) {
                --maxIn;
            } else {
                this.failNoMatch();
            }
        }
        if (minIn > maxIn) {
            this.failNoMatch();
        }
        this.min = new long[]{minIn};
        this.max = new long[]{maxIn};
    }

    public LongRange(String label, long[] min2, long[] max) {
        super(label, min2.length);
        this.checkArgs(min2, max);
        this.min = min2;
        this.max = max;
    }

    public String toString() {
        return "LongRange(label: " + this.label + ", min: " + Arrays.toString(this.min) + ", max: " + Arrays.toString(this.max) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongRange longRange = (LongRange)o;
        return Arrays.equals(this.min, longRange.min) && Arrays.equals(this.max, longRange.max) && this.label.equals(longRange.label) && this.dims == longRange.dims;
    }

    public int hashCode() {
        return Objects.hash(this.label, Arrays.hashCode(this.min), Arrays.hashCode(this.max), this.dims);
    }

    private void checkArgs(long[] min2, long[] max) {
        if (min2 == null || max == null || min2.length == 0 || max.length == 0) {
            this.failNoMatch();
        }
        if (min2.length != max.length) {
            this.failNoMatch();
        }
        for (int i = 0; i < min2.length; ++i) {
            if (min2[i] <= max[i]) continue;
            this.failNoMatch();
        }
    }
}

