/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.search.uhighlight;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.Analyzer;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.FilteringTokenFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenStream;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import com.dataiku.dss.shadelib.org.apache.lucene.index.LeafReader;
import com.dataiku.dss.shadelib.org.apache.lucene.index.memory.MemoryIndex;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.spans.SpanQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.uhighlight.AnalysisOffsetStrategy;
import com.dataiku.dss.shadelib.org.apache.lucene.search.uhighlight.CharArrayMatcher;
import com.dataiku.dss.shadelib.org.apache.lucene.search.uhighlight.MultiTermHighlighting;
import com.dataiku.dss.shadelib.org.apache.lucene.search.uhighlight.OffsetsEnum;
import com.dataiku.dss.shadelib.org.apache.lucene.search.uhighlight.OverlaySingleDocTermsLeafReader;
import com.dataiku.dss.shadelib.org.apache.lucene.search.uhighlight.UHComponents;
import com.dataiku.dss.shadelib.org.apache.lucene.util.BytesRef;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class MemoryIndexOffsetStrategy
extends AnalysisOffsetStrategy {
    private final MemoryIndex memoryIndex;
    private final LeafReader memIndexLeafReader;
    private final CharArrayMatcher preMemIndexFilterAutomaton;

    public MemoryIndexOffsetStrategy(UHComponents components, Analyzer analyzer) {
        super(components, analyzer);
        boolean storePayloads = components.getPhraseHelper().hasPositionSensitivity();
        this.memoryIndex = new MemoryIndex(true, storePayloads);
        this.memIndexLeafReader = (LeafReader)this.memoryIndex.createSearcher().getIndexReader();
        this.preMemIndexFilterAutomaton = MemoryIndexOffsetStrategy.buildCombinedAutomaton(components);
    }

    private static CharArrayMatcher buildCombinedAutomaton(UHComponents components) {
        if (components.getTerms() == null || components.getAutomata() == null) {
            return null;
        }
        ArrayList<CharArrayMatcher> allAutomata = new ArrayList<CharArrayMatcher>();
        if (components.getTerms().length > 0) {
            List<BytesRef> filteredTerms = Arrays.stream(components.getTerms()).filter(b -> b.length < 1000).collect(Collectors.toList());
            allAutomata.add(CharArrayMatcher.fromTerms(filteredTerms));
        }
        Collections.addAll(allAutomata, components.getAutomata());
        for (SpanQuery spanQuery : components.getPhraseHelper().getSpanQueries()) {
            Collections.addAll(allAutomata, MultiTermHighlighting.extractAutomata(spanQuery, components.getFieldMatcher(), true));
        }
        if (allAutomata.size() == 1) {
            return (CharArrayMatcher)allAutomata.get(0);
        }
        return (chars, offset, length) -> {
            for (int i = 0; i < allAutomata.size(); ++i) {
                if (!((CharArrayMatcher)allAutomata.get(i)).match(chars, offset, length)) continue;
                return true;
            }
            return false;
        };
    }

    @Override
    public OffsetsEnum getOffsetsEnum(LeafReader reader, int docId, String content) throws IOException {
        TokenStream tokenStream = this.tokenStream(content);
        if (this.preMemIndexFilterAutomaton != null) {
            tokenStream = MemoryIndexOffsetStrategy.newKeepWordFilter(tokenStream, this.preMemIndexFilterAutomaton);
        }
        this.memoryIndex.reset();
        this.memoryIndex.addField(this.getField(), tokenStream);
        if (reader == null) {
            return this.createOffsetsEnumFromReader(this.memIndexLeafReader, 0);
        }
        return this.createOffsetsEnumFromReader(new OverlaySingleDocTermsLeafReader(reader, this.memIndexLeafReader, this.getField(), docId), docId);
    }

    private static FilteringTokenFilter newKeepWordFilter(TokenStream tokenStream, final CharArrayMatcher matcher) {
        return new FilteringTokenFilter(tokenStream){
            final CharTermAttribute charAtt;
            {
                super(arg0);
                this.charAtt = this.addAttribute(CharTermAttribute.class);
            }

            @Override
            protected boolean accept() throws IOException {
                return matcher.match(this.charAtt.buffer(), 0, this.charAtt.length());
            }
        };
    }
}

