/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.util.hnsw;

import com.dataiku.dss.shadelib.org.apache.lucene.store.IndexInput;
import com.dataiku.dss.shadelib.org.apache.lucene.util.Bits;
import java.io.IOException;
import java.util.List;

public interface RandomAccessVectorValues {
    public int size();

    public int dimension();

    public RandomAccessVectorValues copy() throws IOException;

    default public IndexInput getSlice() {
        return null;
    }

    public int getVectorByteLength();

    default public int ordToDoc(int ord) {
        return ord;
    }

    default public Bits getAcceptOrds(Bits acceptDocs) {
        return acceptDocs;
    }

    public static Floats fromFloats(final List<float[]> vectors, final int dim) {
        return new Floats(){

            @Override
            public int size() {
                return vectors.size();
            }

            @Override
            public int dimension() {
                return dim;
            }

            @Override
            public float[] vectorValue(int targetOrd) {
                return (float[])vectors.get(targetOrd);
            }

            @Override
            public Floats copy() {
                return this;
            }
        };
    }

    public static Bytes fromBytes(final List<byte[]> vectors, final int dim) {
        return new Bytes(){

            @Override
            public int size() {
                return vectors.size();
            }

            @Override
            public int dimension() {
                return dim;
            }

            @Override
            public byte[] vectorValue(int targetOrd) {
                return (byte[])vectors.get(targetOrd);
            }

            @Override
            public Bytes copy() {
                return this;
            }
        };
    }

    public static interface Bytes
    extends RandomAccessVectorValues {
        @Override
        public Bytes copy() throws IOException;

        public byte[] vectorValue(int var1) throws IOException;

        @Override
        default public int getVectorByteLength() {
            return this.dimension() * 1;
        }
    }

    public static interface Floats
    extends RandomAccessVectorValues {
        @Override
        public Floats copy() throws IOException;

        public float[] vectorValue(int var1) throws IOException;

        @Override
        default public int getVectorByteLength() {
            return this.dimension() * 4;
        }
    }
}

