/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet;

import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet.ResourceServlet;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet.ServletApiRequest;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Context;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.URIUtil;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.MappingMatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServlet
extends ResourceServlet {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultServlet.class);
    public static final String CONTEXT_INIT = "com.dataiku.dss.shadelib.org.eclipse.jetty.servlet.Default.";
    private final AtomicBoolean warned = new AtomicBoolean(false);

    @Override
    public String getInitParameter(String name) {
        String value = this.getServletContext().getInitParameter(CONTEXT_INIT + name);
        if (value == null) {
            value = super.getInitParameter(name);
        }
        return value;
    }

    @Override
    public void init() throws ServletException {
        if ("true".equalsIgnoreCase(this.getInitParameter("pathInfoOnly"))) {
            LOG.warn("DefaultServlet pathInfoOnly is set to true. Use ResourceServlet instead.");
        }
        super.init();
    }

    @Override
    protected String getEncodedPathInContext(HttpServletRequest request, boolean included) {
        String deprecatedPath = this.getEncodedPathInContext(request, (String)(included ? request.getAttribute("jakarta.servlet.include.servlet_path") : null));
        if (deprecatedPath != null) {
            return deprecatedPath;
        }
        if (request.getHttpServletMapping().getMappingMatch() != MappingMatch.DEFAULT) {
            if (this.warned.compareAndSet(false, true)) {
                LOG.warn("Incorrect mapping for DefaultServlet at %s. Use ResourceServlet".formatted(request.getHttpServletMapping().getPattern()));
            }
            return super.getEncodedPathInContext(request, included);
        }
        if (included) {
            Object object = request.getAttribute("jakarta.servlet.include.servlet_path");
            if (object instanceof String) {
                String servletPath = (String)object;
                return URIUtil.encodePath(servletPath);
            }
            return URIUtil.encodePath(request.getServletPath());
        }
        if (request instanceof ServletApiRequest) {
            ServletApiRequest apiRequest = (ServletApiRequest)request;
            return Context.getPathInContext(request.getContextPath(), apiRequest.getRequest().getHttpURI().getCanonicalPath());
        }
        return URIUtil.encodePath(request.getServletPath());
    }

    @Deprecated(forRemoval=true)
    protected String getEncodedPathInContext(HttpServletRequest req, String includedServletPath) {
        return null;
    }
}

