/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.http;

import com.dataiku.dss.shadelib.org.eclipse.jetty.http.BadMessageException;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.ComplianceViolation;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.CookieCompliance;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.CookieParser;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.HttpCookie;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.HttpField;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.HttpFields;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.HttpHeader;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;

@Deprecated(forRemoval=true)
public class CookieCache
implements CookieParser.Handler,
ComplianceViolation.Listener {
    private final List<String> _rawFields = new ArrayList<String>();
    private List<HttpCookie> _cookieList;
    private final CookieParser _parser;
    private List<ComplianceViolation.Event> _violations;

    @Deprecated
    public CookieCache() {
        this(CookieCompliance.RFC6265);
    }

    @Deprecated
    public CookieCache(CookieCompliance compliance) {
        this._parser = CookieParser.newParser(this, compliance, this);
    }

    @Deprecated(forRemoval=true)
    public CookieCache(CookieCompliance compliance, ComplianceViolation.Listener complianceListener) {
        this(compliance);
    }

    @Override
    public void onComplianceViolation(ComplianceViolation.Event event) {
        if (this._violations == null) {
            this._violations = new ArrayList<ComplianceViolation.Event>();
        }
        this._violations.add(event);
    }

    @Override
    public void addCookie(String cookieName, String cookieValue, int cookieVersion, String cookieDomain, String cookiePath, String cookieComment) {
        if (StringUtil.isEmpty(cookieDomain) && StringUtil.isEmpty(cookiePath) && cookieVersion <= 0 && StringUtil.isEmpty(cookieComment)) {
            this._cookieList.add(HttpCookie.from(cookieName, cookieValue));
        } else {
            HashMap<String, String> attributes = new HashMap<String, String>();
            if (!StringUtil.isEmpty(cookieDomain)) {
                attributes.put("Domain", cookieDomain);
            }
            if (!StringUtil.isEmpty(cookiePath)) {
                attributes.put("Path", cookiePath);
            }
            if (!StringUtil.isEmpty(cookieComment)) {
                attributes.put("Comment", cookieComment);
            }
            this._cookieList.add(HttpCookie.from(cookieName, cookieValue, cookieVersion, attributes));
        }
    }

    public List<HttpCookie> getCookies(HttpFields headers) {
        return this.getCookies(headers, ComplianceViolation.Listener.NOOP);
    }

    public List<HttpCookie> getCookies(HttpFields headers, ComplianceViolation.Listener complianceViolationListener) {
        boolean building = false;
        ListIterator<String> raw = this._rawFields.listIterator();
        for (HttpField field : headers) {
            String value;
            if (!HttpHeader.COOKIE.equals((Object)field.getHeader()) || StringUtil.isBlank(value = field.getValue())) continue;
            if (building) {
                this._rawFields.add(value);
                continue;
            }
            if (!raw.hasNext()) {
                building = true;
                this._rawFields.add(value);
                continue;
            }
            if (value.equals(raw.next())) continue;
            building = true;
            raw.remove();
            while (raw.hasNext()) {
                raw.next();
                raw.remove();
            }
            this._rawFields.add(value);
        }
        if (!building && raw.hasNext()) {
            building = true;
            while (raw.hasNext()) {
                raw.next();
                raw.remove();
            }
        }
        if (building) {
            this._cookieList = new ArrayList<HttpCookie>();
            try {
                if (this._violations != null) {
                    this._violations.clear();
                }
                this._parser.parseFields(this._rawFields);
            }
            catch (CookieParser.InvalidCookieException invalidCookieException) {
                throw new BadMessageException(invalidCookieException.getMessage(), (Throwable)invalidCookieException);
            }
        }
        if (this._violations != null && !this._violations.isEmpty()) {
            this._violations.forEach(complianceViolationListener::onComplianceViolation);
        }
        return this._cookieList == null ? Collections.emptyList() : this._cookieList;
    }

    public void replaceCookieList(List<HttpCookie> cookies) {
        assert (this._cookieList.equals(cookies));
        this._cookieList = cookies;
    }
}

