/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibdatabricks.io.opencensus.tags;

import com.dataiku.dss.shadelibdatabricks.io.opencensus.tags.Tag;
import com.dataiku.dss.shadelibdatabricks.javax.annotation.Nullable;
import com.dataiku.dss.shadelibdatabricks.javax.annotation.concurrent.Immutable;
import java.util.HashMap;
import java.util.Iterator;

@Immutable
public abstract class TagContext {
    protected abstract Iterator<Tag> getIterator();

    public String toString() {
        return "TagContext";
    }

    public boolean equals(@Nullable Object other) {
        Tag tag;
        if (!(other instanceof TagContext)) {
            return false;
        }
        TagContext otherTags = (TagContext)other;
        Iterator<Tag> iter1 = this.getIterator();
        Iterator<Tag> iter2 = otherTags.getIterator();
        HashMap<Tag, Integer> tags = new HashMap<Tag, Integer>();
        while (iter1 != null && iter1.hasNext()) {
            tag = iter1.next();
            if (tags.containsKey(tag)) {
                tags.put(tag, (Integer)tags.get(tag) + 1);
                continue;
            }
            tags.put(tag, 1);
        }
        while (iter2 != null && iter2.hasNext()) {
            tag = iter2.next();
            if (!tags.containsKey(tag)) {
                return false;
            }
            int count = (Integer)tags.get(tag);
            if (count > 1) {
                tags.put(tag, count - 1);
                continue;
            }
            tags.remove(tag);
        }
        return tags.isEmpty();
    }

    public final int hashCode() {
        int hashCode = 0;
        Iterator<Tag> i = this.getIterator();
        if (i == null) {
            return hashCode;
        }
        while (i.hasNext()) {
            Tag tag = i.next();
            if (tag == null) continue;
            hashCode += tag.hashCode();
        }
        return hashCode;
    }
}

