/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.partitioning;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.DimensionType;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.ExactValueDimensionValue;
import com.dataiku.j2ts.annotations.UIField;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@UIModel(extraFields={@UIField(name="type", value="'value'")})
public class ExactValueDimension
extends Dimension {
    public static final String TYPE = "value";
    @Nullable
    public DimensionIntegerRangeInfo integerRangeInfo;

    @Override
    public String getType() {
        return TYPE;
    }

    public static JsonObject serialize(ExactValueDimension dimension) {
        JsonObject json = new JsonObject();
        json.addProperty("name", dimension.name);
        if (dimension.integerRangeInfo != null) {
            json.add("integerRangeInfo", (JsonElement)DimensionIntegerRangeInfo.serialize(dimension.integerRangeInfo));
        }
        return json;
    }

    public static ExactValueDimension deserialize(JsonObject json) {
        String name;
        String string = name = json.has("name") ? json.get("name").getAsString() : "";
        if (name.isEmpty()) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_PARTITIONING_CONFIG, "Partitioning dimension name is required.");
        }
        if (json.has("integerRangeInfo")) {
            JsonObject integerRangeInfoJson = json.getAsJsonObject("integerRangeInfo");
            DimensionIntegerRangeInfo integerRangeInfo = DimensionIntegerRangeInfo.deserialize(integerRangeInfoJson);
            return new ExactValueDimension(name, integerRangeInfo);
        }
        return new ExactValueDimension(name);
    }

    public ExactValueDimension(String name) {
        super(name);
    }

    public ExactValueDimension(String name, @Nullable DimensionIntegerRangeInfo integerRangeInfo) {
        super(name);
        this.integerRangeInfo = integerRangeInfo;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ExactValueDimension) {
            ExactValueDimension otherEvd = (ExactValueDimension)other;
            return this.name.equals(otherEvd.name) && Objects.equals(this.integerRangeInfo, otherEvd.integerRangeInfo);
        }
        return false;
    }

    @Override
    public DimensionValue getValueFromId(String id) {
        return new ExactValueDimensionValue(id);
    }

    @Override
    public List<DimensionValue> getValuesFromPattern(String pattern) {
        String[] severalValues = pattern.split("/");
        ArrayList<DimensionValue> values = new ArrayList<DimensionValue>();
        for (String v : severalValues) {
            values.add(new ExactValueDimensionValue(v));
        }
        return values;
    }

    @Override
    public DimensionType toDimensionType() {
        return DimensionType.DISCRETE;
    }

    @Override
    public int hashCode() {
        throw new Error("hashCode not designed");
    }

    public record DimensionIntegerRangeInfo(long start, long end, long interval) {
        public static JsonObject serialize(DimensionIntegerRangeInfo integerRangeInfo) {
            JsonObject json = new JsonObject();
            json.addProperty("start", (Number)integerRangeInfo.start);
            json.addProperty("end", (Number)integerRangeInfo.end);
            json.addProperty("interval", (Number)integerRangeInfo.interval);
            return json;
        }

        public static DimensionIntegerRangeInfo deserialize(JsonObject json) {
            if (!(json.has("start") && json.has("end") && json.has("interval"))) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_PARTITIONING_CONFIG, "Partitioning dimension integer range info must have start, end and interval.");
            }
            try {
                return new DimensionIntegerRangeInfo(json.get("start").getAsLong(), json.get("end").getAsLong(), json.get("interval").getAsLong());
            }
            catch (Exception e) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_PARTITIONING_CONFIG, "Partitioning dimension integer range info start, end and interval must be integers.");
            }
        }
    }
}

