/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.monitoring;

import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.lambda.APINodeMetrics;
import com.dataiku.lambda.model.serverconfig.LambdaEndpointConfig;
import com.dataiku.lambda.monitoring.APIServiceStats;
import com.dataiku.lambda.monitoring.EndpointStats;
import com.dataiku.lambda.monitoring.JSONMeter;
import com.dataiku.lambda.monitoring.JSONTimer;
import com.dataiku.lambda.services.ServiceManager;
import com.dataiku.lambda.services.ServicesService;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;

public class MonitoringService {
    @Autowired
    private ServicesService servicesService;

    public APIServiceStats getAPIServiceStats(String serviceId) throws NotFoundException {
        ServiceManager sm = this.servicesService.getServiceManager(serviceId);
        if (sm == null) {
            throw new NotFoundException("Service " + serviceId + " does not exist");
        }
        APIServiceStats ret = new APIServiceStats();
        ArrayList<String> endpointIds = new ArrayList<String>();
        for (LambdaEndpointConfig lec : sm.getConfig().endpoints) {
            endpointIds.add(lec.id);
        }
        for (String endpointId : endpointIds) {
            EndpointStats es = new EndpointStats();
            es.enpdointId = endpointId;
            es.requests = new JSONMeter(APINodeMetrics.endpointMeter(serviceId, endpointId, "requests"));
            es.successRequests = new JSONMeter(APINodeMetrics.endpointMeter(serviceId, endpointId, "successRequests"));
            es.processingTime = new JSONTimer(APINodeMetrics.endpointTimer(serviceId, endpointId, "totalProcessing"));
            ret.endpoints.add(es);
        }
        return ret;
    }
}

