/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibpoi.org.apache.xmlbeans.impl.logging;

import com.dataiku.dss.shadelibpoi.org.apache.logging.log4j.LogManager;
import com.dataiku.dss.shadelibpoi.org.apache.logging.log4j.Logger;
import com.dataiku.dss.shadelibpoi.org.apache.xmlbeans.impl.logging.NoOpLogger;
import com.dataiku.dss.shadelibpoi.org.apache.xmlbeans.impl.util.ExceptionUtil;

public final class XmlBeansLogManager {
    private static final long SLEEP_TIME = 600000L;
    private static long LAST_TIME = 0L;

    private XmlBeansLogManager() {
    }

    public static Logger getLogger(Class<?> clz) {
        try {
            Logger logger = LogManager.getLogger(clz);
            if (logger == null) {
                if (XmlBeansLogManager.shouldLog()) {
                    System.err.println("[XmlBeansLogManager] Log4J returned null logger. Falling back to No-Op logger.");
                }
                return NoOpLogger.INSTANCE;
            }
            return logger;
        }
        catch (Throwable t) {
            if (!ExceptionUtil.isFatal(t) && XmlBeansLogManager.shouldLog()) {
                System.err.println("[XmlBeansLogManager] Issue loading Log4J. Falling back to No-Op logger.");
                t.printStackTrace();
            }
            return NoOpLogger.INSTANCE;
        }
    }

    private static synchronized boolean shouldLog() {
        long time = System.currentTimeMillis();
        if (time > LAST_TIME + 600000L) {
            LAST_TIME = time;
            return true;
        }
        return false;
    }
}

