/*
 * Decompiled with CFR 0.152.
 */
package dip.clean;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.db.DSSDBConnectionsManagementService;
import com.dataiku.dip.db.SingleH2DatabaseConnectionsFactory;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.plugin.BackendClient;
import com.dataiku.dip.plugin.CustomRunnable;
import com.dataiku.dip.plugin.ProgressTracker;
import com.dataiku.dip.plugin.ResultTableDTO;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.DeleteQueryBuilder;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.timelines.MultiTimelinesInternalDB;
import com.dataiku.dip.timelines.ProjectTimelineBehavior;
import com.dataiku.dip.timelines.TimelinesInternalDB;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class CleanDbs
implements CustomRunnable {
    private static final ExpressionBuilder.ExpressionBuilderFactory EBF = new ExpressionBuilder.ExpressionBuilderFactory();
    private static final int H2_DB_SIZE_THRESHOLD_IN_MB = DKUApp.getProperty((String)"dku.macros.cleanInternalDBs.maxH2DbSizeInMB", (int)500);
    private static final String RUNTIME_DATABASE_DOC_URL = "https://doc.dataiku.com/dss/latest/operations/runtime-databases.html";
    private String projectKey;
    private boolean deleteJobs;
    private boolean deleteChecks;
    private boolean deleteMetrics;
    private boolean deleteScenarios;
    private boolean deleteTimelines;
    private int maxAge;
    private boolean force;
    @Autowired
    private ReadWriteJobsInternalDB jobsDB;
    @Autowired
    private TimelinesInternalDB timelinesDB;
    @Autowired
    private DSSDBConnectionsManagementService internalDBConnectionsService;
    private List<String> timelineProjectKeysToClearCache;
    private static Logger logger = Logger.getLogger((String)"dku.clean.dbs");

    public void init(String projectKey, JsonObject config, JsonObject pluginConfig, ProgressTracker progressTracker, BackendClient backendClient) throws Exception {
        this.projectKey = projectKey;
        if (config.get("allProjects").getAsBoolean()) {
            this.projectKey = null;
        }
        this.deleteJobs = config.get("jobs").getAsBoolean();
        this.deleteChecks = config.get("checks").getAsBoolean();
        this.deleteMetrics = config.get("metrics").getAsBoolean();
        this.deleteScenarios = config.get("scenarios").getAsBoolean();
        this.deleteTimelines = config.get("timelines").getAsBoolean();
        this.maxAge = config.get("age").getAsInt();
        this.force = config.get("force").getAsBoolean();
        SpringUtils.getInstance().autowire((Object)this);
    }

    public byte[] run() throws Exception {
        if (this.internalDBConnectionsService.isUsingInternalH2()) {
            this.ensureH2DatabaseFilesCanBeCleaned();
        }
        long maxTimestamp = DateTime.now().minusDays(this.maxAge).getMillis();
        ArrayList deletions = Lists.newArrayList();
        try (DSSDBConnection conn = this.jobsDB.acquireConnection();){
            if (this.deleteJobs) {
                deletions.add(this.executeOneDeleteStatement(conn, this.createDeleteQueryBuilder("JOB", "JOB_PROJECT_KEY").where(EBF.col("TIME_END").gt((Object)0)).where(EBF.col("TIME_END").lt((Object)maxTimestamp)).toSql(this.jobsDB.getDialect()), "jobs"));
            }
            if (this.deleteChecks) {
                deletions.add(this.executeOneDeleteStatement(conn, this.createDeleteQueryBuilder("CHECKS_LAST", "PROJECT_KEY").where(EBF.col("TIME_COMPUTE").lt((Object)maxTimestamp)).toSql(this.jobsDB.getDialect()), "last checks"));
                deletions.add(this.executeOneDeleteStatement(conn, DeleteQueryBuilder.deleteFrom((SQLUtils.SQLTable)this.jobsDB.resolveTable("CHECKS_HISTORY")).where(EBF.col("SESSION_INDEX").in((Object)this.buildSessionIndicesSqlQueryExpr("CHECKS_SESSIONS", maxTimestamp))).toSql(this.jobsDB.getDialect()), "checks history"));
                deletions.add(this.executeOneDeleteStatement(conn, this.createDeleteQueryBuilder("CHECKS_SESSIONS", "PROJECT_KEY").where(EBF.col("TIME_COMPUTE").lt((Object)maxTimestamp)).toSql(this.jobsDB.getDialect()), "checks sessions"));
                deletions.add(this.executeOneDeleteStatement(conn, this.createDeleteQueryBuilder("DATA_QUALITY_PARTITION_LAST", "PROJECT_KEY").where(EBF.col("LAST_RULE_COMPUTE_TIME").lt((Object)maxTimestamp)).toSql(this.jobsDB.getDialect()), "last partitions data quality"));
                deletions.add(this.executeOneDeleteStatement(conn, this.createDeleteQueryBuilder("DATA_QUALITY_PARTITION_HISTORY", "PROJECT_KEY").where(EBF.col("LAST_RULE_COMPUTE_TIME").lt((Object)maxTimestamp)).toSql(this.jobsDB.getDialect()), "data quality partitions history"));
                deletions.add(this.executeOneDeleteStatement(conn, this.createDeleteQueryBuilder("DATA_QUALITY_OBJECT_LAST", "PROJECT_KEY").where(EBF.col("LAST_RULE_COMPUTE_TIME").lt((Object)maxTimestamp)).toSql(this.jobsDB.getDialect()), "last data quality objects"));
                deletions.add(this.executeOneDeleteStatement(conn, this.createDeleteQueryBuilder("DATA_QUALITY_OBJECT_HISTORY", "PROJECT_KEY").where(EBF.col("LAST_RULE_COMPUTE_TIME").lt((Object)maxTimestamp)).toSql(this.jobsDB.getDialect()), "data quality objects history"));
                deletions.add(this.executeOneDeleteStatement(conn, this.createDeleteQueryBuilder("DATA_QUALITY_PROJECT_LAST", "PROJECT_KEY").where(EBF.col("LAST_RULE_COMPUTE_TIME").lt((Object)maxTimestamp)).toSql(this.jobsDB.getDialect()), "last data quality project"));
                deletions.add(this.executeOneDeleteStatement(conn, this.createDeleteQueryBuilder("DATA_QUALITY_PROJECT_HISTORY", "PROJECT_KEY").where(EBF.col("LAST_RULE_COMPUTE_TIME").lt((Object)maxTimestamp)).toSql(this.jobsDB.getDialect()), "data quality project history"));
            }
            if (this.deleteMetrics) {
                deletions.add(this.executeOneDeleteStatement(conn, this.createDeleteQueryBuilder("METRICS_LAST", "PROJECT_KEY").where(EBF.col("TIME_COMPUTE").lt((Object)maxTimestamp)).toSql(this.jobsDB.getDialect()), "last metrics"));
                deletions.add(this.executeOneDeleteStatement(conn, DeleteQueryBuilder.deleteFrom((SQLUtils.SQLTable)this.jobsDB.resolveTable("METRICS_HISTORY")).where(EBF.col("SESSION_INDEX").in((Object)this.buildSessionIndicesSqlQueryExpr("METRICS_SESSIONS", maxTimestamp))).toSql(this.jobsDB.getDialect()), "metrics history"));
                deletions.add(this.executeOneDeleteStatement(conn, this.createDeleteQueryBuilder("METRICS_SESSIONS", "PROJECT_KEY").where(EBF.col("TIME_COMPUTE").lt((Object)maxTimestamp)).toSql(this.jobsDB.getDialect()), "metrics sessions"));
            }
            if (this.deleteScenarios) {
                deletions.add(this.executeOneDeleteStatement(conn, this.createDeleteQueryBuilder("SCENARIO_RUNS", "SCENARIO_PROJECT_KEY").where(EBF.col("TIME_END").gt((Object)0)).where(EBF.col("TIME_END").lt((Object)maxTimestamp)).toSql(this.jobsDB.getDialect()), "scenario runs"));
                deletions.add(this.executeOneDeleteStatement(conn, this.createDeleteQueryBuilder("STEP_RUNS", "SCENARIO_PROJECT_KEY").where(EBF.col("TIME_END").gt((Object)0)).where(EBF.col("TIME_END").lt((Object)maxTimestamp)).toSql(this.jobsDB.getDialect()), "scenario steps"));
                deletions.add(this.executeOneDeleteStatement(conn, this.createDeleteQueryBuilder("TRIGGER_FIRES", "SCENARIO_PROJECT_KEY").where(EBF.col("TIME_TRIGGER").lt((Object)maxTimestamp)).toSql(this.jobsDB.getDialect()), "triggers"));
                deletions.add(this.executeOneDeleteStatement(conn, this.createDeleteQueryBuilder("FLOW_OBJECT_ACTION", "PROJECT_KEY").where(EBF.col("TIME_END").gt((Object)0)).where(EBF.col("TIME_END").lt((Object)maxTimestamp)).toSql(this.jobsDB.getDialect()), "last object changes"));
                deletions.add(this.executeOneDeleteStatement(conn, this.createDeleteQueryBuilder("FLOW_OBJECT_ACTION_HISTORY", "PROJECT_KEY").where(EBF.col("TIME_END").gt((Object)0)).where(EBF.col("TIME_END").lt((Object)maxTimestamp)).toSql(this.jobsDB.getDialect()), "object changes history"));
            }
        }
        if (this.deleteTimelines) {
            for (String pkey : this.getTimelineProjectKeysToClear()) {
                logger.info((Object)("Cleaning timeline for project " + pkey));
                ProjectTimelineBehavior behavior = this.timelinesDB.getDao(pkey);
                try (DSSDBConnection conn = this.timelinesDB.acquireConnection(pkey);){
                    deletions.add(this.executeOneDeleteStatement(conn, this.createDeleteQueryBuilder(behavior.getResolvedTable(), "PROJECT_KEY", pkey).where(EBF.col("ITEM_TIME").lt((Object)maxTimestamp)).toSql(behavior.getDialect()), "timeline (" + pkey + ")"));
                }
            }
        }
        List<ResultTableDTO.ResultTableColumnDTO> resultTableDTOColumns = Arrays.asList(new ResultTableDTO.ResultTableColumnDTO("Deleted", "STRING"), new ResultTableDTO.ResultTableColumnDTO("Count", "STRING"));
        ArrayList<List<String>> resultTableDTOData = new ArrayList<List<String>>();
        for (ReportElement deletion : deletions) {
            resultTableDTOData.add(Arrays.asList(deletion.name, String.valueOf(deletion.deleted)));
        }
        return JSON.json((Object)new ResultTableDTO("Clear internal database", resultTableDTOColumns, resultTableDTOData)).getBytes(StandardCharsets.UTF_8);
    }

    private void ensureH2DatabaseFilesCanBeCleaned() throws CodedSQLException, IOException {
        if (this.force) {
            logger.warn((Object)"User bypassed the H2 databases size checks");
        } else {
            if (this.deleteJobs || this.deleteChecks || this.deleteMetrics || this.deleteScenarios) {
                CleanDbs.ensureDatabaseFileCanBeCleaned(ApplicationConfigurator.getDatabaseFile((String)"jobs"));
            }
            if (this.deleteTimelines) {
                for (String projectKey : this.getTimelineProjectKeysToClear()) {
                    CleanDbs.ensureDatabaseFileCanBeCleaned(MultiTimelinesInternalDB.getProjectDAOFile((String)projectKey));
                }
            }
        }
    }

    private static void ensureDatabaseFileCanBeCleaned(File databaseFile) throws CodedSQLException, IOException {
        Path databaseFilePath = SingleH2DatabaseConnectionsFactory.getDBFile((File)databaseFile).toPath();
        long databaseFileSizeInMegaBytes = Files.size(databaseFilePath) / 0x100000L;
        if (databaseFileSizeInMegaBytes > (long)H2_DB_SIZE_THRESHOLD_IN_MB) {
            logger.warn((Object)String.format("H2 database file '%s' is %,dMB, aborting internal database cleanup", databaseFilePath, databaseFileSizeInMegaBytes));
            throw new CodedSQLException((InfoMessage.MessageCode)Codes.ERR_H2_DB_TOO_BIG_TO_BE_CLEANED, "Running this could cause DSS to become unresponsive for several hours or days. Please see https://doc.dataiku.com/dss/latest/operations/runtime-databases.html to learn how to migrate to PostgreSQL database or contact support");
        }
    }

    private List<String> getTimelineProjectKeysToClear() throws IOException {
        if (this.timelineProjectKeysToClearCache == null) {
            if (this.projectKey == null) {
                TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
                try (Transaction t = transactionService.beginRead();){
                    this.timelineProjectKeysToClearCache = ((ProjectsService)SpringUtils.getBean(ProjectsService.class)).listKeys();
                }
            } else {
                this.timelineProjectKeysToClearCache = Lists.newArrayList((Object[])new String[]{this.projectKey});
            }
        }
        return this.timelineProjectKeysToClearCache;
    }

    private ExpressionBuilder buildSessionIndicesSqlQueryExpr(String sessionsTable, long maxTimestamp) {
        SelectQueryBuilder checkSessionIndices = new SelectQueryBuilder();
        checkSessionIndices.from(this.jobsDB.resolveTable(sessionsTable), sessionsTable);
        checkSessionIndices.select("SESSION_INDEX");
        if (this.projectKey != null) {
            checkSessionIndices.where(new ExpressionBuilder[]{EBF.col("PROJECT_KEY").eq((Object)this.projectKey)});
        }
        checkSessionIndices.where(new ExpressionBuilder[]{EBF.col("TIME_COMPUTE").lt((Object)maxTimestamp)});
        return EBF.expr(checkSessionIndices.toSQL(this.jobsDB.getDialect()));
    }

    private DeleteQueryBuilder createDeleteQueryBuilder(SQLUtils.SQLTable table, String projectKeyColumnName, String projectKeyValue) {
        DeleteQueryBuilder deleteQueryBuilder = DeleteQueryBuilder.deleteFrom((SQLUtils.SQLTable)table);
        if (projectKeyValue != null) {
            deleteQueryBuilder.where(EBF.col(projectKeyColumnName).nullUnsafeEq((Object)projectKeyValue));
        }
        return deleteQueryBuilder;
    }

    private DeleteQueryBuilder createDeleteQueryBuilder(String tableName, String projectKeyColumnName) {
        return this.createDeleteQueryBuilder(this.jobsDB.resolveTable(tableName), projectKeyColumnName, this.projectKey);
    }

    public void abort() {
    }

    private ReportElement executeOneDeleteStatement(DSSDBConnection conn, String sql, String name) throws SQLException {
        try (Statement st = conn.createStatement();){
            logger.info((Object)("Starting cleanup statement " + sql));
            int deleted = st.executeUpdate(sql);
            logger.info((Object)("Cleanup statement done, deleted=" + deleted));
            conn.commit();
            ReportElement reportElement = new ReportElement(name, deleted);
            return reportElement;
        }
    }

    private class ReportElement {
        final String name;
        final int deleted;

        ReportElement(String name, int deleted) {
            this.name = name;
            this.deleted = deleted;
        }
    }

    private static enum Codes implements InfoMessage.MessageCode
    {
        ERR_H2_DB_TOO_BIG_TO_BE_CLEANED("Very large database", InfoMessage.FixabilityCategory.ADMIN_TROUBLESHOOTING);

        private final String title;
        private final InfoMessage.FixabilityCategory fixability;

        private Codes(String title, InfoMessage.FixabilityCategory fixability) {
            this.title = title;
            this.fixability = fixability;
        }

        public String getCode() {
            return this.name();
        }

        public String getCodeTitle() {
            return this.title;
        }

        public InfoMessage.FixabilityCategory getFixability() {
            return this.fixability;
        }
    }
}

