/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.futures;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class FuturePayload {
    public String action;
    @Nonnull
    public List<FuturePayloadTarget> targets = Lists.newArrayList();
    public String displayName;
    public Map<String, Object> extras;

    @Nullable
    public String getProjectKey() {
        if (this.targets.size() == 0) {
            return null;
        }
        return this.targets.get((int)0).projectKey;
    }

    public static FuturePayload newSimple(String actionType, String displayName) {
        FuturePayload fp = new FuturePayload();
        fp.action = actionType;
        fp.displayName = displayName;
        return fp;
    }

    public FuturePayload withExtra(String key, Object value) {
        if (this.extras == null) {
            this.extras = Maps.newHashMap();
        }
        this.extras.put(key, value);
        return this;
    }

    public static class FuturePayloadTarget {
        @Nullable
        public final String objectType;
        @Nullable
        public final String projectKey;
        @Nullable
        public final String objectId;
        @Nullable
        public final String name;
        @Nullable
        public final String subType;
        public String part;

        public FuturePayloadTarget(@Nullable String projectKey, @Nullable String objectType) {
            this.objectType = objectType;
            this.projectKey = projectKey;
            this.objectId = null;
            this.name = null;
            this.subType = null;
        }

        public FuturePayloadTarget(@Nullable String projectKey, @Nullable String id, @Nullable String name, @Nullable String type) {
            this.objectType = type;
            this.projectKey = projectKey;
            this.objectId = id;
            this.name = name;
            this.subType = null;
        }

        public FuturePayloadTarget(@Nullable String projectKey, @Nullable String id, @Nullable String name, @Nullable String subType, @Nullable String type) {
            this.objectType = type;
            this.projectKey = projectKey;
            this.objectId = id;
            this.name = name;
            this.subType = subType;
        }

        public FuturePayloadTarget withPart(String part) {
            this.part = part;
            return this;
        }
    }
}

