/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security;

import com.dataiku.dss.shadelib.org.apache.http.NameValuePair;
import com.dataiku.dss.shadelib.org.apache.http.client.utils.URIBuilder;
import com.dataiku.dss.shadelib.org.apache.http.message.BasicNameValuePair;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class UrlRedactionUtils {
    private static String urlPattern = "(https?://)([^@/\\s]+)@(\\S*)";
    private static Pattern pattern = Pattern.compile(urlPattern, 2);

    private UrlRedactionUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static String sanitizeHttpUrls(String input, String replacement) {
        if (StringUtils.isBlank((String)input)) {
            return input;
        }
        Matcher matcher = pattern.matcher(input);
        StringBuilder sanitized = new StringBuilder();
        while (matcher.find()) {
            matcher.appendReplacement(sanitized, matcher.group(1) + replacement + matcher.group(3));
        }
        matcher.appendTail(sanitized);
        return sanitized.toString();
    }

    public static String sanitizeHttpUrls(String input) {
        return UrlRedactionUtils.sanitizeHttpUrls(input, "***@");
    }

    public static String cleanHttpUrls(String input) {
        return UrlRedactionUtils.sanitizeHttpUrls(input, "");
    }

    public static String sanitizeUrlParams(String input, Map<String, String> paramReplacementMap) {
        if (StringUtils.isEmpty((String)input) || paramReplacementMap == null || paramReplacementMap.isEmpty()) {
            return input;
        }
        try {
            URIBuilder uri = new URIBuilder(input, StandardCharsets.UTF_8);
            List<NameValuePair> newParams = uri.getQueryParams().stream().map(param -> {
                String paramName = param.getName();
                if (paramReplacementMap.containsKey(param.getName())) {
                    return new BasicNameValuePair(param.getName(), (String)paramReplacementMap.get(paramName));
                }
                return param;
            }).toList();
            return uri.setParameters(newParams).build().toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            return input;
        }
    }
}

