/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.time.ical;

import com.dataiku.dip.shaker.processors.SnowflakeUDF;
import com.dataiku.dip.shaker.processors.time.ical.HolidayOccurrence;
import com.dataiku.dip.shaker.processors.time.ical.HolidaysExtractionHelper;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.log4j.Logger;

public class HolidaysComputerUDF
extends SnowflakeUDF {
    private boolean initialized;
    private static Logger logger = Logger.getLogger((String)"dku.prepare.geoip");

    private void initialize() throws IOException {
        String importDirectory = System.getProperty("com.snowflake.import_directory");
        File h = new File(importDirectory, "holidays.db");
        File w = new File(importDirectory, "weekends.db");
        HolidaysExtractionHelper.loadSharedDatabase(w, h);
        this.initialized = true;
    }

    private DateTimeZone parseTimezone(String timeZoneID) throws IllegalArgumentException {
        if (timeZoneID == null || timeZoneID.isEmpty()) {
            throw new IllegalArgumentException("Invalid timezone");
        }
        return DateTimeZone.forID((String)timeZoneID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] processFixedCalendar(Timestamp sqlTS, String calendarId, boolean usePreferedTimezones, String timezone, boolean flagSchoolHolidays, boolean flagBankHolidays, boolean flagWeekends, boolean extractReasons, boolean extractZones) throws Exception {
        HolidaysComputerUDF holidaysComputerUDF = this;
        synchronized (holidaysComputerUDF) {
            if (!this.initialized) {
                this.initialize();
            }
        }
        long dateVal = sqlTS.getTime();
        if (dateVal == Long.MAX_VALUE) {
            return new String[0];
        }
        if (usePreferedTimezones) {
            DateTime dt = new DateTime(dateVal);
            return this.handleFoundOccurrences(HolidaysExtractionHelper.getCachedDB().searchForDay(dt, calendarId), flagSchoolHolidays, flagBankHolidays, flagWeekends, extractReasons, extractZones);
        }
        DateTimeZone currentTimezone = this.parseTimezone(timezone);
        if (currentTimezone == null) {
            return new String[0];
        }
        GregorianCalendar outCal = new GregorianCalendar(currentTimezone.toTimeZone());
        outCal.setTime(new Date(dateVal));
        int year = outCal.get(1);
        int monthofyear = outCal.get(2) + 1;
        int dayofmonth = outCal.get(5);
        return this.handleFoundOccurrences(HolidaysExtractionHelper.getCachedDB().searchForDay(year, monthofyear, dayofmonth, calendarId), flagSchoolHolidays, flagBankHolidays, flagWeekends, extractReasons, extractZones);
    }

    private String[] handleFoundOccurrences(List<HolidayOccurrence> occurrences, boolean flagSchoolHolidays, boolean flagBankHolidays, boolean flagWeekends, boolean extractReasons, boolean extractZones) {
        HolidaysExtractionHelper.SearchResult result = HolidaysExtractionHelper.handleOccurences(occurrences, flagSchoolHolidays, flagBankHolidays, flagWeekends, extractReasons, extractZones);
        ArrayList<Object> ret = new ArrayList<Object>();
        if (flagBankHolidays) {
            ret.add("" + result.isBankHoliday);
        }
        if (flagSchoolHolidays) {
            ret.add("" + result.isSchoolHoliday);
        }
        if (flagWeekends) {
            ret.add("" + result.isWeekend);
        }
        if (extractReasons) {
            if (flagBankHolidays) {
                ret.add(HolidaysExtractionHelper.jsonify(result.bankHolidayReasons));
            }
            if (flagSchoolHolidays) {
                ret.add(HolidaysExtractionHelper.jsonify(result.schoolHolidayReasons));
            }
        }
        if (extractZones) {
            ret.add(HolidaysExtractionHelper.jsonify(result.zones));
        }
        return ret.toArray(new String[0]);
    }
}

