/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.hivecommon.utils;

import com.databricks.client.hivecommon.HiveJDBCSettings;
import com.databricks.client.jdbc.utils.WarningsUtils;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.Warning;
import com.databricks.client.support.WarningCode;
import java.util.regex.Pattern;

public class HiveCommonQueryTranslationUtils {
    private static final String EXACTLY_ONE_WHITE_SPACE_REGEX_PATTERN = "[\\s]";
    private static final String EXACTLY_ONE_OPEN_PAREN_REGEX_PATTERN = "\\(";
    private static final String IDENTIFIER_SEPARATOR_REGEX_PATTERN = "\\.";
    private static final String BACK_TICK_REGEX_PATTERN = "`";
    private static final String DOUBLE_QUOTE_REGEX_PATTERN = "\"";
    private static final String OPENING_SQUARE_BRACKET_REGEX_PATTERN = "\\[";
    private static final String CLOSING_SQUARE_BRACKET_REGEX_PATTERN = "\\]";
    private static final String REGEX_CAPTURE_GROUP_OPENING_PAREN = "(";
    private static final String REGEX_CAPTURE_GROUP_CLOSING_PAREN = ")";
    private static final String REGEX_CAPTURE_GROUP_ELEMENTS_SEPARATOR = "|";
    private static final String SQL_QUERY_STRING_LITERAL_QUOTE_CHAR = "'";

    public static String stripCatalogName(String string, ILogger iLogger, HiveJDBCSettings hiveJDBCSettings, IWarningListener iWarningListener) {
        LogUtilities.logFunctionEntrance(iLogger, string);
        if (string.toUpperCase().startsWith("SET") || string.isEmpty()) {
            return string;
        }
        String string2 = new String(string);
        try {
            if (hiveJDBCSettings.m_useLegacyCatalogRemovalLogic.booleanValue()) {
                string2 = Pattern.compile("[\\s][`\"\\[]?" + hiveJDBCSettings.m_platformCatalog + "[`\"\\]]?[\\.]", 2).matcher(string2).replaceAll(" ");
                string2 = Pattern.compile("\\([`\"\\[]?" + hiveJDBCSettings.m_platformCatalog + "[`\"\\]]?[\\.]", 2).matcher(string2).replaceAll(REGEX_CAPTURE_GROUP_OPENING_PAREN);
                return string2;
            }
            String[] stringArray = string2.split(SQL_QUERY_STRING_LITERAL_QUOTE_CHAR, -1);
            boolean bl = false;
            boolean bl2 = true;
            StringBuffer stringBuffer = new StringBuffer();
            for (String string3 : stringArray) {
                if (!bl) {
                    string3 = HiveCommonQueryTranslationUtils.RemoveCatalogFromQueryStringInternal(hiveJDBCSettings.m_platformCatalog, string3, iLogger);
                }
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuffer.append(SQL_QUERY_STRING_LITERAL_QUOTE_CHAR);
                }
                stringBuffer.append(string3);
                bl = !bl;
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            WarningsUtils.postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, new String("Can't strip catalog name in query.")), iWarningListener, iLogger, hiveJDBCSettings.m_suppressWarningsAsDebugLog);
            return string;
        }
    }

    private static String RemoveCatalogFromQueryStringInternal(String string, String string2, ILogger iLogger) throws Exception {
        LogUtilities.logFunctionEntrance(iLogger, string, string2);
        if (string2.isEmpty()) {
            return string2;
        }
        String string3 = "[\\s](`" + string + BACK_TICK_REGEX_PATTERN + REGEX_CAPTURE_GROUP_ELEMENTS_SEPARATOR + DOUBLE_QUOTE_REGEX_PATTERN + string + DOUBLE_QUOTE_REGEX_PATTERN + REGEX_CAPTURE_GROUP_ELEMENTS_SEPARATOR + OPENING_SQUARE_BRACKET_REGEX_PATTERN + string + CLOSING_SQUARE_BRACKET_REGEX_PATTERN + REGEX_CAPTURE_GROUP_ELEMENTS_SEPARATOR + string + REGEX_CAPTURE_GROUP_CLOSING_PAREN + IDENTIFIER_SEPARATOR_REGEX_PATTERN;
        string2 = Pattern.compile(string3, 2).matcher(string2).replaceAll(" ");
        string3 = "\\((`" + string + BACK_TICK_REGEX_PATTERN + REGEX_CAPTURE_GROUP_ELEMENTS_SEPARATOR + DOUBLE_QUOTE_REGEX_PATTERN + string + DOUBLE_QUOTE_REGEX_PATTERN + REGEX_CAPTURE_GROUP_ELEMENTS_SEPARATOR + OPENING_SQUARE_BRACKET_REGEX_PATTERN + string + CLOSING_SQUARE_BRACKET_REGEX_PATTERN + REGEX_CAPTURE_GROUP_ELEMENTS_SEPARATOR + string + REGEX_CAPTURE_GROUP_CLOSING_PAREN + IDENTIFIER_SEPARATOR_REGEX_PATTERN;
        string2 = Pattern.compile(string3, 2).matcher(string2).replaceAll(" (");
        return string2;
    }
}

