/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api.unifiedmonitoring;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.unifiedmonitoring.ModelStatus;
import com.dataiku.dip.unifiedmonitoring.UnifiedMonitoringDesignComputationService;
import com.dataiku.dip.unifiedmonitoring.payloads.UnifiedMonitoringProxySMVWithModelStatus;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/publicapi"})
public class PublicAPIUnifiedMonitoringDesignController
extends PublicAPIControllerBase {
    @Autowired
    UnifiedMonitoringDesignComputationService unifiedMonitoringDesignComputationService;
    @Autowired
    TransactionService transactionService;
    @Autowired
    MetaAuthService authService;
    @Autowired
    ProjectsService projectsService;
    @Autowired
    PermissionsService permissionsService;

    @AuditedCall(value={"msgType", "unified-monitoring-design-model-status-get", "projectKey", "${projectKey}", "fullModelId", "${fullModelId}"})
    @RequestMapping(value={"/projects/{projectKey}/unified-monitoring-design/model-status/{fullModelId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ModelStatus getModelStatus(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String fullModelId, @RequestParam(required=false) List<String> mesToFilterOn) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        return this.unifiedMonitoringDesignComputationService.getOrComputeModelStatus(projectKey, FullModelId.parse((String)fullModelId), mesToFilterOn);
    }

    @AuditedCall(value={"msgType", "unified-monitoring-design-proxy-model-versions-with-model-status"})
    @RequestMapping(value={"/unified-monitoring-design/proxy-model-versions-with-model-status"}, method={RequestMethod.GET})
    @ResponseBody
    public List<UnifiedMonitoringProxySMVWithModelStatus> getCachedProxyModelVersionsList(HttpServletRequest req) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        return this.unifiedMonitoringDesignComputationService.listProxySmvWithModelStatus();
    }
}

