/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.catalog;

import com.dataiku.dip.server.services.catalog.LuceneResponseWrapper;
import com.dataiku.dip.server.services.catalog.LuceneSecureIndexReader;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.Analyzer;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import com.dataiku.dss.shadelib.org.apache.lucene.document.Document;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import com.dataiku.dss.shadelib.org.apache.lucene.search.highlight.Encoder;
import com.dataiku.dss.shadelib.org.apache.lucene.search.highlight.Formatter;
import com.dataiku.dss.shadelib.org.apache.lucene.search.highlight.Fragmenter;
import com.dataiku.dss.shadelib.org.apache.lucene.search.highlight.Highlighter;
import com.dataiku.dss.shadelib.org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import com.dataiku.dss.shadelib.org.apache.lucene.search.highlight.NullFragmenter;
import com.dataiku.dss.shadelib.org.apache.lucene.search.highlight.QueryScorer;
import com.dataiku.dss.shadelib.org.apache.lucene.search.highlight.Scorer;
import com.dataiku.dss.shadelib.org.apache.lucene.search.highlight.SimpleHTMLEncoder;
import com.dataiku.dss.shadelib.org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import com.dataiku.dss.shadelib.org.apache.lucene.search.highlight.SimpleSpanFragmenter;
import com.dataiku.dss.shadelib.org.apache.lucene.search.vectorhighlight.BoundaryScanner;
import com.dataiku.dss.shadelib.org.apache.lucene.search.vectorhighlight.FastVectorHighlighter;
import com.dataiku.dss.shadelib.org.apache.lucene.search.vectorhighlight.FieldQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.vectorhighlight.FragListBuilder;
import com.dataiku.dss.shadelib.org.apache.lucene.search.vectorhighlight.FragmentsBuilder;
import com.dataiku.dss.shadelib.org.apache.lucene.search.vectorhighlight.ScoreOrderFragmentsBuilder;
import com.dataiku.dss.shadelib.org.apache.lucene.search.vectorhighlight.SimpleBoundaryScanner;
import com.dataiku.dss.shadelib.org.apache.lucene.search.vectorhighlight.SimpleFragListBuilder;
import com.dataiku.dss.shadelib.org.apache.lucene.search.vectorhighlight.SingleFragListBuilder;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LuceneHighlighter {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.catalog.lucene-highlighter");
    private static final String highlightHtmlTag = "em";
    private static final int highlightFragmentSize = 40;
    private static final FastHighlighter fastHighlighter = new FastHighlighter();

    public static void highlight(Query query, LuceneSecureIndexReader secureIndexReader, Document document, int documentId, Set<String> fieldsToHighlight, Set<String> multiValuedFields, Map<String, Boolean> isTermVectorEnabledByField, PerFieldAnalyzerWrapper analyzer, LuceneResponseWrapper.Hit hit) throws IOException {
        StandardHighlighter standardHighlighter = new StandardHighlighter(query);
        FieldQuery fastFieldQuery = fastHighlighter.getFieldQuery(query, secureIndexReader);
        for (String fieldName : secureIndexReader.filterPublicFields(document, fieldsToHighlight)) {
            List<String> fragments = isTermVectorEnabledByField.getOrDefault(fieldName, false) != false ? LuceneHighlighter.getFragmentsWithFastHighlighter(fastFieldQuery, secureIndexReader, documentId, fieldName, multiValuedFields.contains(fieldName)) : LuceneHighlighter.getFragmentsWithStandardHighlighter(standardHighlighter, document, documentId, analyzer, fieldName, multiValuedFields.contains(fieldName));
            if (fragments.isEmpty()) continue;
            hit.highlight.put(fieldName, fragments);
        }
    }

    private static List<String> getFragmentsWithFastHighlighter(FieldQuery fastFieldQuery, LuceneSecureIndexReader secureIndexReader, int documentId, String fieldName, boolean isMultiValuedField) throws IOException {
        String[] fragments = fastHighlighter.getBestFragments(fastFieldQuery, secureIndexReader, documentId, fieldName, isMultiValuedField);
        return Arrays.asList(fragments == null ? new String[]{} : fragments);
    }

    private static List<String> getFragmentsWithStandardHighlighter(StandardHighlighter standardHighlighter, Document document, int documentId, PerFieldAnalyzerWrapper analyzer, String fieldName, boolean isMultiValuedField) throws IOException {
        String[] fieldValues = document.getValues(fieldName);
        if (fieldValues.length > 1 && !isMultiValuedField) {
            logger.warnV("Field [%s] of document [%s] is not expected to be multivalued", new Object[0]);
        }
        LinkedList<String> fragments = new LinkedList<String>();
        for (String fieldValue : fieldValues) {
            try {
                String fragment = standardHighlighter.getBestFragment((Analyzer)analyzer, fieldName, fieldValue, isMultiValuedField);
                if (fragment == null) continue;
                fragments.add(fragment);
            }
            catch (InvalidTokenOffsetsException e) {
                logger.errorV((Throwable)e, "Standard highlight failed for document [%d] on field [%s]", new Object[]{documentId, fieldName});
            }
        }
        return fragments;
    }

    private static String getHighlightHtmlPreTag() {
        return String.format("<%s>", highlightHtmlTag);
    }

    private static String getHighlightHtmlPostTag() {
        return String.format("</%s>", highlightHtmlTag);
    }

    private static class StandardHighlighter {
        private final Highlighter nativeHighlighter;
        private final Fragmenter limitedFragmenter;
        private final Fragmenter unlimitedFragmenter;

        public StandardHighlighter(Query query) {
            QueryScorer queryScorer = new QueryScorer(query);
            this.limitedFragmenter = new SimpleSpanFragmenter(queryScorer, 40);
            this.unlimitedFragmenter = new NullFragmenter();
            this.nativeHighlighter = new Highlighter((Formatter)new SimpleHTMLFormatter(LuceneHighlighter.getHighlightHtmlPreTag(), LuceneHighlighter.getHighlightHtmlPostTag()), (Encoder)new SimpleHTMLEncoder(), (Scorer)queryScorer);
            this.nativeHighlighter.setTextFragmenter(this.limitedFragmenter);
            this.nativeHighlighter.setMaxDocCharsToAnalyze(51200);
        }

        public final String getBestFragment(Analyzer analyzer, String fieldName, String fieldValue, boolean isMultiValuedField) throws IOException, InvalidTokenOffsetsException {
            if (!isMultiValuedField) {
                return this.nativeHighlighter.getBestFragment(analyzer, fieldName, fieldValue);
            }
            this.nativeHighlighter.setTextFragmenter(this.unlimitedFragmenter);
            String bestFragment = this.nativeHighlighter.getBestFragment(analyzer, fieldName, fieldValue);
            this.nativeHighlighter.setTextFragmenter(this.limitedFragmenter);
            return bestFragment;
        }
    }

    private static class FastHighlighter {
        private final FastVectorHighlighter nativeHighlighterWithLimitedFragmenter;
        private final FastVectorHighlighter nativeHighlighterWithUnlimitedFragmenter;

        public FastHighlighter() {
            ScoreOrderFragmentsBuilder fragmentsBuilder = new ScoreOrderFragmentsBuilder(new String[]{LuceneHighlighter.getHighlightHtmlPreTag()}, new String[]{LuceneHighlighter.getHighlightHtmlPostTag()}, (BoundaryScanner)new SimpleBoundaryScanner());
            fragmentsBuilder.setDiscreteMultiValueHighlighting(true);
            this.nativeHighlighterWithLimitedFragmenter = new FastVectorHighlighter(true, true, (FragListBuilder)new SimpleFragListBuilder(), (FragmentsBuilder)fragmentsBuilder);
            this.nativeHighlighterWithUnlimitedFragmenter = new FastVectorHighlighter(true, true, (FragListBuilder)new SingleFragListBuilder(), (FragmentsBuilder)fragmentsBuilder);
        }

        public final String[] getBestFragments(FieldQuery fieldQuery, LuceneSecureIndexReader secureIndexReader, int docId, String fieldName, boolean isMultiValuedField) throws IOException {
            if (!isMultiValuedField) {
                return this.nativeHighlighterWithLimitedFragmenter.getBestFragments(fieldQuery, secureIndexReader.getIndexReader(), docId, fieldName, 40, 1);
            }
            return this.nativeHighlighterWithUnlimitedFragmenter.getBestFragments(fieldQuery, secureIndexReader.getIndexReader(), docId, fieldName, Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        public FieldQuery getFieldQuery(Query query, LuceneSecureIndexReader secureIndexReader) throws IOException {
            return this.nativeHighlighterWithLimitedFragmenter.getFieldQuery(query, secureIndexReader.getIndexReader());
        }
    }
}

