/*
 * Decompiled with CFR 0.152.
 */
package org.apache.toree.boot.layer;

import com.typesafe.config.Config;
import java.io.Serializable;
import org.apache.toree.boot.layer.InterpreterManager;
import org.apache.toree.interpreter.Interpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.BufferLike;

public final class InterpreterManager$
implements scala.Serializable {
    public static InterpreterManager$ MODULE$;
    private final Logger logger;

    static {
        new InterpreterManager$();
    }

    public String $lessinit$greater$default$1() {
        return "Scala";
    }

    public Map<String, Interpreter> $lessinit$greater$default$2() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public Logger logger() {
        return this.logger;
    }

    public InterpreterManager apply(Config config) {
        Buffer ip = ((BufferLike)JavaConverters$.MODULE$.asScalaBufferConverter(config.getStringList("interpreter_plugins")).asScala()).$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(config.getStringList("default_interpreter_plugin")).asScala());
        Map m3 = (Map)ip.foldLeft((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(acc, v) -> {
            Map map2;
            String[] stringArray = v.split(":");
            Option option2 = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (!option2.isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(2) == 0) {
                Map map3;
                String name = (String)((SeqLike)option2.get()).apply(0);
                String className = (String)((SeqLike)option2.get()).apply(1);
                try {
                    Interpreter i = MODULE$.instantiate(className, config);
                    map3 = acc.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)i));
                }
                catch (Throwable e) {
                    MODULE$.logger().error(new StringBuilder(32).append("Error loading interpreter class ").append(className).toString());
                    MODULE$.logger().error(e.getMessage());
                    throw e;
                }
                map2 = map3;
            } else {
                map2 = acc;
            }
            return map2;
        });
        String string2 = config.getString("default_interpreter");
        Map x$1 = m3;
        String x$2 = string2;
        return new InterpreterManager(x$2, (Map<String, Interpreter>)x$1);
    }

    public String apply$default$1() {
        return "Scala";
    }

    public Map<String, Interpreter> apply$default$2() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    private Interpreter instantiate(String className, Config config) {
        Interpreter interpreter;
        try {
            interpreter = (Interpreter)Class.forName(className).getDeclaredConstructor(Class.forName("com.typesafe.config.Config")).newInstance(config);
        }
        catch (NoSuchMethodException e) {
            this.logger().debug(new StringBuilder(36).append("Using default constructor for class ").append(className).toString());
            interpreter = (Interpreter)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return interpreter;
    }

    public InterpreterManager apply(String string2, Map<String, Interpreter> interpreters) {
        return new InterpreterManager(string2, interpreters);
    }

    public Option<Tuple2<String, Map<String, Interpreter>>> unapply(InterpreterManager x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.default(), x$0.interpreters()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private InterpreterManager$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(this.getClass().getName());
    }
}

