/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client.spooling.encoding;

import io.trino.jdbc.$internal.client.QueryDataDecoder;
import io.trino.jdbc.$internal.client.ResultRows;
import io.trino.jdbc.$internal.client.spooling.DataAttribute;
import io.trino.jdbc.$internal.client.spooling.DataAttributes;
import io.trino.jdbc.$internal.guava.base.Verify;
import io.trino.jdbc.$internal.guava.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;

public abstract class CompressedQueryDataDecoder
implements QueryDataDecoder {
    protected final QueryDataDecoder delegate;

    public CompressedQueryDataDecoder(QueryDataDecoder delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    abstract void decompress(byte[] var1, byte[] var2) throws IOException;

    @Override
    public ResultRows decode(InputStream stream, DataAttributes metadata) throws IOException {
        Optional<Integer> expectedDecompressedSize = metadata.getOptional(DataAttribute.UNCOMPRESSED_SIZE, Integer.class);
        int segmentSize = metadata.get(DataAttribute.SEGMENT_SIZE, Integer.class);
        if (expectedDecompressedSize.isPresent()) {
            int uncompressedSize = expectedDecompressedSize.get();
            try (InputStream inputStream2 = stream;){
                byte[] input = new byte[segmentSize];
                byte[] output = new byte[uncompressedSize];
                int readBytes = ByteStreams.read(inputStream2, input, 0, segmentSize);
                Verify.verify(readBytes == segmentSize, "Expected to read %s bytes but got %s", segmentSize, readBytes);
                this.decompress(input, output);
                ResultRows resultRows = this.delegate.decode(new ByteArrayInputStream(output), metadata);
                return resultRows;
            }
        }
        return this.delegate.decode(stream, metadata);
    }
}

