/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.validation;

import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.services.artifacts.IArtifactWorkflowService;
import com.dataiku.gh.core.services.relationships.IRelationshipsService;
import com.dataiku.gh.core.services.validation.IArtifactValidationService;
import com.dataiku.gh.core.services.validation.validators.ArtifactValidator;
import java.io.IOException;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ArtifactValidationService
implements IArtifactValidationService {
    @Autowired
    private IRelationshipsService relationshipsService;
    @Autowired
    private IArtifactWorkflowService artifactWorkflowService;

    @Override
    public void validateArtifact(EnrichedArtifact enrichedArtifact) throws IOException {
        this.validateArtifact(enrichedArtifact, null);
    }

    @Override
    public void validateArtifact(EnrichedArtifact enrichedArtifact, @Nullable EnrichedArtifact previousEnrichedArtifact) throws IOException {
        ArtifactValidator validator = new ArtifactValidator(enrichedArtifact, previousEnrichedArtifact, this.artifactWorkflowService);
        enrichedArtifact.accept(validator);
        this.relationshipsService.validateRelationships(enrichedArtifact);
    }
}

