/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.maintainance;

import com.dataiku.dip.maintainance.AccessLogRotation;
import com.dataiku.dip.maintainance.CleanPerformanceProfiles;
import com.dataiku.dip.maintainance.DkuScheduledTasksService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.utils.Params;
import com.dataiku.gh.ApplicationConfigurator;
import com.dataiku.gh.core.services.security.mappings.UsersMappingsSyncJob;
import com.dataiku.gh.core.services.signoff.ResetSignoffJob;
import com.dataiku.gh.dao.GeneralSettingsDAO;
import com.dataiku.gh.maintainance.BuildGenericUsageSummaryReports;
import com.dataiku.gh.maintainance.GitGCTask;
import java.io.IOException;
import org.quartz.SchedulerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScheduledTasksService
extends DkuScheduledTasksService {
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private TransactionService transactionService;

    protected String describe(String jobGroup, String jobName) {
        switch (jobName) {
            case "git-gc": {
                return "Performs garbage collection and optimization on the internal Git repository";
            }
            case "build-usage-summary-reports": {
                return "Builds internal usage reports";
            }
            case "access-log-rotate": {
                return "Trigger nginx access log daily rotation";
            }
            case "clean-performance-profiles": {
                return "Remove old performance profiles";
            }
            case "reset-signoff": {
                return "Reset sign-offs according to their reset recurrence configuration";
            }
            case "users-mappings-sync": {
                return "Sync user, group, global-api-keys mappings";
            }
        }
        return "-";
    }

    protected void initScheduledTasks() throws IOException, SchedulerException {
        Params params = ApplicationConfigurator.getParams();
        this.addCron(GitGCTask.class, "maintenance", "git-gc", params.getParam("dku.cron.expr.maintenance.git-gc", "0 5 5 * * ?"));
        this.addCron(AccessLogRotation.class, "maintenance", "access-log-rotate", params.getParam("dku.cron.expr.maintenance.access-log-rotate", "0 30 5 * * ?"));
        this.addCron(CleanPerformanceProfiles.class, "maintenance", "clean-performance-profiles", params.getParam("dku.cron.expr.maintenance.clean-performance-profiles", "0 00 8 * * ?"));
        this.addCron(BuildGenericUsageSummaryReports.class, "reporting", "build-usage-summary-reports", params.getParam("dku.cron.expr.reporting.build-usage-summary-report", "3 3 4 ? * 2"));
        this.addCron(UsersMappingsSyncJob.class, "users-mappings", "users-mappings-sync", params.getParam("dku.cron.expr.users-mappings-sync", "0 0 2 * * ?"));
        this.addCron(ResetSignoffJob.class, "signoff", "reset-signoff", params.getParam("dku.cron.expr.reset-signoffs", "0 0 3 * * ?"));
    }
}

