# encoding: utf-8
"""
Executor for containerized execution of python training recipe.
"""

import json
import logging

from dataiku.base.utils import ErrorMonitoringWrapper
from dataiku.doctor.clustering.reg_cluster_recipe import main
from .runner import setup_log, read_execution

if __name__ == "__main__":
    setup_log()
    execution = read_execution()
    execution_id = execution['id']

    with ErrorMonitoringWrapper():
        logging.info("Launching doctor main")
        params = json.loads(execution['payload'])
        main(execution["executionPath"], params['outputDatasetSmartName'], params['keptInputColumns'])
